/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.example.reply.ui.theme

import androidx.compose.ui.graphics.Color

// Generate them via theme builder
// https://material-foundation.github.io/material-theme-builder/#/custom

val replyLightPrimary = Color(0xFF825500)
val replyLightOnPrimary = Color(0xFFFFFFFF)
val replyLightPrimaryContainer = Color(0xFFFFDDAE)
val replyLightOnPrimaryContainer = Color(0xFF2A1800)
val replyLightSecondary = Color(0xFF6F5B40)
val replyLightOnSecondary = Color(0xFFFFFFFF)
val replyLightSecondaryContainer = Color(0xFFFADEBC)
val replyLightOnSecondaryContainer = Color(0xFF271904)
val replyLightTertiary = Color(0xFF516440)
val replyLightOnTertiary = Color(0xFFFFFFFF)
val replyLightTertiaryContainer = Color(0xFFD3EABC)
val replyLightOnTertiaryContainer = Color(0xFF102004)
val replyLightError = Color(0xFFBA1B1B)
val replyLightErrorContainer = Color(0xFFFFDAD4)
val replyLightOnError = Color(0xFFFFFFFF)
val replyLightOnErrorContainer = Color(0xFF410001)
val replyLightBackground = Color(0xFFFCFCFC)
val replyLightOnBackground = Color(0xFF1F1B16)
val replyLightSurface = Color(0xFFFCFCFC)
val replyLightOnSurface = Color(0xFF1F1B16)
val replyLightSurfaceVariant = Color(0xFFF0E0CF)
val replyLightOnSurfaceVariant = Color(0xFF4F4539)
val replyLightOutline = Color(0xFF817567)
val replyLightInverseOnSurface = Color(0xFFF9EFE6)
val replyLightInverseSurface = Color(0xFF34302A)
val replyLightPrimaryInverse = Color(0xFFFFB945)


val replyDarkPrimary = Color(0xFFFFB945)
val replyDarkOnPrimary = Color(0xFF452B00)
val replyDarkPrimaryContainer = Color(0xFF624000)
val replyDarkOnPrimaryContainer = Color(0xFFFFDDAE)
val replyDarkSecondary = Color(0xFFDDC3A2)
val replyDarkOnSecondary = Color(0xFF3E2E16)
val replyDarkSecondaryContainer = Color(0xFF56442B)
val replyDarkOnSecondaryContainer = Color(0xFFFADEBC)
val replyDarkTertiary = Color(0xFFB8CEA2)
val replyDarkOnTertiary = Color(0xFF243516)
val replyDarkTertiaryContainer = Color(0xFF3A4C2B)
val replyDarkOnTertiaryContainer = Color(0xFFD3EABC)
val replyDarkError = Color(0xFFFFB4A9)
val replyDarkErrorContainer = Color(0xFF930006)
val replyDarkOnError = Color(0xFF680003)
val replyDarkOnErrorContainer = Color(0xFFFFDAD4)
val replyDarkBackground = Color(0xFF1F1B16)
val replyDarkOnBackground = Color(0xFFEAE1D9)
val replyDarkSurface = Color(0xFF1F1B16)
val replyDarkOnSurface = Color(0xFFEAE1D9)
val replyDarkSurfaceVariant = Color(0xFF4F4539)
val replyDarkOnSurfaceVariant = Color(0xFFD3C4B4)
val replyDarkOutline = Color(0xFF9C8F80)
val replyDarkInverseOnSurface = Color(0xFF1F1B16)
val replyDarkInverseSurface = Color(0xFFEAE1D9)
val replyDarkPrimaryInverse = Color(0xFF825500)