// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// sample-metadata:
//  title: List database roles
//  usage: node get-database-roles.js <INSTANCE_ID> <DATABASE_ID> <PROJECT_ID>

'use strict';

function main(
  instanceId = 'my-instance',
  databaseId = 'my-database',
  projectId = 'my-project-id',
) {
  // [START spanner_list_database_roles]
  /**
   * TODO(developer): Uncomment these variables before running the sample.
   */
  // const instanceId = 'my-instance';
  // const databaseId = 'my-database';
  // const projectId = 'my-project-id';

  // Imports the Google Cloud client library
  const {Spanner} = require('@google-cloud/spanner');

  // creates a client
  const spanner = new Spanner({
    projectId: projectId,
  });

  const databaseAdminClient = spanner.getDatabaseAdminClient();

  async function getDatabaseRoles() {
    // Fetching database roles
    const [databaseRoles] = await databaseAdminClient.listDatabaseRoles({
      parent: databaseAdminClient.databasePath(
        projectId,
        instanceId,
        databaseId,
      ),
    });
    console.log(
      `Roles for Database: ${databaseAdminClient.databasePath(
        projectId,
        instanceId,
        databaseId,
      )}`,
    );
    databaseRoles.forEach(role => {
      console.log(`Role: ${role.name}`);
    });
  }
  getDatabaseRoles();
  // [END spanner_list_database_roles]
}

process.on('unhandledRejection', err => {
  console.error(err.message);
  process.exitCode = 1;
});
main(...process.argv.slice(2));
