// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **

/* global window */
import type * as gax from 'google-gax';
import type {
  Callback,
  CallOptions,
  Descriptors,
  ClientOptions,
  GrpcClientOptions,
  LROperation,
  PaginationCallback,
  GaxCall,
} from 'google-gax';
import {Transform} from 'stream';
import * as protos from '../../protos/protos';
import jsonProtos = require('../../protos/protos.json');
import {loggingUtils as logging, decodeAnyProtosInArray} from 'google-gax';

/**
 * Client JSON configuration object, loaded from
 * `src/v1/instance_admin_client_config.json`.
 * This file defines retry strategy and timeouts for all API methods in this library.
 */
import * as gapicConfig from './instance_admin_client_config.json';
const version = require('../../../package.json').version;

/**
 *  Cloud Spanner Instance Admin API
 *
 *  The Cloud Spanner Instance Admin API can be used to create, delete,
 *  modify and list instances. Instances are dedicated Cloud Spanner serving
 *  and storage resources to be used by Cloud Spanner databases.
 *
 *  Each instance has a "configuration", which dictates where the
 *  serving resources for the Cloud Spanner instance are located (e.g.,
 *  US-central, Europe). Configurations are created by Google based on
 *  resource availability.
 *
 *  Cloud Spanner billing is based on the instances that exist and their
 *  sizes. After an instance exists, there are no additional
 *  per-database or per-operation charges for use of the instance
 *  (though there may be additional network bandwidth charges).
 *  Instances offer isolation: problems with databases in one instance
 *  will not affect other instances. However, within an instance
 *  databases can affect each other. For example, if one database in an
 *  instance receives a lot of requests and consumes most of the
 *  instance resources, fewer resources are available for other
 *  databases in that instance, and their performance may suffer.
 * @class
 * @memberof v1
 */
export class InstanceAdminClient {
  private _terminated = false;
  private _opts: ClientOptions;
  private _providedCustomServicePath: boolean;
  private _gaxModule: typeof gax | typeof gax.fallback;
  private _gaxGrpc: gax.GrpcClient | gax.fallback.GrpcClient;
  private _protos: {};
  private _defaults: {[method: string]: gax.CallSettings};
  private _universeDomain: string;
  private _servicePath: string;
  private _log = logging.log('spanner');

  auth: gax.GoogleAuth;
  descriptors: Descriptors = {
    page: {},
    stream: {},
    longrunning: {},
    batching: {},
  };
  warn: (code: string, message: string, warnType?: string) => void;
  innerApiCalls: {[name: string]: Function};
  pathTemplates: {[name: string]: gax.PathTemplate};
  operationsClient: gax.OperationsClient;
  instanceAdminStub?: Promise<{[name: string]: Function}>;

  /**
   * Construct an instance of InstanceAdminClient.
   *
   * @param {object} [options] - The configuration object.
   * The options accepted by the constructor are described in detail
   * in [this document](https://github.com/googleapis/gax-nodejs/blob/main/client-libraries.md#creating-the-client-instance).
   * The common options are:
   * @param {object} [options.credentials] - Credentials object.
   * @param {string} [options.credentials.client_email]
   * @param {string} [options.credentials.private_key]
   * @param {string} [options.email] - Account email address. Required when
   *     using a .pem or .p12 keyFilename.
   * @param {string} [options.keyFilename] - Full path to the a .json, .pem, or
   *     .p12 key downloaded from the Google Developers Console. If you provide
   *     a path to a JSON file, the projectId option below is not necessary.
   *     NOTE: .pem and .p12 require you to specify options.email as well.
   * @param {number} [options.port] - The port on which to connect to
   *     the remote host.
   * @param {string} [options.projectId] - The project ID from the Google
   *     Developer's Console, e.g. 'grape-spaceship-123'. We will also check
   *     the environment variable GCLOUD_PROJECT for your project ID. If your
   *     app is running in an environment which supports
   *     {@link https://cloud.google.com/docs/authentication/application-default-credentials Application Default Credentials},
   *     your project ID will be detected automatically.
   * @param {string} [options.apiEndpoint] - The domain name of the
   *     API remote host.
   * @param {gax.ClientConfig} [options.clientConfig] - Client configuration override.
   *     Follows the structure of {@link gapicConfig}.
   * @param {boolean} [options.fallback] - Use HTTP/1.1 REST mode.
   *     For more information, please check the
   *     {@link https://github.com/googleapis/gax-nodejs/blob/main/client-libraries.md#http11-rest-api-mode documentation}.
   * @param {gax} [gaxInstance]: loaded instance of `google-gax`. Useful if you
   *     need to avoid loading the default gRPC version and want to use the fallback
   *     HTTP implementation. Load only fallback version and pass it to the constructor:
   *     ```
   *     const gax = require('google-gax/build/src/fallback'); // avoids loading google-gax with gRPC
   *     const client = new InstanceAdminClient({fallback: true}, gax);
   *     ```
   */
  constructor(
    opts?: ClientOptions,
    gaxInstance?: typeof gax | typeof gax.fallback,
  ) {
    // Ensure that options include all the required fields.
    const staticMembers = this.constructor as typeof InstanceAdminClient;
    if (
      opts?.universe_domain &&
      opts?.universeDomain &&
      opts?.universe_domain !== opts?.universeDomain
    ) {
      throw new Error(
        'Please set either universe_domain or universeDomain, but not both.',
      );
    }
    const universeDomainEnvVar =
      typeof process === 'object' && typeof process.env === 'object'
        ? process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN']
        : undefined;
    this._universeDomain =
      opts?.universeDomain ??
      opts?.universe_domain ??
      universeDomainEnvVar ??
      'googleapis.com';
    this._servicePath = 'spanner.' + this._universeDomain;
    const servicePath =
      opts?.servicePath || opts?.apiEndpoint || this._servicePath;
    this._providedCustomServicePath = !!(
      opts?.servicePath || opts?.apiEndpoint
    );
    const port = opts?.port || staticMembers.port;
    const clientConfig = opts?.clientConfig ?? {};
    const fallback =
      opts?.fallback ??
      (typeof window !== 'undefined' && typeof window?.fetch === 'function');
    opts = Object.assign({servicePath, port, clientConfig, fallback}, opts);

    // Request numeric enum values if REST transport is used.
    opts.numericEnums = true;

    // If scopes are unset in options and we're connecting to a non-default endpoint, set scopes just in case.
    if (servicePath !== this._servicePath && !('scopes' in opts)) {
      opts['scopes'] = staticMembers.scopes;
    }

    // Load google-gax module synchronously if needed
    if (!gaxInstance) {
      gaxInstance = require('google-gax') as typeof gax;
    }

    // Choose either gRPC or proto-over-HTTP implementation of google-gax.
    this._gaxModule = opts.fallback ? gaxInstance.fallback : gaxInstance;

    // Create a `gaxGrpc` object, with any grpc-specific options sent to the client.
    this._gaxGrpc = new this._gaxModule.GrpcClient(opts);

    // Save options to use in initialize() method.
    this._opts = opts;

    // Save the auth object to the client, for use by other methods.
    this.auth = this._gaxGrpc.auth as gax.GoogleAuth;

    // Set useJWTAccessWithScope on the auth object.
    this.auth.useJWTAccessWithScope = true;

    // Set defaultServicePath on the auth object.
    this.auth.defaultServicePath = this._servicePath;

    // Set the default scopes in auth client if needed.
    if (servicePath === this._servicePath) {
      this.auth.defaultScopes = staticMembers.scopes;
    }

    // Determine the client header string.
    const clientHeader = [`gax/${this._gaxModule.version}`, `gapic/${version}`];
    if (typeof process === 'object' && 'versions' in process) {
      clientHeader.push(`gl-node/${process.versions.node}`);
    } else {
      clientHeader.push(`gl-web/${this._gaxModule.version}`);
    }
    if (!opts.fallback) {
      clientHeader.push(`grpc/${this._gaxGrpc.grpcVersion}`);
    } else {
      clientHeader.push(`rest/${this._gaxGrpc.grpcVersion}`);
    }
    if (opts.libName && opts.libVersion) {
      clientHeader.push(`${opts.libName}/${opts.libVersion}`);
    }
    // Load the applicable protos.
    this._protos = this._gaxGrpc.loadProtoJSON(jsonProtos);

    // This API contains "path templates"; forward-slash-separated
    // identifiers to uniquely identify resources within the API.
    // Create useful helper objects for these.
    this.pathTemplates = {
      instancePathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/instances/{instance}',
      ),
      instanceConfigPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/instanceConfigs/{instance_config}',
      ),
      instancePartitionPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}/instances/{instance}/instancePartitions/{instance_partition}',
      ),
      projectPathTemplate: new this._gaxModule.PathTemplate(
        'projects/{project}',
      ),
    };

    // Some of the methods on this service return "paged" results,
    // (e.g. 50 results at a time, with tokens to get subsequent
    // pages). Denote the keys used for pagination and results.
    this.descriptors.page = {
      listInstanceConfigs: new this._gaxModule.PageDescriptor(
        'pageToken',
        'nextPageToken',
        'instanceConfigs',
      ),
      listInstanceConfigOperations: new this._gaxModule.PageDescriptor(
        'pageToken',
        'nextPageToken',
        'operations',
      ),
      listInstances: new this._gaxModule.PageDescriptor(
        'pageToken',
        'nextPageToken',
        'instances',
      ),
      listInstancePartitions: new this._gaxModule.PageDescriptor(
        'pageToken',
        'nextPageToken',
        'instancePartitions',
      ),
      listInstancePartitionOperations: new this._gaxModule.PageDescriptor(
        'pageToken',
        'nextPageToken',
        'operations',
      ),
    };

    const protoFilesRoot = this._gaxModule.protobufFromJSON(jsonProtos);
    // This API contains "long-running operations", which return a
    // an Operation object that allows for tracking of the operation,
    // rather than holding a request open.
    const lroOptions: GrpcClientOptions = {
      auth: this.auth,
      grpc: 'grpc' in this._gaxGrpc ? this._gaxGrpc.grpc : undefined,
    };
    if (opts.fallback) {
      lroOptions.protoJson = protoFilesRoot;
      lroOptions.httpRules = [
        {
          selector: 'google.longrunning.Operations.CancelOperation',
          post: '/v1/{name=projects/*/instances/*/databases/*/operations/*}:cancel',
          additional_bindings: [
            {post: '/v1/{name=projects/*/instances/*/operations/*}:cancel'},
            {
              post: '/v1/{name=projects/*/instances/*/backups/*/operations/*}:cancel',
            },
            {
              post: '/v1/{name=projects/*/instances/*/instancePartitions/*/operations/*}:cancel',
            },
            {
              post: '/v1/{name=projects/*/instanceConfigs/*/operations/*}:cancel',
            },
            {
              post: '/v1/{name=projects/*/instanceConfigs/*/ssdCaches/*/operations/*}:cancel',
            },
          ],
        },
        {
          selector: 'google.longrunning.Operations.DeleteOperation',
          delete: '/v1/{name=projects/*/instances/*/databases/*/operations/*}',
          additional_bindings: [
            {delete: '/v1/{name=projects/*/instances/*/operations/*}'},
            {
              delete:
                '/v1/{name=projects/*/instances/*/backups/*/operations/*}',
            },
            {
              delete:
                '/v1/{name=projects/*/instances/*/instancePartitions/*/operations/*}',
            },
            {delete: '/v1/{name=projects/*/instanceConfigs/*/operations/*}'},
            {
              delete:
                '/v1/{name=projects/*/instanceConfigs/*/ssdCaches/*/operations/*}',
            },
          ],
        },
        {
          selector: 'google.longrunning.Operations.GetOperation',
          get: '/v1/{name=projects/*/instances/*/databases/*/operations/*}',
          additional_bindings: [
            {get: '/v1/{name=projects/*/instances/*/operations/*}'},
            {get: '/v1/{name=projects/*/instances/*/backups/*/operations/*}'},
            {
              get: '/v1/{name=projects/*/instances/*/instancePartitions/*/operations/*}',
            },
            {get: '/v1/{name=projects/*/instanceConfigs/*/operations/*}'},
            {
              get: '/v1/{name=projects/*/instanceConfigs/*/ssdCaches/*/operations/*}',
            },
          ],
        },
        {
          selector: 'google.longrunning.Operations.ListOperations',
          get: '/v1/{name=projects/*/instances/*/databases/*/operations}',
          additional_bindings: [
            {get: '/v1/{name=projects/*/instances/*/operations}'},
            {get: '/v1/{name=projects/*/instances/*/backups/*/operations}'},
            {
              get: '/v1/{name=projects/*/instances/*/instancePartitions/*/operations}',
            },
            {get: '/v1/{name=projects/*/instanceConfigs/*/operations}'},
            {
              get: '/v1/{name=projects/*/instanceConfigs/*/ssdCaches/*/operations}',
            },
          ],
        },
      ];
    }
    this.operationsClient = this._gaxModule
      .lro(lroOptions)
      .operationsClient(opts);
    const createInstanceConfigResponse = protoFilesRoot.lookup(
      '.google.spanner.admin.instance.v1.InstanceConfig',
    ) as gax.protobuf.Type;
    const createInstanceConfigMetadata = protoFilesRoot.lookup(
      '.google.spanner.admin.instance.v1.CreateInstanceConfigMetadata',
    ) as gax.protobuf.Type;
    const updateInstanceConfigResponse = protoFilesRoot.lookup(
      '.google.spanner.admin.instance.v1.InstanceConfig',
    ) as gax.protobuf.Type;
    const updateInstanceConfigMetadata = protoFilesRoot.lookup(
      '.google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata',
    ) as gax.protobuf.Type;
    const createInstanceResponse = protoFilesRoot.lookup(
      '.google.spanner.admin.instance.v1.Instance',
    ) as gax.protobuf.Type;
    const createInstanceMetadata = protoFilesRoot.lookup(
      '.google.spanner.admin.instance.v1.CreateInstanceMetadata',
    ) as gax.protobuf.Type;
    const updateInstanceResponse = protoFilesRoot.lookup(
      '.google.spanner.admin.instance.v1.Instance',
    ) as gax.protobuf.Type;
    const updateInstanceMetadata = protoFilesRoot.lookup(
      '.google.spanner.admin.instance.v1.UpdateInstanceMetadata',
    ) as gax.protobuf.Type;
    const createInstancePartitionResponse = protoFilesRoot.lookup(
      '.google.spanner.admin.instance.v1.InstancePartition',
    ) as gax.protobuf.Type;
    const createInstancePartitionMetadata = protoFilesRoot.lookup(
      '.google.spanner.admin.instance.v1.CreateInstancePartitionMetadata',
    ) as gax.protobuf.Type;
    const updateInstancePartitionResponse = protoFilesRoot.lookup(
      '.google.spanner.admin.instance.v1.InstancePartition',
    ) as gax.protobuf.Type;
    const updateInstancePartitionMetadata = protoFilesRoot.lookup(
      '.google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata',
    ) as gax.protobuf.Type;
    const moveInstanceResponse = protoFilesRoot.lookup(
      '.google.spanner.admin.instance.v1.MoveInstanceResponse',
    ) as gax.protobuf.Type;
    const moveInstanceMetadata = protoFilesRoot.lookup(
      '.google.spanner.admin.instance.v1.MoveInstanceMetadata',
    ) as gax.protobuf.Type;

    this.descriptors.longrunning = {
      createInstanceConfig: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        createInstanceConfigResponse.decode.bind(createInstanceConfigResponse),
        createInstanceConfigMetadata.decode.bind(createInstanceConfigMetadata),
      ),
      updateInstanceConfig: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        updateInstanceConfigResponse.decode.bind(updateInstanceConfigResponse),
        updateInstanceConfigMetadata.decode.bind(updateInstanceConfigMetadata),
      ),
      createInstance: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        createInstanceResponse.decode.bind(createInstanceResponse),
        createInstanceMetadata.decode.bind(createInstanceMetadata),
      ),
      updateInstance: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        updateInstanceResponse.decode.bind(updateInstanceResponse),
        updateInstanceMetadata.decode.bind(updateInstanceMetadata),
      ),
      createInstancePartition: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        createInstancePartitionResponse.decode.bind(
          createInstancePartitionResponse,
        ),
        createInstancePartitionMetadata.decode.bind(
          createInstancePartitionMetadata,
        ),
      ),
      updateInstancePartition: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        updateInstancePartitionResponse.decode.bind(
          updateInstancePartitionResponse,
        ),
        updateInstancePartitionMetadata.decode.bind(
          updateInstancePartitionMetadata,
        ),
      ),
      moveInstance: new this._gaxModule.LongrunningDescriptor(
        this.operationsClient,
        moveInstanceResponse.decode.bind(moveInstanceResponse),
        moveInstanceMetadata.decode.bind(moveInstanceMetadata),
      ),
    };

    // Put together the default options sent with requests.
    this._defaults = this._gaxGrpc.constructSettings(
      'google.spanner.admin.instance.v1.InstanceAdmin',
      gapicConfig as gax.ClientConfig,
      opts.clientConfig || {},
      {'x-goog-api-client': clientHeader.join(' ')},
    );

    // Set up a dictionary of "inner API calls"; the core implementation
    // of calling the API is handled in `google-gax`, with this code
    // merely providing the destination and request information.
    this.innerApiCalls = {};

    // Add a warn function to the client constructor so it can be easily tested.
    this.warn = this._gaxModule.warn;
  }

  /**
   * Initialize the client.
   * Performs asynchronous operations (such as authentication) and prepares the client.
   * This function will be called automatically when any class method is called for the
   * first time, but if you need to initialize it before calling an actual method,
   * feel free to call initialize() directly.
   *
   * You can await on this method if you want to make sure the client is initialized.
   *
   * @returns {Promise} A promise that resolves to an authenticated service stub.
   */
  initialize() {
    // If the client stub promise is already initialized, return immediately.
    if (this.instanceAdminStub) {
      return this.instanceAdminStub;
    }

    // Put together the "service stub" for
    // google.spanner.admin.instance.v1.InstanceAdmin.
    this.instanceAdminStub = this._gaxGrpc.createStub(
      this._opts.fallback
        ? (this._protos as protobuf.Root).lookupService(
            'google.spanner.admin.instance.v1.InstanceAdmin',
          )
        : // eslint-disable-next-line @typescript-eslint/no-explicit-any
          (this._protos as any).google.spanner.admin.instance.v1.InstanceAdmin,
      this._opts,
      this._providedCustomServicePath,
    ) as Promise<{[method: string]: Function}>;

    // Iterate over each of the methods that the service provides
    // and create an API call method for each.
    const instanceAdminStubMethods = [
      'listInstanceConfigs',
      'getInstanceConfig',
      'createInstanceConfig',
      'updateInstanceConfig',
      'deleteInstanceConfig',
      'listInstanceConfigOperations',
      'listInstances',
      'listInstancePartitions',
      'getInstance',
      'createInstance',
      'updateInstance',
      'deleteInstance',
      'setIamPolicy',
      'getIamPolicy',
      'testIamPermissions',
      'getInstancePartition',
      'createInstancePartition',
      'deleteInstancePartition',
      'updateInstancePartition',
      'listInstancePartitionOperations',
      'moveInstance',
    ];
    for (const methodName of instanceAdminStubMethods) {
      const callPromise = this.instanceAdminStub.then(
        stub =>
          (...args: Array<{}>) => {
            if (this._terminated) {
              return Promise.reject('The client has already been closed.');
            }
            const func = stub[methodName];
            return func.apply(stub, args);
          },
        (err: Error | null | undefined) => () => {
          throw err;
        },
      );

      const descriptor =
        this.descriptors.page[methodName] ||
        this.descriptors.longrunning[methodName] ||
        undefined;
      const apiCall = this._gaxModule.createApiCall(
        callPromise,
        this._defaults[methodName],
        descriptor,
        this._opts.fallback,
      );

      this.innerApiCalls[methodName] = apiCall;
    }

    return this.instanceAdminStub;
  }

  /**
   * The DNS address for this API service.
   * @deprecated Use the apiEndpoint method of the client instance.
   * @returns {string} The DNS address for this service.
   */
  static get servicePath() {
    if (
      typeof process === 'object' &&
      typeof process.emitWarning === 'function'
    ) {
      process.emitWarning(
        'Static servicePath is deprecated, please use the instance method instead.',
        'DeprecationWarning',
      );
    }
    return 'spanner.googleapis.com';
  }

  /**
   * The DNS address for this API service - same as servicePath.
   * @deprecated Use the apiEndpoint method of the client instance.
   * @returns {string} The DNS address for this service.
   */
  static get apiEndpoint() {
    if (
      typeof process === 'object' &&
      typeof process.emitWarning === 'function'
    ) {
      process.emitWarning(
        'Static apiEndpoint is deprecated, please use the instance method instead.',
        'DeprecationWarning',
      );
    }
    return 'spanner.googleapis.com';
  }

  /**
   * The DNS address for this API service.
   * @returns {string} The DNS address for this service.
   */
  get apiEndpoint() {
    return this._servicePath;
  }

  get universeDomain() {
    return this._universeDomain;
  }

  /**
   * The port for this API service.
   * @returns {number} The default port for this service.
   */
  static get port() {
    return 443;
  }

  /**
   * The scopes needed to make gRPC calls for every method defined
   * in this service.
   * @returns {string[]} List of default scopes.
   */
  static get scopes() {
    return [
      'https://www.googleapis.com/auth/cloud-platform',
      'https://www.googleapis.com/auth/spanner.admin',
    ];
  }

  getProjectId(): Promise<string>;
  getProjectId(callback: Callback<string, undefined, undefined>): void;
  /**
   * Return the project ID used by this class.
   * @returns {Promise} A promise that resolves to string containing the project ID.
   */
  getProjectId(
    callback?: Callback<string, undefined, undefined>,
  ): Promise<string> | void {
    if (callback) {
      this.auth.getProjectId(callback);
      return;
    }
    return this.auth.getProjectId();
  }

  // -------------------
  // -- Service calls --
  // -------------------
  /**
   * Gets information about a particular instance configuration.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Required. The name of the requested instance configuration. Values are of
   *   the form `projects/<project>/instanceConfigs/<config>`.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing {@link protos.google.spanner.admin.instance.v1.InstanceConfig|InstanceConfig}.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
   *   for more details and examples.
   */
  getInstanceConfig(
    request?: protos.google.spanner.admin.instance.v1.IGetInstanceConfigRequest,
    options?: CallOptions,
  ): Promise<
    [
      protos.google.spanner.admin.instance.v1.IInstanceConfig,
      (
        | protos.google.spanner.admin.instance.v1.IGetInstanceConfigRequest
        | undefined
      ),
      {} | undefined,
    ]
  >;
  getInstanceConfig(
    request: protos.google.spanner.admin.instance.v1.IGetInstanceConfigRequest,
    options: CallOptions,
    callback: Callback<
      protos.google.spanner.admin.instance.v1.IInstanceConfig,
      | protos.google.spanner.admin.instance.v1.IGetInstanceConfigRequest
      | null
      | undefined,
      {} | null | undefined
    >,
  ): void;
  getInstanceConfig(
    request: protos.google.spanner.admin.instance.v1.IGetInstanceConfigRequest,
    callback: Callback<
      protos.google.spanner.admin.instance.v1.IInstanceConfig,
      | protos.google.spanner.admin.instance.v1.IGetInstanceConfigRequest
      | null
      | undefined,
      {} | null | undefined
    >,
  ): void;
  getInstanceConfig(
    request?: protos.google.spanner.admin.instance.v1.IGetInstanceConfigRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          protos.google.spanner.admin.instance.v1.IInstanceConfig,
          | protos.google.spanner.admin.instance.v1.IGetInstanceConfigRequest
          | null
          | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.spanner.admin.instance.v1.IInstanceConfig,
      | protos.google.spanner.admin.instance.v1.IGetInstanceConfigRequest
      | null
      | undefined,
      {} | null | undefined
    >,
  ): Promise<
    [
      protos.google.spanner.admin.instance.v1.IInstanceConfig,
      (
        | protos.google.spanner.admin.instance.v1.IGetInstanceConfigRequest
        | undefined
      ),
      {} | undefined,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        name: request.name ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('getInstanceConfig request %j', request);
    const wrappedCallback:
      | Callback<
          protos.google.spanner.admin.instance.v1.IInstanceConfig,
          | protos.google.spanner.admin.instance.v1.IGetInstanceConfigRequest
          | null
          | undefined,
          {} | null | undefined
        >
      | undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getInstanceConfig response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls
      .getInstanceConfig(request, options, wrappedCallback)
      ?.then(
        ([response, options, rawResponse]: [
          protos.google.spanner.admin.instance.v1.IInstanceConfig,
          (
            | protos.google.spanner.admin.instance.v1.IGetInstanceConfigRequest
            | undefined
          ),
          {} | undefined,
        ]) => {
          this._log.info('getInstanceConfig response %j', response);
          return [response, options, rawResponse];
        },
      )
      .catch((error: any) => {
        if (
          error &&
          'statusDetails' in error &&
          error.statusDetails instanceof Array
        ) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(
            jsonProtos,
          ) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(
            error.statusDetails,
            protos,
          );
        }
        throw error;
      });
  }
  /**
   * Deletes the instance configuration. Deletion is only allowed when no
   * instances are using the configuration. If any instances are using
   * the configuration, returns `FAILED_PRECONDITION`.
   *
   * Only user-managed configurations can be deleted.
   *
   * Authorization requires `spanner.instanceConfigs.delete` permission on
   * the resource {@link protos.google.spanner.admin.instance.v1.InstanceConfig.name|name}.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Required. The name of the instance configuration to be deleted.
   *   Values are of the form
   *   `projects/<project>/instanceConfigs/<instance_config>`
   * @param {string} request.etag
   *   Used for optimistic concurrency control as a way to help prevent
   *   simultaneous deletes of an instance configuration from overwriting each
   *   other. If not empty, the API
   *   only deletes the instance configuration when the etag provided matches the
   *   current status of the requested instance configuration. Otherwise, deletes
   *   the instance configuration without checking the current status of the
   *   requested instance configuration.
   * @param {boolean} request.validateOnly
   *   An option to validate, but not actually execute, a request,
   *   and provide the same response.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing {@link protos.google.protobuf.Empty|Empty}.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
   *   for more details and examples.
   */
  deleteInstanceConfig(
    request?: protos.google.spanner.admin.instance.v1.IDeleteInstanceConfigRequest,
    options?: CallOptions,
  ): Promise<
    [
      protos.google.protobuf.IEmpty,
      (
        | protos.google.spanner.admin.instance.v1.IDeleteInstanceConfigRequest
        | undefined
      ),
      {} | undefined,
    ]
  >;
  deleteInstanceConfig(
    request: protos.google.spanner.admin.instance.v1.IDeleteInstanceConfigRequest,
    options: CallOptions,
    callback: Callback<
      protos.google.protobuf.IEmpty,
      | protos.google.spanner.admin.instance.v1.IDeleteInstanceConfigRequest
      | null
      | undefined,
      {} | null | undefined
    >,
  ): void;
  deleteInstanceConfig(
    request: protos.google.spanner.admin.instance.v1.IDeleteInstanceConfigRequest,
    callback: Callback<
      protos.google.protobuf.IEmpty,
      | protos.google.spanner.admin.instance.v1.IDeleteInstanceConfigRequest
      | null
      | undefined,
      {} | null | undefined
    >,
  ): void;
  deleteInstanceConfig(
    request?: protos.google.spanner.admin.instance.v1.IDeleteInstanceConfigRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          protos.google.protobuf.IEmpty,
          | protos.google.spanner.admin.instance.v1.IDeleteInstanceConfigRequest
          | null
          | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.protobuf.IEmpty,
      | protos.google.spanner.admin.instance.v1.IDeleteInstanceConfigRequest
      | null
      | undefined,
      {} | null | undefined
    >,
  ): Promise<
    [
      protos.google.protobuf.IEmpty,
      (
        | protos.google.spanner.admin.instance.v1.IDeleteInstanceConfigRequest
        | undefined
      ),
      {} | undefined,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        name: request.name ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('deleteInstanceConfig request %j', request);
    const wrappedCallback:
      | Callback<
          protos.google.protobuf.IEmpty,
          | protos.google.spanner.admin.instance.v1.IDeleteInstanceConfigRequest
          | null
          | undefined,
          {} | null | undefined
        >
      | undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('deleteInstanceConfig response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls
      .deleteInstanceConfig(request, options, wrappedCallback)
      ?.then(
        ([response, options, rawResponse]: [
          protos.google.protobuf.IEmpty,
          (
            | protos.google.spanner.admin.instance.v1.IDeleteInstanceConfigRequest
            | undefined
          ),
          {} | undefined,
        ]) => {
          this._log.info('deleteInstanceConfig response %j', response);
          return [response, options, rawResponse];
        },
      )
      .catch((error: any) => {
        if (
          error &&
          'statusDetails' in error &&
          error.statusDetails instanceof Array
        ) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(
            jsonProtos,
          ) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(
            error.statusDetails,
            protos,
          );
        }
        throw error;
      });
  }
  /**
   * Gets information about a particular instance.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Required. The name of the requested instance. Values are of the form
   *   `projects/<project>/instances/<instance>`.
   * @param {google.protobuf.FieldMask} request.fieldMask
   *   If field_mask is present, specifies the subset of
   *   {@link protos.google.spanner.admin.instance.v1.Instance|Instance} fields that should be
   *   returned. If absent, all
   *   {@link protos.google.spanner.admin.instance.v1.Instance|Instance} fields are returned.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing {@link protos.google.spanner.admin.instance.v1.Instance|Instance}.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
   *   for more details and examples.
   */
  getInstance(
    request?: protos.google.spanner.admin.instance.v1.IGetInstanceRequest,
    options?: CallOptions,
  ): Promise<
    [
      protos.google.spanner.admin.instance.v1.IInstance,
      protos.google.spanner.admin.instance.v1.IGetInstanceRequest | undefined,
      {} | undefined,
    ]
  >;
  getInstance(
    request: protos.google.spanner.admin.instance.v1.IGetInstanceRequest,
    options: CallOptions,
    callback: Callback<
      protos.google.spanner.admin.instance.v1.IInstance,
      | protos.google.spanner.admin.instance.v1.IGetInstanceRequest
      | null
      | undefined,
      {} | null | undefined
    >,
  ): void;
  getInstance(
    request: protos.google.spanner.admin.instance.v1.IGetInstanceRequest,
    callback: Callback<
      protos.google.spanner.admin.instance.v1.IInstance,
      | protos.google.spanner.admin.instance.v1.IGetInstanceRequest
      | null
      | undefined,
      {} | null | undefined
    >,
  ): void;
  getInstance(
    request?: protos.google.spanner.admin.instance.v1.IGetInstanceRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          protos.google.spanner.admin.instance.v1.IInstance,
          | protos.google.spanner.admin.instance.v1.IGetInstanceRequest
          | null
          | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.spanner.admin.instance.v1.IInstance,
      | protos.google.spanner.admin.instance.v1.IGetInstanceRequest
      | null
      | undefined,
      {} | null | undefined
    >,
  ): Promise<
    [
      protos.google.spanner.admin.instance.v1.IInstance,
      protos.google.spanner.admin.instance.v1.IGetInstanceRequest | undefined,
      {} | undefined,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        name: request.name ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('getInstance request %j', request);
    const wrappedCallback:
      | Callback<
          protos.google.spanner.admin.instance.v1.IInstance,
          | protos.google.spanner.admin.instance.v1.IGetInstanceRequest
          | null
          | undefined,
          {} | null | undefined
        >
      | undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getInstance response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls
      .getInstance(request, options, wrappedCallback)
      ?.then(
        ([response, options, rawResponse]: [
          protos.google.spanner.admin.instance.v1.IInstance,
          (
            | protos.google.spanner.admin.instance.v1.IGetInstanceRequest
            | undefined
          ),
          {} | undefined,
        ]) => {
          this._log.info('getInstance response %j', response);
          return [response, options, rawResponse];
        },
      )
      .catch((error: any) => {
        if (
          error &&
          'statusDetails' in error &&
          error.statusDetails instanceof Array
        ) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(
            jsonProtos,
          ) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(
            error.statusDetails,
            protos,
          );
        }
        throw error;
      });
  }
  /**
   * Deletes an instance.
   *
   * Immediately upon completion of the request:
   *
   *   * Billing ceases for all of the instance's reserved resources.
   *
   * Soon afterward:
   *
   *   * The instance and *all of its databases* immediately and
   *     irrevocably disappear from the API. All data in the databases
   *     is permanently deleted.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Required. The name of the instance to be deleted. Values are of the form
   *   `projects/<project>/instances/<instance>`
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing {@link protos.google.protobuf.Empty|Empty}.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
   *   for more details and examples.
   */
  deleteInstance(
    request?: protos.google.spanner.admin.instance.v1.IDeleteInstanceRequest,
    options?: CallOptions,
  ): Promise<
    [
      protos.google.protobuf.IEmpty,
      (
        | protos.google.spanner.admin.instance.v1.IDeleteInstanceRequest
        | undefined
      ),
      {} | undefined,
    ]
  >;
  deleteInstance(
    request: protos.google.spanner.admin.instance.v1.IDeleteInstanceRequest,
    options: CallOptions,
    callback: Callback<
      protos.google.protobuf.IEmpty,
      | protos.google.spanner.admin.instance.v1.IDeleteInstanceRequest
      | null
      | undefined,
      {} | null | undefined
    >,
  ): void;
  deleteInstance(
    request: protos.google.spanner.admin.instance.v1.IDeleteInstanceRequest,
    callback: Callback<
      protos.google.protobuf.IEmpty,
      | protos.google.spanner.admin.instance.v1.IDeleteInstanceRequest
      | null
      | undefined,
      {} | null | undefined
    >,
  ): void;
  deleteInstance(
    request?: protos.google.spanner.admin.instance.v1.IDeleteInstanceRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          protos.google.protobuf.IEmpty,
          | protos.google.spanner.admin.instance.v1.IDeleteInstanceRequest
          | null
          | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.protobuf.IEmpty,
      | protos.google.spanner.admin.instance.v1.IDeleteInstanceRequest
      | null
      | undefined,
      {} | null | undefined
    >,
  ): Promise<
    [
      protos.google.protobuf.IEmpty,
      (
        | protos.google.spanner.admin.instance.v1.IDeleteInstanceRequest
        | undefined
      ),
      {} | undefined,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        name: request.name ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('deleteInstance request %j', request);
    const wrappedCallback:
      | Callback<
          protos.google.protobuf.IEmpty,
          | protos.google.spanner.admin.instance.v1.IDeleteInstanceRequest
          | null
          | undefined,
          {} | null | undefined
        >
      | undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('deleteInstance response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls
      .deleteInstance(request, options, wrappedCallback)
      ?.then(
        ([response, options, rawResponse]: [
          protos.google.protobuf.IEmpty,
          (
            | protos.google.spanner.admin.instance.v1.IDeleteInstanceRequest
            | undefined
          ),
          {} | undefined,
        ]) => {
          this._log.info('deleteInstance response %j', response);
          return [response, options, rawResponse];
        },
      )
      .catch((error: any) => {
        if (
          error &&
          'statusDetails' in error &&
          error.statusDetails instanceof Array
        ) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(
            jsonProtos,
          ) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(
            error.statusDetails,
            protos,
          );
        }
        throw error;
      });
  }
  /**
   * Sets the access control policy on an instance resource. Replaces any
   * existing policy.
   *
   * Authorization requires `spanner.instances.setIamPolicy` on
   * {@link protos.google.iam.v1.SetIamPolicyRequest.resource|resource}.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.resource
   *   REQUIRED: The resource for which the policy is being specified.
   *   See the operation documentation for the appropriate value for this field.
   * @param {google.iam.v1.Policy} request.policy
   *   REQUIRED: The complete policy to be applied to the `resource`. The size of
   *   the policy is limited to a few 10s of KB. An empty policy is a
   *   valid policy but certain Cloud Platform services (such as Projects)
   *   might reject them.
   * @param {google.protobuf.FieldMask} request.updateMask
   *   OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
   *   the fields in the mask will be modified. If no mask is provided, the
   *   following default mask is used:
   *
   *   `paths: "bindings, etag"`
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing {@link protos.google.iam.v1.Policy|Policy}.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
   *   for more details and examples.
   */
  setIamPolicy(
    request?: protos.google.iam.v1.ISetIamPolicyRequest,
    options?: CallOptions,
  ): Promise<
    [
      protos.google.iam.v1.IPolicy,
      protos.google.iam.v1.ISetIamPolicyRequest | undefined,
      {} | undefined,
    ]
  >;
  setIamPolicy(
    request: protos.google.iam.v1.ISetIamPolicyRequest,
    options: CallOptions,
    callback: Callback<
      protos.google.iam.v1.IPolicy,
      protos.google.iam.v1.ISetIamPolicyRequest | null | undefined,
      {} | null | undefined
    >,
  ): void;
  setIamPolicy(
    request: protos.google.iam.v1.ISetIamPolicyRequest,
    callback: Callback<
      protos.google.iam.v1.IPolicy,
      protos.google.iam.v1.ISetIamPolicyRequest | null | undefined,
      {} | null | undefined
    >,
  ): void;
  setIamPolicy(
    request?: protos.google.iam.v1.ISetIamPolicyRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          protos.google.iam.v1.IPolicy,
          protos.google.iam.v1.ISetIamPolicyRequest | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.iam.v1.IPolicy,
      protos.google.iam.v1.ISetIamPolicyRequest | null | undefined,
      {} | null | undefined
    >,
  ): Promise<
    [
      protos.google.iam.v1.IPolicy,
      protos.google.iam.v1.ISetIamPolicyRequest | undefined,
      {} | undefined,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        resource: request.resource ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('setIamPolicy request %j', request);
    const wrappedCallback:
      | Callback<
          protos.google.iam.v1.IPolicy,
          protos.google.iam.v1.ISetIamPolicyRequest | null | undefined,
          {} | null | undefined
        >
      | undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('setIamPolicy response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls
      .setIamPolicy(request, options, wrappedCallback)
      ?.then(
        ([response, options, rawResponse]: [
          protos.google.iam.v1.IPolicy,
          protos.google.iam.v1.ISetIamPolicyRequest | undefined,
          {} | undefined,
        ]) => {
          this._log.info('setIamPolicy response %j', response);
          return [response, options, rawResponse];
        },
      )
      .catch((error: any) => {
        if (
          error &&
          'statusDetails' in error &&
          error.statusDetails instanceof Array
        ) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(
            jsonProtos,
          ) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(
            error.statusDetails,
            protos,
          );
        }
        throw error;
      });
  }
  /**
   * Gets the access control policy for an instance resource. Returns an empty
   * policy if an instance exists but does not have a policy set.
   *
   * Authorization requires `spanner.instances.getIamPolicy` on
   * {@link protos.google.iam.v1.GetIamPolicyRequest.resource|resource}.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.resource
   *   REQUIRED: The resource for which the policy is being requested.
   *   See the operation documentation for the appropriate value for this field.
   * @param {google.iam.v1.GetPolicyOptions} request.options
   *   OPTIONAL: A `GetPolicyOptions` object for specifying options to
   *   `GetIamPolicy`.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing {@link protos.google.iam.v1.Policy|Policy}.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
   *   for more details and examples.
   */
  getIamPolicy(
    request?: protos.google.iam.v1.IGetIamPolicyRequest,
    options?: CallOptions,
  ): Promise<
    [
      protos.google.iam.v1.IPolicy,
      protos.google.iam.v1.IGetIamPolicyRequest | undefined,
      {} | undefined,
    ]
  >;
  getIamPolicy(
    request: protos.google.iam.v1.IGetIamPolicyRequest,
    options: CallOptions,
    callback: Callback<
      protos.google.iam.v1.IPolicy,
      protos.google.iam.v1.IGetIamPolicyRequest | null | undefined,
      {} | null | undefined
    >,
  ): void;
  getIamPolicy(
    request: protos.google.iam.v1.IGetIamPolicyRequest,
    callback: Callback<
      protos.google.iam.v1.IPolicy,
      protos.google.iam.v1.IGetIamPolicyRequest | null | undefined,
      {} | null | undefined
    >,
  ): void;
  getIamPolicy(
    request?: protos.google.iam.v1.IGetIamPolicyRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          protos.google.iam.v1.IPolicy,
          protos.google.iam.v1.IGetIamPolicyRequest | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.iam.v1.IPolicy,
      protos.google.iam.v1.IGetIamPolicyRequest | null | undefined,
      {} | null | undefined
    >,
  ): Promise<
    [
      protos.google.iam.v1.IPolicy,
      protos.google.iam.v1.IGetIamPolicyRequest | undefined,
      {} | undefined,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        resource: request.resource ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('getIamPolicy request %j', request);
    const wrappedCallback:
      | Callback<
          protos.google.iam.v1.IPolicy,
          protos.google.iam.v1.IGetIamPolicyRequest | null | undefined,
          {} | null | undefined
        >
      | undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getIamPolicy response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls
      .getIamPolicy(request, options, wrappedCallback)
      ?.then(
        ([response, options, rawResponse]: [
          protos.google.iam.v1.IPolicy,
          protos.google.iam.v1.IGetIamPolicyRequest | undefined,
          {} | undefined,
        ]) => {
          this._log.info('getIamPolicy response %j', response);
          return [response, options, rawResponse];
        },
      )
      .catch((error: any) => {
        if (
          error &&
          'statusDetails' in error &&
          error.statusDetails instanceof Array
        ) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(
            jsonProtos,
          ) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(
            error.statusDetails,
            protos,
          );
        }
        throw error;
      });
  }
  /**
   * Returns permissions that the caller has on the specified instance resource.
   *
   * Attempting this RPC on a non-existent Cloud Spanner instance resource will
   * result in a NOT_FOUND error if the user has `spanner.instances.list`
   * permission on the containing Google Cloud Project. Otherwise returns an
   * empty set of permissions.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.resource
   *   REQUIRED: The resource for which the policy detail is being requested.
   *   See the operation documentation for the appropriate value for this field.
   * @param {string[]} request.permissions
   *   The set of permissions to check for the `resource`. Permissions with
   *   wildcards (such as '*' or 'storage.*') are not allowed. For more
   *   information see
   *   [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing {@link protos.google.iam.v1.TestIamPermissionsResponse|TestIamPermissionsResponse}.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
   *   for more details and examples.
   */
  testIamPermissions(
    request?: protos.google.iam.v1.ITestIamPermissionsRequest,
    options?: CallOptions,
  ): Promise<
    [
      protos.google.iam.v1.ITestIamPermissionsResponse,
      protos.google.iam.v1.ITestIamPermissionsRequest | undefined,
      {} | undefined,
    ]
  >;
  testIamPermissions(
    request: protos.google.iam.v1.ITestIamPermissionsRequest,
    options: CallOptions,
    callback: Callback<
      protos.google.iam.v1.ITestIamPermissionsResponse,
      protos.google.iam.v1.ITestIamPermissionsRequest | null | undefined,
      {} | null | undefined
    >,
  ): void;
  testIamPermissions(
    request: protos.google.iam.v1.ITestIamPermissionsRequest,
    callback: Callback<
      protos.google.iam.v1.ITestIamPermissionsResponse,
      protos.google.iam.v1.ITestIamPermissionsRequest | null | undefined,
      {} | null | undefined
    >,
  ): void;
  testIamPermissions(
    request?: protos.google.iam.v1.ITestIamPermissionsRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          protos.google.iam.v1.ITestIamPermissionsResponse,
          protos.google.iam.v1.ITestIamPermissionsRequest | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.iam.v1.ITestIamPermissionsResponse,
      protos.google.iam.v1.ITestIamPermissionsRequest | null | undefined,
      {} | null | undefined
    >,
  ): Promise<
    [
      protos.google.iam.v1.ITestIamPermissionsResponse,
      protos.google.iam.v1.ITestIamPermissionsRequest | undefined,
      {} | undefined,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        resource: request.resource ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('testIamPermissions request %j', request);
    const wrappedCallback:
      | Callback<
          protos.google.iam.v1.ITestIamPermissionsResponse,
          protos.google.iam.v1.ITestIamPermissionsRequest | null | undefined,
          {} | null | undefined
        >
      | undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('testIamPermissions response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls
      .testIamPermissions(request, options, wrappedCallback)
      ?.then(
        ([response, options, rawResponse]: [
          protos.google.iam.v1.ITestIamPermissionsResponse,
          protos.google.iam.v1.ITestIamPermissionsRequest | undefined,
          {} | undefined,
        ]) => {
          this._log.info('testIamPermissions response %j', response);
          return [response, options, rawResponse];
        },
      )
      .catch((error: any) => {
        if (
          error &&
          'statusDetails' in error &&
          error.statusDetails instanceof Array
        ) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(
            jsonProtos,
          ) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(
            error.statusDetails,
            protos,
          );
        }
        throw error;
      });
  }
  /**
   * Gets information about a particular instance partition.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Required. The name of the requested instance partition. Values are of
   *   the form
   *   `projects/{project}/instances/{instance}/instancePartitions/{instance_partition}`.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing {@link protos.google.spanner.admin.instance.v1.InstancePartition|InstancePartition}.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
   *   for more details and examples.
   */
  getInstancePartition(
    request?: protos.google.spanner.admin.instance.v1.IGetInstancePartitionRequest,
    options?: CallOptions,
  ): Promise<
    [
      protos.google.spanner.admin.instance.v1.IInstancePartition,
      (
        | protos.google.spanner.admin.instance.v1.IGetInstancePartitionRequest
        | undefined
      ),
      {} | undefined,
    ]
  >;
  getInstancePartition(
    request: protos.google.spanner.admin.instance.v1.IGetInstancePartitionRequest,
    options: CallOptions,
    callback: Callback<
      protos.google.spanner.admin.instance.v1.IInstancePartition,
      | protos.google.spanner.admin.instance.v1.IGetInstancePartitionRequest
      | null
      | undefined,
      {} | null | undefined
    >,
  ): void;
  getInstancePartition(
    request: protos.google.spanner.admin.instance.v1.IGetInstancePartitionRequest,
    callback: Callback<
      protos.google.spanner.admin.instance.v1.IInstancePartition,
      | protos.google.spanner.admin.instance.v1.IGetInstancePartitionRequest
      | null
      | undefined,
      {} | null | undefined
    >,
  ): void;
  getInstancePartition(
    request?: protos.google.spanner.admin.instance.v1.IGetInstancePartitionRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          protos.google.spanner.admin.instance.v1.IInstancePartition,
          | protos.google.spanner.admin.instance.v1.IGetInstancePartitionRequest
          | null
          | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.spanner.admin.instance.v1.IInstancePartition,
      | protos.google.spanner.admin.instance.v1.IGetInstancePartitionRequest
      | null
      | undefined,
      {} | null | undefined
    >,
  ): Promise<
    [
      protos.google.spanner.admin.instance.v1.IInstancePartition,
      (
        | protos.google.spanner.admin.instance.v1.IGetInstancePartitionRequest
        | undefined
      ),
      {} | undefined,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        name: request.name ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('getInstancePartition request %j', request);
    const wrappedCallback:
      | Callback<
          protos.google.spanner.admin.instance.v1.IInstancePartition,
          | protos.google.spanner.admin.instance.v1.IGetInstancePartitionRequest
          | null
          | undefined,
          {} | null | undefined
        >
      | undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('getInstancePartition response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls
      .getInstancePartition(request, options, wrappedCallback)
      ?.then(
        ([response, options, rawResponse]: [
          protos.google.spanner.admin.instance.v1.IInstancePartition,
          (
            | protos.google.spanner.admin.instance.v1.IGetInstancePartitionRequest
            | undefined
          ),
          {} | undefined,
        ]) => {
          this._log.info('getInstancePartition response %j', response);
          return [response, options, rawResponse];
        },
      )
      .catch((error: any) => {
        if (
          error &&
          'statusDetails' in error &&
          error.statusDetails instanceof Array
        ) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(
            jsonProtos,
          ) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(
            error.statusDetails,
            protos,
          );
        }
        throw error;
      });
  }
  /**
   * Deletes an existing instance partition. Requires that the
   * instance partition is not used by any database or backup and is not the
   * default instance partition of an instance.
   *
   * Authorization requires `spanner.instancePartitions.delete` permission on
   * the resource
   * {@link protos.google.spanner.admin.instance.v1.InstancePartition.name|name}.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Required. The name of the instance partition to be deleted.
   *   Values are of the form
   *   `projects/{project}/instances/{instance}/instancePartitions/{instance_partition}`
   * @param {string} request.etag
   *   Optional. If not empty, the API only deletes the instance partition when
   *   the etag provided matches the current status of the requested instance
   *   partition. Otherwise, deletes the instance partition without checking the
   *   current status of the requested instance partition.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing {@link protos.google.protobuf.Empty|Empty}.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods | documentation }
   *   for more details and examples.
   */
  deleteInstancePartition(
    request?: protos.google.spanner.admin.instance.v1.IDeleteInstancePartitionRequest,
    options?: CallOptions,
  ): Promise<
    [
      protos.google.protobuf.IEmpty,
      (
        | protos.google.spanner.admin.instance.v1.IDeleteInstancePartitionRequest
        | undefined
      ),
      {} | undefined,
    ]
  >;
  deleteInstancePartition(
    request: protos.google.spanner.admin.instance.v1.IDeleteInstancePartitionRequest,
    options: CallOptions,
    callback: Callback<
      protos.google.protobuf.IEmpty,
      | protos.google.spanner.admin.instance.v1.IDeleteInstancePartitionRequest
      | null
      | undefined,
      {} | null | undefined
    >,
  ): void;
  deleteInstancePartition(
    request: protos.google.spanner.admin.instance.v1.IDeleteInstancePartitionRequest,
    callback: Callback<
      protos.google.protobuf.IEmpty,
      | protos.google.spanner.admin.instance.v1.IDeleteInstancePartitionRequest
      | null
      | undefined,
      {} | null | undefined
    >,
  ): void;
  deleteInstancePartition(
    request?: protos.google.spanner.admin.instance.v1.IDeleteInstancePartitionRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          protos.google.protobuf.IEmpty,
          | protos.google.spanner.admin.instance.v1.IDeleteInstancePartitionRequest
          | null
          | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.protobuf.IEmpty,
      | protos.google.spanner.admin.instance.v1.IDeleteInstancePartitionRequest
      | null
      | undefined,
      {} | null | undefined
    >,
  ): Promise<
    [
      protos.google.protobuf.IEmpty,
      (
        | protos.google.spanner.admin.instance.v1.IDeleteInstancePartitionRequest
        | undefined
      ),
      {} | undefined,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        name: request.name ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('deleteInstancePartition request %j', request);
    const wrappedCallback:
      | Callback<
          protos.google.protobuf.IEmpty,
          | protos.google.spanner.admin.instance.v1.IDeleteInstancePartitionRequest
          | null
          | undefined,
          {} | null | undefined
        >
      | undefined = callback
      ? (error, response, options, rawResponse) => {
          this._log.info('deleteInstancePartition response %j', response);
          callback!(error, response, options, rawResponse); // We verified callback above.
        }
      : undefined;
    return this.innerApiCalls
      .deleteInstancePartition(request, options, wrappedCallback)
      ?.then(
        ([response, options, rawResponse]: [
          protos.google.protobuf.IEmpty,
          (
            | protos.google.spanner.admin.instance.v1.IDeleteInstancePartitionRequest
            | undefined
          ),
          {} | undefined,
        ]) => {
          this._log.info('deleteInstancePartition response %j', response);
          return [response, options, rawResponse];
        },
      )
      .catch((error: any) => {
        if (
          error &&
          'statusDetails' in error &&
          error.statusDetails instanceof Array
        ) {
          const protos = this._gaxModule.protobuf.Root.fromJSON(
            jsonProtos,
          ) as unknown as gax.protobuf.Type;
          error.statusDetails = decodeAnyProtosInArray(
            error.statusDetails,
            protos,
          );
        }
        throw error;
      });
  }

  /**
   * Creates an instance configuration and begins preparing it to be used. The
   * returned long-running operation
   * can be used to track the progress of preparing the new
   * instance configuration. The instance configuration name is assigned by the
   * caller. If the named instance configuration already exists,
   * `CreateInstanceConfig` returns `ALREADY_EXISTS`.
   *
   * Immediately after the request returns:
   *
   *   * The instance configuration is readable via the API, with all requested
   *     attributes. The instance configuration's
   *     {@link protos.google.spanner.admin.instance.v1.InstanceConfig.reconciling|reconciling}
   *     field is set to true. Its state is `CREATING`.
   *
   * While the operation is pending:
   *
   *   * Cancelling the operation renders the instance configuration immediately
   *     unreadable via the API.
   *   * Except for deleting the creating resource, all other attempts to modify
   *     the instance configuration are rejected.
   *
   * Upon completion of the returned operation:
   *
   *   * Instances can be created using the instance configuration.
   *   * The instance configuration's
   *   {@link protos.google.spanner.admin.instance.v1.InstanceConfig.reconciling|reconciling}
   *   field becomes false. Its state becomes `READY`.
   *
   * The returned long-running operation will
   * have a name of the format
   * `<instance_config_name>/operations/<operation_id>` and can be used to track
   * creation of the instance configuration. The
   * metadata field type is
   * {@link protos.google.spanner.admin.instance.v1.CreateInstanceConfigMetadata|CreateInstanceConfigMetadata}.
   * The response field type is
   * {@link protos.google.spanner.admin.instance.v1.InstanceConfig|InstanceConfig}, if
   * successful.
   *
   * Authorization requires `spanner.instanceConfigs.create` permission on
   * the resource
   * {@link protos.google.spanner.admin.instance.v1.CreateInstanceConfigRequest.parent|parent}.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The name of the project in which to create the instance
   *   configuration. Values are of the form `projects/<project>`.
   * @param {string} request.instanceConfigId
   *   Required. The ID of the instance configuration to create. Valid identifiers
   *   are of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
   *   characters in length. The `custom-` prefix is required to avoid name
   *   conflicts with Google-managed configurations.
   * @param {google.spanner.admin.instance.v1.InstanceConfig} request.instanceConfig
   *   Required. The `InstanceConfig` proto of the configuration to create.
   *   `instance_config.name` must be
   *   `<parent>/instanceConfigs/<instance_config_id>`.
   *   `instance_config.base_config` must be a Google-managed configuration name,
   *   e.g. <parent>/instanceConfigs/us-east1, <parent>/instanceConfigs/nam3.
   * @param {boolean} request.validateOnly
   *   An option to validate, but not actually execute, a request,
   *   and provide the same response.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
   *   for more details and examples.
   */
  createInstanceConfig(
    request?: protos.google.spanner.admin.instance.v1.ICreateInstanceConfigRequest,
    options?: CallOptions,
  ): Promise<
    [
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstanceConfig,
        protos.google.spanner.admin.instance.v1.ICreateInstanceConfigMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined,
    ]
  >;
  createInstanceConfig(
    request: protos.google.spanner.admin.instance.v1.ICreateInstanceConfigRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstanceConfig,
        protos.google.spanner.admin.instance.v1.ICreateInstanceConfigMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): void;
  createInstanceConfig(
    request: protos.google.spanner.admin.instance.v1.ICreateInstanceConfigRequest,
    callback: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstanceConfig,
        protos.google.spanner.admin.instance.v1.ICreateInstanceConfigMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): void;
  createInstanceConfig(
    request?: protos.google.spanner.admin.instance.v1.ICreateInstanceConfigRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.spanner.admin.instance.v1.IInstanceConfig,
            protos.google.spanner.admin.instance.v1.ICreateInstanceConfigMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstanceConfig,
        protos.google.spanner.admin.instance.v1.ICreateInstanceConfigMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): Promise<
    [
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstanceConfig,
        protos.google.spanner.admin.instance.v1.ICreateInstanceConfigMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        parent: request.parent ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    const wrappedCallback:
      | Callback<
          LROperation<
            protos.google.spanner.admin.instance.v1.IInstanceConfig,
            protos.google.spanner.admin.instance.v1.ICreateInstanceConfigMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >
      | undefined = callback
      ? (error, response, rawResponse, _) => {
          this._log.info('createInstanceConfig response %j', rawResponse);
          callback!(error, response, rawResponse, _); // We verified callback above.
        }
      : undefined;
    this._log.info('createInstanceConfig request %j', request);
    return this.innerApiCalls
      .createInstanceConfig(request, options, wrappedCallback)
      ?.then(
        ([response, rawResponse, _]: [
          LROperation<
            protos.google.spanner.admin.instance.v1.IInstanceConfig,
            protos.google.spanner.admin.instance.v1.ICreateInstanceConfigMetadata
          >,
          protos.google.longrunning.IOperation | undefined,
          {} | undefined,
        ]) => {
          this._log.info('createInstanceConfig response %j', rawResponse);
          return [response, rawResponse, _];
        },
      );
  }
  /**
   * Check the status of the long running operation returned by `createInstanceConfig()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
   *   for more details and examples.
   */
  async checkCreateInstanceConfigProgress(
    name: string,
  ): Promise<
    LROperation<
      protos.google.spanner.admin.instance.v1.InstanceConfig,
      protos.google.spanner.admin.instance.v1.CreateInstanceConfigMetadata
    >
  > {
    this._log.info('createInstanceConfig long-running');
    const request =
      new this._gaxModule.operationsProtos.google.longrunning.GetOperationRequest(
        {name},
      );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new this._gaxModule.Operation(
      operation,
      this.descriptors.longrunning.createInstanceConfig,
      this._gaxModule.createDefaultBackoffSettings(),
    );
    return decodeOperation as LROperation<
      protos.google.spanner.admin.instance.v1.InstanceConfig,
      protos.google.spanner.admin.instance.v1.CreateInstanceConfigMetadata
    >;
  }
  /**
   * Updates an instance configuration. The returned
   * long-running operation can be used to track
   * the progress of updating the instance. If the named instance configuration
   * does not exist, returns `NOT_FOUND`.
   *
   * Only user-managed configurations can be updated.
   *
   * Immediately after the request returns:
   *
   *   * The instance configuration's
   *     {@link protos.google.spanner.admin.instance.v1.InstanceConfig.reconciling|reconciling}
   *     field is set to true.
   *
   * While the operation is pending:
   *
   *   * Cancelling the operation sets its metadata's
   *     {@link protos.google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata.cancel_time|cancel_time}.
   *     The operation is guaranteed to succeed at undoing all changes, after
   *     which point it terminates with a `CANCELLED` status.
   *   * All other attempts to modify the instance configuration are rejected.
   *   * Reading the instance configuration via the API continues to give the
   *     pre-request values.
   *
   * Upon completion of the returned operation:
   *
   *   * Creating instances using the instance configuration uses the new
   *     values.
   *   * The new values of the instance configuration are readable via the API.
   *   * The instance configuration's
   *   {@link protos.google.spanner.admin.instance.v1.InstanceConfig.reconciling|reconciling}
   *   field becomes false.
   *
   * The returned long-running operation will
   * have a name of the format
   * `<instance_config_name>/operations/<operation_id>` and can be used to track
   * the instance configuration modification.  The
   * metadata field type is
   * {@link protos.google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata|UpdateInstanceConfigMetadata}.
   * The response field type is
   * {@link protos.google.spanner.admin.instance.v1.InstanceConfig|InstanceConfig}, if
   * successful.
   *
   * Authorization requires `spanner.instanceConfigs.update` permission on
   * the resource {@link protos.google.spanner.admin.instance.v1.InstanceConfig.name|name}.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {google.spanner.admin.instance.v1.InstanceConfig} request.instanceConfig
   *   Required. The user instance configuration to update, which must always
   *   include the instance configuration name. Otherwise, only fields mentioned
   *   in
   *   {@link protos.google.spanner.admin.instance.v1.UpdateInstanceConfigRequest.update_mask|update_mask}
   *   need be included. To prevent conflicts of concurrent updates,
   *   {@link protos.google.spanner.admin.instance.v1.InstanceConfig.reconciling|etag} can
   *   be used.
   * @param {google.protobuf.FieldMask} request.updateMask
   *   Required. A mask specifying which fields in
   *   {@link protos.google.spanner.admin.instance.v1.InstanceConfig|InstanceConfig} should be
   *   updated. The field mask must always be specified; this prevents any future
   *   fields in {@link protos.google.spanner.admin.instance.v1.InstanceConfig|InstanceConfig}
   *   from being erased accidentally by clients that do not know about them. Only
   *   display_name and labels can be updated.
   * @param {boolean} request.validateOnly
   *   An option to validate, but not actually execute, a request,
   *   and provide the same response.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
   *   for more details and examples.
   */
  updateInstanceConfig(
    request?: protos.google.spanner.admin.instance.v1.IUpdateInstanceConfigRequest,
    options?: CallOptions,
  ): Promise<
    [
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstanceConfig,
        protos.google.spanner.admin.instance.v1.IUpdateInstanceConfigMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined,
    ]
  >;
  updateInstanceConfig(
    request: protos.google.spanner.admin.instance.v1.IUpdateInstanceConfigRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstanceConfig,
        protos.google.spanner.admin.instance.v1.IUpdateInstanceConfigMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): void;
  updateInstanceConfig(
    request: protos.google.spanner.admin.instance.v1.IUpdateInstanceConfigRequest,
    callback: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstanceConfig,
        protos.google.spanner.admin.instance.v1.IUpdateInstanceConfigMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): void;
  updateInstanceConfig(
    request?: protos.google.spanner.admin.instance.v1.IUpdateInstanceConfigRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.spanner.admin.instance.v1.IInstanceConfig,
            protos.google.spanner.admin.instance.v1.IUpdateInstanceConfigMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstanceConfig,
        protos.google.spanner.admin.instance.v1.IUpdateInstanceConfigMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): Promise<
    [
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstanceConfig,
        protos.google.spanner.admin.instance.v1.IUpdateInstanceConfigMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        'instance_config.name': request.instanceConfig!.name ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    const wrappedCallback:
      | Callback<
          LROperation<
            protos.google.spanner.admin.instance.v1.IInstanceConfig,
            protos.google.spanner.admin.instance.v1.IUpdateInstanceConfigMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >
      | undefined = callback
      ? (error, response, rawResponse, _) => {
          this._log.info('updateInstanceConfig response %j', rawResponse);
          callback!(error, response, rawResponse, _); // We verified callback above.
        }
      : undefined;
    this._log.info('updateInstanceConfig request %j', request);
    return this.innerApiCalls
      .updateInstanceConfig(request, options, wrappedCallback)
      ?.then(
        ([response, rawResponse, _]: [
          LROperation<
            protos.google.spanner.admin.instance.v1.IInstanceConfig,
            protos.google.spanner.admin.instance.v1.IUpdateInstanceConfigMetadata
          >,
          protos.google.longrunning.IOperation | undefined,
          {} | undefined,
        ]) => {
          this._log.info('updateInstanceConfig response %j', rawResponse);
          return [response, rawResponse, _];
        },
      );
  }
  /**
   * Check the status of the long running operation returned by `updateInstanceConfig()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
   *   for more details and examples.
   */
  async checkUpdateInstanceConfigProgress(
    name: string,
  ): Promise<
    LROperation<
      protos.google.spanner.admin.instance.v1.InstanceConfig,
      protos.google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata
    >
  > {
    this._log.info('updateInstanceConfig long-running');
    const request =
      new this._gaxModule.operationsProtos.google.longrunning.GetOperationRequest(
        {name},
      );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new this._gaxModule.Operation(
      operation,
      this.descriptors.longrunning.updateInstanceConfig,
      this._gaxModule.createDefaultBackoffSettings(),
    );
    return decodeOperation as LROperation<
      protos.google.spanner.admin.instance.v1.InstanceConfig,
      protos.google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata
    >;
  }
  /**
   * Creates an instance and begins preparing it to begin serving. The
   * returned long-running operation
   * can be used to track the progress of preparing the new
   * instance. The instance name is assigned by the caller. If the
   * named instance already exists, `CreateInstance` returns
   * `ALREADY_EXISTS`.
   *
   * Immediately upon completion of this request:
   *
   *   * The instance is readable via the API, with all requested attributes
   *     but no allocated resources. Its state is `CREATING`.
   *
   * Until completion of the returned operation:
   *
   *   * Cancelling the operation renders the instance immediately unreadable
   *     via the API.
   *   * The instance can be deleted.
   *   * All other attempts to modify the instance are rejected.
   *
   * Upon completion of the returned operation:
   *
   *   * Billing for all successfully-allocated resources begins (some types
   *     may have lower than the requested levels).
   *   * Databases can be created in the instance.
   *   * The instance's allocated resource levels are readable via the API.
   *   * The instance's state becomes `READY`.
   *
   * The returned long-running operation will
   * have a name of the format `<instance_name>/operations/<operation_id>` and
   * can be used to track creation of the instance.  The
   * metadata field type is
   * {@link protos.google.spanner.admin.instance.v1.CreateInstanceMetadata|CreateInstanceMetadata}.
   * The response field type is
   * {@link protos.google.spanner.admin.instance.v1.Instance|Instance}, if successful.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The name of the project in which to create the instance. Values
   *   are of the form `projects/<project>`.
   * @param {string} request.instanceId
   *   Required. The ID of the instance to create.  Valid identifiers are of the
   *   form `{@link protos.-a-z0-9|a-z}*[a-z0-9]` and must be between 2 and 64 characters in
   *   length.
   * @param {google.spanner.admin.instance.v1.Instance} request.instance
   *   Required. The instance to create.  The name may be omitted, but if
   *   specified must be `<parent>/instances/<instance_id>`.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
   *   for more details and examples.
   */
  createInstance(
    request?: protos.google.spanner.admin.instance.v1.ICreateInstanceRequest,
    options?: CallOptions,
  ): Promise<
    [
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstance,
        protos.google.spanner.admin.instance.v1.ICreateInstanceMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined,
    ]
  >;
  createInstance(
    request: protos.google.spanner.admin.instance.v1.ICreateInstanceRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstance,
        protos.google.spanner.admin.instance.v1.ICreateInstanceMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): void;
  createInstance(
    request: protos.google.spanner.admin.instance.v1.ICreateInstanceRequest,
    callback: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstance,
        protos.google.spanner.admin.instance.v1.ICreateInstanceMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): void;
  createInstance(
    request?: protos.google.spanner.admin.instance.v1.ICreateInstanceRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.spanner.admin.instance.v1.IInstance,
            protos.google.spanner.admin.instance.v1.ICreateInstanceMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstance,
        protos.google.spanner.admin.instance.v1.ICreateInstanceMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): Promise<
    [
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstance,
        protos.google.spanner.admin.instance.v1.ICreateInstanceMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        parent: request.parent ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    const wrappedCallback:
      | Callback<
          LROperation<
            protos.google.spanner.admin.instance.v1.IInstance,
            protos.google.spanner.admin.instance.v1.ICreateInstanceMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >
      | undefined = callback
      ? (error, response, rawResponse, _) => {
          this._log.info('createInstance response %j', rawResponse);
          callback!(error, response, rawResponse, _); // We verified callback above.
        }
      : undefined;
    this._log.info('createInstance request %j', request);
    return this.innerApiCalls
      .createInstance(request, options, wrappedCallback)
      ?.then(
        ([response, rawResponse, _]: [
          LROperation<
            protos.google.spanner.admin.instance.v1.IInstance,
            protos.google.spanner.admin.instance.v1.ICreateInstanceMetadata
          >,
          protos.google.longrunning.IOperation | undefined,
          {} | undefined,
        ]) => {
          this._log.info('createInstance response %j', rawResponse);
          return [response, rawResponse, _];
        },
      );
  }
  /**
   * Check the status of the long running operation returned by `createInstance()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
   *   for more details and examples.
   */
  async checkCreateInstanceProgress(
    name: string,
  ): Promise<
    LROperation<
      protos.google.spanner.admin.instance.v1.Instance,
      protos.google.spanner.admin.instance.v1.CreateInstanceMetadata
    >
  > {
    this._log.info('createInstance long-running');
    const request =
      new this._gaxModule.operationsProtos.google.longrunning.GetOperationRequest(
        {name},
      );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new this._gaxModule.Operation(
      operation,
      this.descriptors.longrunning.createInstance,
      this._gaxModule.createDefaultBackoffSettings(),
    );
    return decodeOperation as LROperation<
      protos.google.spanner.admin.instance.v1.Instance,
      protos.google.spanner.admin.instance.v1.CreateInstanceMetadata
    >;
  }
  /**
   * Updates an instance, and begins allocating or releasing resources
   * as requested. The returned long-running operation can be used to track the
   * progress of updating the instance. If the named instance does not
   * exist, returns `NOT_FOUND`.
   *
   * Immediately upon completion of this request:
   *
   *   * For resource types for which a decrease in the instance's allocation
   *     has been requested, billing is based on the newly-requested level.
   *
   * Until completion of the returned operation:
   *
   *   * Cancelling the operation sets its metadata's
   *     {@link protos.google.spanner.admin.instance.v1.UpdateInstanceMetadata.cancel_time|cancel_time},
   *     and begins restoring resources to their pre-request values. The
   *     operation is guaranteed to succeed at undoing all resource changes,
   *     after which point it terminates with a `CANCELLED` status.
   *   * All other attempts to modify the instance are rejected.
   *   * Reading the instance via the API continues to give the pre-request
   *     resource levels.
   *
   * Upon completion of the returned operation:
   *
   *   * Billing begins for all successfully-allocated resources (some types
   *     may have lower than the requested levels).
   *   * All newly-reserved resources are available for serving the instance's
   *     tables.
   *   * The instance's new resource levels are readable via the API.
   *
   * The returned long-running operation will
   * have a name of the format `<instance_name>/operations/<operation_id>` and
   * can be used to track the instance modification.  The
   * metadata field type is
   * {@link protos.google.spanner.admin.instance.v1.UpdateInstanceMetadata|UpdateInstanceMetadata}.
   * The response field type is
   * {@link protos.google.spanner.admin.instance.v1.Instance|Instance}, if successful.
   *
   * Authorization requires `spanner.instances.update` permission on
   * the resource {@link protos.google.spanner.admin.instance.v1.Instance.name|name}.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {google.spanner.admin.instance.v1.Instance} request.instance
   *   Required. The instance to update, which must always include the instance
   *   name.  Otherwise, only fields mentioned in
   *   {@link protos.google.spanner.admin.instance.v1.UpdateInstanceRequest.field_mask|field_mask}
   *   need be included.
   * @param {google.protobuf.FieldMask} request.fieldMask
   *   Required. A mask specifying which fields in
   *   {@link protos.google.spanner.admin.instance.v1.Instance|Instance} should be updated.
   *   The field mask must always be specified; this prevents any future fields in
   *   {@link protos.google.spanner.admin.instance.v1.Instance|Instance} from being erased
   *   accidentally by clients that do not know about them.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
   *   for more details and examples.
   */
  updateInstance(
    request?: protos.google.spanner.admin.instance.v1.IUpdateInstanceRequest,
    options?: CallOptions,
  ): Promise<
    [
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstance,
        protos.google.spanner.admin.instance.v1.IUpdateInstanceMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined,
    ]
  >;
  updateInstance(
    request: protos.google.spanner.admin.instance.v1.IUpdateInstanceRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstance,
        protos.google.spanner.admin.instance.v1.IUpdateInstanceMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): void;
  updateInstance(
    request: protos.google.spanner.admin.instance.v1.IUpdateInstanceRequest,
    callback: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstance,
        protos.google.spanner.admin.instance.v1.IUpdateInstanceMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): void;
  updateInstance(
    request?: protos.google.spanner.admin.instance.v1.IUpdateInstanceRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.spanner.admin.instance.v1.IInstance,
            protos.google.spanner.admin.instance.v1.IUpdateInstanceMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstance,
        protos.google.spanner.admin.instance.v1.IUpdateInstanceMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): Promise<
    [
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstance,
        protos.google.spanner.admin.instance.v1.IUpdateInstanceMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        'instance.name': request.instance!.name ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    const wrappedCallback:
      | Callback<
          LROperation<
            protos.google.spanner.admin.instance.v1.IInstance,
            protos.google.spanner.admin.instance.v1.IUpdateInstanceMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >
      | undefined = callback
      ? (error, response, rawResponse, _) => {
          this._log.info('updateInstance response %j', rawResponse);
          callback!(error, response, rawResponse, _); // We verified callback above.
        }
      : undefined;
    this._log.info('updateInstance request %j', request);
    return this.innerApiCalls
      .updateInstance(request, options, wrappedCallback)
      ?.then(
        ([response, rawResponse, _]: [
          LROperation<
            protos.google.spanner.admin.instance.v1.IInstance,
            protos.google.spanner.admin.instance.v1.IUpdateInstanceMetadata
          >,
          protos.google.longrunning.IOperation | undefined,
          {} | undefined,
        ]) => {
          this._log.info('updateInstance response %j', rawResponse);
          return [response, rawResponse, _];
        },
      );
  }
  /**
   * Check the status of the long running operation returned by `updateInstance()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
   *   for more details and examples.
   */
  async checkUpdateInstanceProgress(
    name: string,
  ): Promise<
    LROperation<
      protos.google.spanner.admin.instance.v1.Instance,
      protos.google.spanner.admin.instance.v1.UpdateInstanceMetadata
    >
  > {
    this._log.info('updateInstance long-running');
    const request =
      new this._gaxModule.operationsProtos.google.longrunning.GetOperationRequest(
        {name},
      );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new this._gaxModule.Operation(
      operation,
      this.descriptors.longrunning.updateInstance,
      this._gaxModule.createDefaultBackoffSettings(),
    );
    return decodeOperation as LROperation<
      protos.google.spanner.admin.instance.v1.Instance,
      protos.google.spanner.admin.instance.v1.UpdateInstanceMetadata
    >;
  }
  /**
   * Creates an instance partition and begins preparing it to be used. The
   * returned long-running operation
   * can be used to track the progress of preparing the new instance partition.
   * The instance partition name is assigned by the caller. If the named
   * instance partition already exists, `CreateInstancePartition` returns
   * `ALREADY_EXISTS`.
   *
   * Immediately upon completion of this request:
   *
   *   * The instance partition is readable via the API, with all requested
   *     attributes but no allocated resources. Its state is `CREATING`.
   *
   * Until completion of the returned operation:
   *
   *   * Cancelling the operation renders the instance partition immediately
   *     unreadable via the API.
   *   * The instance partition can be deleted.
   *   * All other attempts to modify the instance partition are rejected.
   *
   * Upon completion of the returned operation:
   *
   *   * Billing for all successfully-allocated resources begins (some types
   *     may have lower than the requested levels).
   *   * Databases can start using this instance partition.
   *   * The instance partition's allocated resource levels are readable via the
   *     API.
   *   * The instance partition's state becomes `READY`.
   *
   * The returned long-running operation will
   * have a name of the format
   * `<instance_partition_name>/operations/<operation_id>` and can be used to
   * track creation of the instance partition.  The
   * metadata field type is
   * {@link protos.google.spanner.admin.instance.v1.CreateInstancePartitionMetadata|CreateInstancePartitionMetadata}.
   * The response field type is
   * {@link protos.google.spanner.admin.instance.v1.InstancePartition|InstancePartition}, if
   * successful.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The name of the instance in which to create the instance
   *   partition. Values are of the form
   *   `projects/<project>/instances/<instance>`.
   * @param {string} request.instancePartitionId
   *   Required. The ID of the instance partition to create. Valid identifiers are
   *   of the form `{@link protos.-a-z0-9|a-z}*[a-z0-9]` and must be between 2 and 64
   *   characters in length.
   * @param {google.spanner.admin.instance.v1.InstancePartition} request.instancePartition
   *   Required. The instance partition to create. The instance_partition.name may
   *   be omitted, but if specified must be
   *   `<parent>/instancePartitions/<instance_partition_id>`.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
   *   for more details and examples.
   */
  createInstancePartition(
    request?: protos.google.spanner.admin.instance.v1.ICreateInstancePartitionRequest,
    options?: CallOptions,
  ): Promise<
    [
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstancePartition,
        protos.google.spanner.admin.instance.v1.ICreateInstancePartitionMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined,
    ]
  >;
  createInstancePartition(
    request: protos.google.spanner.admin.instance.v1.ICreateInstancePartitionRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstancePartition,
        protos.google.spanner.admin.instance.v1.ICreateInstancePartitionMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): void;
  createInstancePartition(
    request: protos.google.spanner.admin.instance.v1.ICreateInstancePartitionRequest,
    callback: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstancePartition,
        protos.google.spanner.admin.instance.v1.ICreateInstancePartitionMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): void;
  createInstancePartition(
    request?: protos.google.spanner.admin.instance.v1.ICreateInstancePartitionRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.spanner.admin.instance.v1.IInstancePartition,
            protos.google.spanner.admin.instance.v1.ICreateInstancePartitionMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstancePartition,
        protos.google.spanner.admin.instance.v1.ICreateInstancePartitionMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): Promise<
    [
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstancePartition,
        protos.google.spanner.admin.instance.v1.ICreateInstancePartitionMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        parent: request.parent ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    const wrappedCallback:
      | Callback<
          LROperation<
            protos.google.spanner.admin.instance.v1.IInstancePartition,
            protos.google.spanner.admin.instance.v1.ICreateInstancePartitionMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >
      | undefined = callback
      ? (error, response, rawResponse, _) => {
          this._log.info('createInstancePartition response %j', rawResponse);
          callback!(error, response, rawResponse, _); // We verified callback above.
        }
      : undefined;
    this._log.info('createInstancePartition request %j', request);
    return this.innerApiCalls
      .createInstancePartition(request, options, wrappedCallback)
      ?.then(
        ([response, rawResponse, _]: [
          LROperation<
            protos.google.spanner.admin.instance.v1.IInstancePartition,
            protos.google.spanner.admin.instance.v1.ICreateInstancePartitionMetadata
          >,
          protos.google.longrunning.IOperation | undefined,
          {} | undefined,
        ]) => {
          this._log.info('createInstancePartition response %j', rawResponse);
          return [response, rawResponse, _];
        },
      );
  }
  /**
   * Check the status of the long running operation returned by `createInstancePartition()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
   *   for more details and examples.
   */
  async checkCreateInstancePartitionProgress(
    name: string,
  ): Promise<
    LROperation<
      protos.google.spanner.admin.instance.v1.InstancePartition,
      protos.google.spanner.admin.instance.v1.CreateInstancePartitionMetadata
    >
  > {
    this._log.info('createInstancePartition long-running');
    const request =
      new this._gaxModule.operationsProtos.google.longrunning.GetOperationRequest(
        {name},
      );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new this._gaxModule.Operation(
      operation,
      this.descriptors.longrunning.createInstancePartition,
      this._gaxModule.createDefaultBackoffSettings(),
    );
    return decodeOperation as LROperation<
      protos.google.spanner.admin.instance.v1.InstancePartition,
      protos.google.spanner.admin.instance.v1.CreateInstancePartitionMetadata
    >;
  }
  /**
   * Updates an instance partition, and begins allocating or releasing resources
   * as requested. The returned long-running operation can be used to track the
   * progress of updating the instance partition. If the named instance
   * partition does not exist, returns `NOT_FOUND`.
   *
   * Immediately upon completion of this request:
   *
   *   * For resource types for which a decrease in the instance partition's
   *   allocation has been requested, billing is based on the newly-requested
   *   level.
   *
   * Until completion of the returned operation:
   *
   *   * Cancelling the operation sets its metadata's
   *     {@link protos.google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata.cancel_time|cancel_time},
   *     and begins restoring resources to their pre-request values. The
   *     operation is guaranteed to succeed at undoing all resource changes,
   *     after which point it terminates with a `CANCELLED` status.
   *   * All other attempts to modify the instance partition are rejected.
   *   * Reading the instance partition via the API continues to give the
   *     pre-request resource levels.
   *
   * Upon completion of the returned operation:
   *
   *   * Billing begins for all successfully-allocated resources (some types
   *     may have lower than the requested levels).
   *   * All newly-reserved resources are available for serving the instance
   *     partition's tables.
   *   * The instance partition's new resource levels are readable via the API.
   *
   * The returned long-running operation will
   * have a name of the format
   * `<instance_partition_name>/operations/<operation_id>` and can be used to
   * track the instance partition modification. The
   * metadata field type is
   * {@link protos.google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata|UpdateInstancePartitionMetadata}.
   * The response field type is
   * {@link protos.google.spanner.admin.instance.v1.InstancePartition|InstancePartition}, if
   * successful.
   *
   * Authorization requires `spanner.instancePartitions.update` permission on
   * the resource
   * {@link protos.google.spanner.admin.instance.v1.InstancePartition.name|name}.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {google.spanner.admin.instance.v1.InstancePartition} request.instancePartition
   *   Required. The instance partition to update, which must always include the
   *   instance partition name. Otherwise, only fields mentioned in
   *   {@link protos.google.spanner.admin.instance.v1.UpdateInstancePartitionRequest.field_mask|field_mask}
   *   need be included.
   * @param {google.protobuf.FieldMask} request.fieldMask
   *   Required. A mask specifying which fields in
   *   {@link protos.google.spanner.admin.instance.v1.InstancePartition|InstancePartition}
   *   should be updated. The field mask must always be specified; this prevents
   *   any future fields in
   *   {@link protos.google.spanner.admin.instance.v1.InstancePartition|InstancePartition}
   *   from being erased accidentally by clients that do not know about them.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
   *   for more details and examples.
   */
  updateInstancePartition(
    request?: protos.google.spanner.admin.instance.v1.IUpdateInstancePartitionRequest,
    options?: CallOptions,
  ): Promise<
    [
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstancePartition,
        protos.google.spanner.admin.instance.v1.IUpdateInstancePartitionMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined,
    ]
  >;
  updateInstancePartition(
    request: protos.google.spanner.admin.instance.v1.IUpdateInstancePartitionRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstancePartition,
        protos.google.spanner.admin.instance.v1.IUpdateInstancePartitionMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): void;
  updateInstancePartition(
    request: protos.google.spanner.admin.instance.v1.IUpdateInstancePartitionRequest,
    callback: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstancePartition,
        protos.google.spanner.admin.instance.v1.IUpdateInstancePartitionMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): void;
  updateInstancePartition(
    request?: protos.google.spanner.admin.instance.v1.IUpdateInstancePartitionRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.spanner.admin.instance.v1.IInstancePartition,
            protos.google.spanner.admin.instance.v1.IUpdateInstancePartitionMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstancePartition,
        protos.google.spanner.admin.instance.v1.IUpdateInstancePartitionMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): Promise<
    [
      LROperation<
        protos.google.spanner.admin.instance.v1.IInstancePartition,
        protos.google.spanner.admin.instance.v1.IUpdateInstancePartitionMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        'instance_partition.name': request.instancePartition!.name ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    const wrappedCallback:
      | Callback<
          LROperation<
            protos.google.spanner.admin.instance.v1.IInstancePartition,
            protos.google.spanner.admin.instance.v1.IUpdateInstancePartitionMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >
      | undefined = callback
      ? (error, response, rawResponse, _) => {
          this._log.info('updateInstancePartition response %j', rawResponse);
          callback!(error, response, rawResponse, _); // We verified callback above.
        }
      : undefined;
    this._log.info('updateInstancePartition request %j', request);
    return this.innerApiCalls
      .updateInstancePartition(request, options, wrappedCallback)
      ?.then(
        ([response, rawResponse, _]: [
          LROperation<
            protos.google.spanner.admin.instance.v1.IInstancePartition,
            protos.google.spanner.admin.instance.v1.IUpdateInstancePartitionMetadata
          >,
          protos.google.longrunning.IOperation | undefined,
          {} | undefined,
        ]) => {
          this._log.info('updateInstancePartition response %j', rawResponse);
          return [response, rawResponse, _];
        },
      );
  }
  /**
   * Check the status of the long running operation returned by `updateInstancePartition()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
   *   for more details and examples.
   */
  async checkUpdateInstancePartitionProgress(
    name: string,
  ): Promise<
    LROperation<
      protos.google.spanner.admin.instance.v1.InstancePartition,
      protos.google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata
    >
  > {
    this._log.info('updateInstancePartition long-running');
    const request =
      new this._gaxModule.operationsProtos.google.longrunning.GetOperationRequest(
        {name},
      );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new this._gaxModule.Operation(
      operation,
      this.descriptors.longrunning.updateInstancePartition,
      this._gaxModule.createDefaultBackoffSettings(),
    );
    return decodeOperation as LROperation<
      protos.google.spanner.admin.instance.v1.InstancePartition,
      protos.google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata
    >;
  }
  /**
   * Moves an instance to the target instance configuration. You can use the
   * returned long-running operation to track
   * the progress of moving the instance.
   *
   * `MoveInstance` returns `FAILED_PRECONDITION` if the instance meets any of
   * the following criteria:
   *
   *   * Is undergoing a move to a different instance configuration
   *   * Has backups
   *   * Has an ongoing update
   *   * Contains any CMEK-enabled databases
   *   * Is a free trial instance
   *
   * While the operation is pending:
   *
   *   * All other attempts to modify the instance, including changes to its
   *     compute capacity, are rejected.
   *   * The following database and backup admin operations are rejected:
   *
   *     * `DatabaseAdmin.CreateDatabase`
   *     * `DatabaseAdmin.UpdateDatabaseDdl` (disabled if default_leader is
   *        specified in the request.)
   *     * `DatabaseAdmin.RestoreDatabase`
   *     * `DatabaseAdmin.CreateBackup`
   *     * `DatabaseAdmin.CopyBackup`
   *
   *   * Both the source and target instance configurations are subject to
   *     hourly compute and storage charges.
   *   * The instance might experience higher read-write latencies and a higher
   *     transaction abort rate. However, moving an instance doesn't cause any
   *     downtime.
   *
   * The returned long-running operation has
   * a name of the format
   * `<instance_name>/operations/<operation_id>` and can be used to track
   * the move instance operation. The
   * metadata field type is
   * {@link protos.google.spanner.admin.instance.v1.MoveInstanceMetadata|MoveInstanceMetadata}.
   * The response field type is
   * {@link protos.google.spanner.admin.instance.v1.Instance|Instance},
   * if successful.
   * Cancelling the operation sets its metadata's
   * {@link protos.google.spanner.admin.instance.v1.MoveInstanceMetadata.cancel_time|cancel_time}.
   * Cancellation is not immediate because it involves moving any data
   * previously moved to the target instance configuration back to the original
   * instance configuration. You can use this operation to track the progress of
   * the cancellation. Upon successful completion of the cancellation, the
   * operation terminates with `CANCELLED` status.
   *
   * If not cancelled, upon completion of the returned operation:
   *
   *   * The instance successfully moves to the target instance
   *     configuration.
   *   * You are billed for compute and storage in target instance
   *   configuration.
   *
   * Authorization requires the `spanner.instances.update` permission on
   * the resource {@link protos.google.spanner.admin.instance.v1.Instance|instance}.
   *
   * For more details, see
   * [Move an instance](https://cloud.google.com/spanner/docs/move-instance).
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.name
   *   Required. The instance to move.
   *   Values are of the form `projects/<project>/instances/<instance>`.
   * @param {string} request.targetConfig
   *   Required. The target instance configuration where to move the instance.
   *   Values are of the form `projects/<project>/instanceConfigs/<config>`.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   *   a long running operation. Its `promise()` method returns a promise
   *   you can `await` for.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
   *   for more details and examples.
   */
  moveInstance(
    request?: protos.google.spanner.admin.instance.v1.IMoveInstanceRequest,
    options?: CallOptions,
  ): Promise<
    [
      LROperation<
        protos.google.spanner.admin.instance.v1.IMoveInstanceResponse,
        protos.google.spanner.admin.instance.v1.IMoveInstanceMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined,
    ]
  >;
  moveInstance(
    request: protos.google.spanner.admin.instance.v1.IMoveInstanceRequest,
    options: CallOptions,
    callback: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IMoveInstanceResponse,
        protos.google.spanner.admin.instance.v1.IMoveInstanceMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): void;
  moveInstance(
    request: protos.google.spanner.admin.instance.v1.IMoveInstanceRequest,
    callback: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IMoveInstanceResponse,
        protos.google.spanner.admin.instance.v1.IMoveInstanceMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): void;
  moveInstance(
    request?: protos.google.spanner.admin.instance.v1.IMoveInstanceRequest,
    optionsOrCallback?:
      | CallOptions
      | Callback<
          LROperation<
            protos.google.spanner.admin.instance.v1.IMoveInstanceResponse,
            protos.google.spanner.admin.instance.v1.IMoveInstanceMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >,
    callback?: Callback<
      LROperation<
        protos.google.spanner.admin.instance.v1.IMoveInstanceResponse,
        protos.google.spanner.admin.instance.v1.IMoveInstanceMetadata
      >,
      protos.google.longrunning.IOperation | null | undefined,
      {} | null | undefined
    >,
  ): Promise<
    [
      LROperation<
        protos.google.spanner.admin.instance.v1.IMoveInstanceResponse,
        protos.google.spanner.admin.instance.v1.IMoveInstanceMetadata
      >,
      protos.google.longrunning.IOperation | undefined,
      {} | undefined,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        name: request.name ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    const wrappedCallback:
      | Callback<
          LROperation<
            protos.google.spanner.admin.instance.v1.IMoveInstanceResponse,
            protos.google.spanner.admin.instance.v1.IMoveInstanceMetadata
          >,
          protos.google.longrunning.IOperation | null | undefined,
          {} | null | undefined
        >
      | undefined = callback
      ? (error, response, rawResponse, _) => {
          this._log.info('moveInstance response %j', rawResponse);
          callback!(error, response, rawResponse, _); // We verified callback above.
        }
      : undefined;
    this._log.info('moveInstance request %j', request);
    return this.innerApiCalls
      .moveInstance(request, options, wrappedCallback)
      ?.then(
        ([response, rawResponse, _]: [
          LROperation<
            protos.google.spanner.admin.instance.v1.IMoveInstanceResponse,
            protos.google.spanner.admin.instance.v1.IMoveInstanceMetadata
          >,
          protos.google.longrunning.IOperation | undefined,
          {} | undefined,
        ]) => {
          this._log.info('moveInstance response %j', rawResponse);
          return [response, rawResponse, _];
        },
      );
  }
  /**
   * Check the status of the long running operation returned by `moveInstance()`.
   * @param {String} name
   *   The operation name that will be passed.
   * @returns {Promise} - The promise which resolves to an object.
   *   The decoded operation object has result and metadata field to get information from.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations | documentation }
   *   for more details and examples.
   */
  async checkMoveInstanceProgress(
    name: string,
  ): Promise<
    LROperation<
      protos.google.spanner.admin.instance.v1.MoveInstanceResponse,
      protos.google.spanner.admin.instance.v1.MoveInstanceMetadata
    >
  > {
    this._log.info('moveInstance long-running');
    const request =
      new this._gaxModule.operationsProtos.google.longrunning.GetOperationRequest(
        {name},
      );
    const [operation] = await this.operationsClient.getOperation(request);
    const decodeOperation = new this._gaxModule.Operation(
      operation,
      this.descriptors.longrunning.moveInstance,
      this._gaxModule.createDefaultBackoffSettings(),
    );
    return decodeOperation as LROperation<
      protos.google.spanner.admin.instance.v1.MoveInstanceResponse,
      protos.google.spanner.admin.instance.v1.MoveInstanceMetadata
    >;
  }
  /**
   * Lists the supported instance configurations for a given project.
   *
   * Returns both Google-managed configurations and user-managed
   * configurations.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The name of the project for which a list of supported instance
   *   configurations is requested. Values are of the form
   *   `projects/<project>`.
   * @param {number} request.pageSize
   *   Number of instance configurations to be returned in the response. If 0 or
   *   less, defaults to the server's maximum allowed page size.
   * @param {string} request.pageToken
   *   If non-empty, `page_token` should contain a
   *   {@link protos.google.spanner.admin.instance.v1.ListInstanceConfigsResponse.next_page_token|next_page_token}
   *   from a previous
   *   {@link protos.google.spanner.admin.instance.v1.ListInstanceConfigsResponse|ListInstanceConfigsResponse}.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is Array of {@link protos.google.spanner.admin.instance.v1.InstanceConfig|InstanceConfig}.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed and will merge results from all the pages into this array.
   *   Note that it can affect your quota.
   *   We recommend using `listInstanceConfigsAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
   *   for more details and examples.
   */
  listInstanceConfigs(
    request?: protos.google.spanner.admin.instance.v1.IListInstanceConfigsRequest,
    options?: CallOptions,
  ): Promise<
    [
      protos.google.spanner.admin.instance.v1.IInstanceConfig[],
      protos.google.spanner.admin.instance.v1.IListInstanceConfigsRequest | null,
      protos.google.spanner.admin.instance.v1.IListInstanceConfigsResponse,
    ]
  >;
  listInstanceConfigs(
    request: protos.google.spanner.admin.instance.v1.IListInstanceConfigsRequest,
    options: CallOptions,
    callback: PaginationCallback<
      protos.google.spanner.admin.instance.v1.IListInstanceConfigsRequest,
      | protos.google.spanner.admin.instance.v1.IListInstanceConfigsResponse
      | null
      | undefined,
      protos.google.spanner.admin.instance.v1.IInstanceConfig
    >,
  ): void;
  listInstanceConfigs(
    request: protos.google.spanner.admin.instance.v1.IListInstanceConfigsRequest,
    callback: PaginationCallback<
      protos.google.spanner.admin.instance.v1.IListInstanceConfigsRequest,
      | protos.google.spanner.admin.instance.v1.IListInstanceConfigsResponse
      | null
      | undefined,
      protos.google.spanner.admin.instance.v1.IInstanceConfig
    >,
  ): void;
  listInstanceConfigs(
    request?: protos.google.spanner.admin.instance.v1.IListInstanceConfigsRequest,
    optionsOrCallback?:
      | CallOptions
      | PaginationCallback<
          protos.google.spanner.admin.instance.v1.IListInstanceConfigsRequest,
          | protos.google.spanner.admin.instance.v1.IListInstanceConfigsResponse
          | null
          | undefined,
          protos.google.spanner.admin.instance.v1.IInstanceConfig
        >,
    callback?: PaginationCallback<
      protos.google.spanner.admin.instance.v1.IListInstanceConfigsRequest,
      | protos.google.spanner.admin.instance.v1.IListInstanceConfigsResponse
      | null
      | undefined,
      protos.google.spanner.admin.instance.v1.IInstanceConfig
    >,
  ): Promise<
    [
      protos.google.spanner.admin.instance.v1.IInstanceConfig[],
      protos.google.spanner.admin.instance.v1.IListInstanceConfigsRequest | null,
      protos.google.spanner.admin.instance.v1.IListInstanceConfigsResponse,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        parent: request.parent ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    const wrappedCallback:
      | PaginationCallback<
          protos.google.spanner.admin.instance.v1.IListInstanceConfigsRequest,
          | protos.google.spanner.admin.instance.v1.IListInstanceConfigsResponse
          | null
          | undefined,
          protos.google.spanner.admin.instance.v1.IInstanceConfig
        >
      | undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listInstanceConfigs values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listInstanceConfigs request %j', request);
    return this.innerApiCalls
      .listInstanceConfigs(request, options, wrappedCallback)
      ?.then(
        ([response, input, output]: [
          protos.google.spanner.admin.instance.v1.IInstanceConfig[],
          protos.google.spanner.admin.instance.v1.IListInstanceConfigsRequest | null,
          protos.google.spanner.admin.instance.v1.IListInstanceConfigsResponse,
        ]) => {
          this._log.info('listInstanceConfigs values %j', response);
          return [response, input, output];
        },
      );
  }

  /**
   * Equivalent to `listInstanceConfigs`, but returns a NodeJS Stream object.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The name of the project for which a list of supported instance
   *   configurations is requested. Values are of the form
   *   `projects/<project>`.
   * @param {number} request.pageSize
   *   Number of instance configurations to be returned in the response. If 0 or
   *   less, defaults to the server's maximum allowed page size.
   * @param {string} request.pageToken
   *   If non-empty, `page_token` should contain a
   *   {@link protos.google.spanner.admin.instance.v1.ListInstanceConfigsResponse.next_page_token|next_page_token}
   *   from a previous
   *   {@link protos.google.spanner.admin.instance.v1.ListInstanceConfigsResponse|ListInstanceConfigsResponse}.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Stream}
   *   An object stream which emits an object representing {@link protos.google.spanner.admin.instance.v1.InstanceConfig|InstanceConfig} on 'data' event.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed. Note that it can affect your quota.
   *   We recommend using `listInstanceConfigsAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
   *   for more details and examples.
   */
  listInstanceConfigsStream(
    request?: protos.google.spanner.admin.instance.v1.IListInstanceConfigsRequest,
    options?: CallOptions,
  ): Transform {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        parent: request.parent ?? '',
      });
    const defaultCallSettings = this._defaults['listInstanceConfigs'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('listInstanceConfigs stream %j', request);
    return this.descriptors.page.listInstanceConfigs.createStream(
      this.innerApiCalls.listInstanceConfigs as GaxCall,
      request,
      callSettings,
    );
  }

  /**
   * Equivalent to `listInstanceConfigs`, but returns an iterable object.
   *
   * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The name of the project for which a list of supported instance
   *   configurations is requested. Values are of the form
   *   `projects/<project>`.
   * @param {number} request.pageSize
   *   Number of instance configurations to be returned in the response. If 0 or
   *   less, defaults to the server's maximum allowed page size.
   * @param {string} request.pageToken
   *   If non-empty, `page_token` should contain a
   *   {@link protos.google.spanner.admin.instance.v1.ListInstanceConfigsResponse.next_page_token|next_page_token}
   *   from a previous
   *   {@link protos.google.spanner.admin.instance.v1.ListInstanceConfigsResponse|ListInstanceConfigsResponse}.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Object}
   *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
   *   When you iterate the returned iterable, each element will be an object representing
   *   {@link protos.google.spanner.admin.instance.v1.InstanceConfig|InstanceConfig}. The API will be called under the hood as needed, once per the page,
   *   so you can stop the iteration when you don't need more results.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
   *   for more details and examples.
   */
  listInstanceConfigsAsync(
    request?: protos.google.spanner.admin.instance.v1.IListInstanceConfigsRequest,
    options?: CallOptions,
  ): AsyncIterable<protos.google.spanner.admin.instance.v1.IInstanceConfig> {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        parent: request.parent ?? '',
      });
    const defaultCallSettings = this._defaults['listInstanceConfigs'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('listInstanceConfigs iterate %j', request);
    return this.descriptors.page.listInstanceConfigs.asyncIterate(
      this.innerApiCalls['listInstanceConfigs'] as GaxCall,
      request as {},
      callSettings,
    ) as AsyncIterable<protos.google.spanner.admin.instance.v1.IInstanceConfig>;
  }
  /**
   * Lists the user-managed instance configuration long-running
   * operations in the given project. An instance
   * configuration operation has a name of the form
   * `projects/<project>/instanceConfigs/<instance_config>/operations/<operation>`.
   * The long-running operation
   * metadata field type
   * `metadata.type_url` describes the type of the metadata. Operations returned
   * include those that have completed/failed/canceled within the last 7 days,
   * and pending operations. Operations returned are ordered by
   * `operation.metadata.value.start_time` in descending order starting
   * from the most recently started operation.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The project of the instance configuration operations.
   *   Values are of the form `projects/<project>`.
   * @param {string} request.filter
   *   An expression that filters the list of returned operations.
   *
   *   A filter expression consists of a field name, a
   *   comparison operator, and a value for filtering.
   *   The value must be a string, a number, or a boolean. The comparison operator
   *   must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
   *   Colon `:` is the contains operator. Filter rules are not case sensitive.
   *
   *   The following fields in the Operation are eligible for filtering:
   *
   *     * `name` - The name of the long-running operation
   *     * `done` - False if the operation is in progress, else true.
   *     * `metadata.@type` - the type of metadata. For example, the type string
   *        for
   *        {@link protos.google.spanner.admin.instance.v1.CreateInstanceConfigMetadata|CreateInstanceConfigMetadata}
   *        is
   *        `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstanceConfigMetadata`.
   *     * `metadata.<field_name>` - any field in metadata.value.
   *        `metadata.@type` must be specified first, if filtering on metadata
   *        fields.
   *     * `error` - Error associated with the long-running operation.
   *     * `response.@type` - the type of response.
   *     * `response.<field_name>` - any field in response.value.
   *
   *   You can combine multiple expressions by enclosing each expression in
   *   parentheses. By default, expressions are combined with AND logic. However,
   *   you can specify AND, OR, and NOT logic explicitly.
   *
   *   Here are a few examples:
   *
   *     * `done:true` - The operation is complete.
   *     * `(metadata.@type=` \
   *       `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstanceConfigMetadata)
   *       AND` \
   *       `(metadata.instance_config.name:custom-config) AND` \
   *       `(metadata.progress.start_time < \"2021-03-28T14:50:00Z\") AND` \
   *       `(error:*)` - Return operations where:
   *       * The operation's metadata type is
   *       {@link protos.google.spanner.admin.instance.v1.CreateInstanceConfigMetadata|CreateInstanceConfigMetadata}.
   *       * The instance configuration name contains "custom-config".
   *       * The operation started before 2021-03-28T14:50:00Z.
   *       * The operation resulted in an error.
   * @param {number} request.pageSize
   *   Number of operations to be returned in the response. If 0 or
   *   less, defaults to the server's maximum allowed page size.
   * @param {string} request.pageToken
   *   If non-empty, `page_token` should contain a
   *   {@link protos.google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse.next_page_token|next_page_token}
   *   from a previous
   *   {@link protos.google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse|ListInstanceConfigOperationsResponse}
   *   to the same `parent` and with the same `filter`.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is Array of {@link protos.google.longrunning.Operation|Operation}.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed and will merge results from all the pages into this array.
   *   Note that it can affect your quota.
   *   We recommend using `listInstanceConfigOperationsAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
   *   for more details and examples.
   */
  listInstanceConfigOperations(
    request?: protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsRequest,
    options?: CallOptions,
  ): Promise<
    [
      protos.google.longrunning.IOperation[],
      protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsRequest | null,
      protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsResponse,
    ]
  >;
  listInstanceConfigOperations(
    request: protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsRequest,
    options: CallOptions,
    callback: PaginationCallback<
      protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsRequest,
      | protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsResponse
      | null
      | undefined,
      protos.google.longrunning.IOperation
    >,
  ): void;
  listInstanceConfigOperations(
    request: protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsRequest,
    callback: PaginationCallback<
      protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsRequest,
      | protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsResponse
      | null
      | undefined,
      protos.google.longrunning.IOperation
    >,
  ): void;
  listInstanceConfigOperations(
    request?: protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsRequest,
    optionsOrCallback?:
      | CallOptions
      | PaginationCallback<
          protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsRequest,
          | protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsResponse
          | null
          | undefined,
          protos.google.longrunning.IOperation
        >,
    callback?: PaginationCallback<
      protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsRequest,
      | protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsResponse
      | null
      | undefined,
      protos.google.longrunning.IOperation
    >,
  ): Promise<
    [
      protos.google.longrunning.IOperation[],
      protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsRequest | null,
      protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsResponse,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        parent: request.parent ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    const wrappedCallback:
      | PaginationCallback<
          protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsRequest,
          | protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsResponse
          | null
          | undefined,
          protos.google.longrunning.IOperation
        >
      | undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listInstanceConfigOperations values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listInstanceConfigOperations request %j', request);
    return this.innerApiCalls
      .listInstanceConfigOperations(request, options, wrappedCallback)
      ?.then(
        ([response, input, output]: [
          protos.google.longrunning.IOperation[],
          protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsRequest | null,
          protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsResponse,
        ]) => {
          this._log.info('listInstanceConfigOperations values %j', response);
          return [response, input, output];
        },
      );
  }

  /**
   * Equivalent to `listInstanceConfigOperations`, but returns a NodeJS Stream object.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The project of the instance configuration operations.
   *   Values are of the form `projects/<project>`.
   * @param {string} request.filter
   *   An expression that filters the list of returned operations.
   *
   *   A filter expression consists of a field name, a
   *   comparison operator, and a value for filtering.
   *   The value must be a string, a number, or a boolean. The comparison operator
   *   must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
   *   Colon `:` is the contains operator. Filter rules are not case sensitive.
   *
   *   The following fields in the Operation are eligible for filtering:
   *
   *     * `name` - The name of the long-running operation
   *     * `done` - False if the operation is in progress, else true.
   *     * `metadata.@type` - the type of metadata. For example, the type string
   *        for
   *        {@link protos.google.spanner.admin.instance.v1.CreateInstanceConfigMetadata|CreateInstanceConfigMetadata}
   *        is
   *        `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstanceConfigMetadata`.
   *     * `metadata.<field_name>` - any field in metadata.value.
   *        `metadata.@type` must be specified first, if filtering on metadata
   *        fields.
   *     * `error` - Error associated with the long-running operation.
   *     * `response.@type` - the type of response.
   *     * `response.<field_name>` - any field in response.value.
   *
   *   You can combine multiple expressions by enclosing each expression in
   *   parentheses. By default, expressions are combined with AND logic. However,
   *   you can specify AND, OR, and NOT logic explicitly.
   *
   *   Here are a few examples:
   *
   *     * `done:true` - The operation is complete.
   *     * `(metadata.@type=` \
   *       `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstanceConfigMetadata)
   *       AND` \
   *       `(metadata.instance_config.name:custom-config) AND` \
   *       `(metadata.progress.start_time < \"2021-03-28T14:50:00Z\") AND` \
   *       `(error:*)` - Return operations where:
   *       * The operation's metadata type is
   *       {@link protos.google.spanner.admin.instance.v1.CreateInstanceConfigMetadata|CreateInstanceConfigMetadata}.
   *       * The instance configuration name contains "custom-config".
   *       * The operation started before 2021-03-28T14:50:00Z.
   *       * The operation resulted in an error.
   * @param {number} request.pageSize
   *   Number of operations to be returned in the response. If 0 or
   *   less, defaults to the server's maximum allowed page size.
   * @param {string} request.pageToken
   *   If non-empty, `page_token` should contain a
   *   {@link protos.google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse.next_page_token|next_page_token}
   *   from a previous
   *   {@link protos.google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse|ListInstanceConfigOperationsResponse}
   *   to the same `parent` and with the same `filter`.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Stream}
   *   An object stream which emits an object representing {@link protos.google.longrunning.Operation|Operation} on 'data' event.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed. Note that it can affect your quota.
   *   We recommend using `listInstanceConfigOperationsAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
   *   for more details and examples.
   */
  listInstanceConfigOperationsStream(
    request?: protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsRequest,
    options?: CallOptions,
  ): Transform {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        parent: request.parent ?? '',
      });
    const defaultCallSettings = this._defaults['listInstanceConfigOperations'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('listInstanceConfigOperations stream %j', request);
    return this.descriptors.page.listInstanceConfigOperations.createStream(
      this.innerApiCalls.listInstanceConfigOperations as GaxCall,
      request,
      callSettings,
    );
  }

  /**
   * Equivalent to `listInstanceConfigOperations`, but returns an iterable object.
   *
   * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The project of the instance configuration operations.
   *   Values are of the form `projects/<project>`.
   * @param {string} request.filter
   *   An expression that filters the list of returned operations.
   *
   *   A filter expression consists of a field name, a
   *   comparison operator, and a value for filtering.
   *   The value must be a string, a number, or a boolean. The comparison operator
   *   must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
   *   Colon `:` is the contains operator. Filter rules are not case sensitive.
   *
   *   The following fields in the Operation are eligible for filtering:
   *
   *     * `name` - The name of the long-running operation
   *     * `done` - False if the operation is in progress, else true.
   *     * `metadata.@type` - the type of metadata. For example, the type string
   *        for
   *        {@link protos.google.spanner.admin.instance.v1.CreateInstanceConfigMetadata|CreateInstanceConfigMetadata}
   *        is
   *        `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstanceConfigMetadata`.
   *     * `metadata.<field_name>` - any field in metadata.value.
   *        `metadata.@type` must be specified first, if filtering on metadata
   *        fields.
   *     * `error` - Error associated with the long-running operation.
   *     * `response.@type` - the type of response.
   *     * `response.<field_name>` - any field in response.value.
   *
   *   You can combine multiple expressions by enclosing each expression in
   *   parentheses. By default, expressions are combined with AND logic. However,
   *   you can specify AND, OR, and NOT logic explicitly.
   *
   *   Here are a few examples:
   *
   *     * `done:true` - The operation is complete.
   *     * `(metadata.@type=` \
   *       `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstanceConfigMetadata)
   *       AND` \
   *       `(metadata.instance_config.name:custom-config) AND` \
   *       `(metadata.progress.start_time < \"2021-03-28T14:50:00Z\") AND` \
   *       `(error:*)` - Return operations where:
   *       * The operation's metadata type is
   *       {@link protos.google.spanner.admin.instance.v1.CreateInstanceConfigMetadata|CreateInstanceConfigMetadata}.
   *       * The instance configuration name contains "custom-config".
   *       * The operation started before 2021-03-28T14:50:00Z.
   *       * The operation resulted in an error.
   * @param {number} request.pageSize
   *   Number of operations to be returned in the response. If 0 or
   *   less, defaults to the server's maximum allowed page size.
   * @param {string} request.pageToken
   *   If non-empty, `page_token` should contain a
   *   {@link protos.google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse.next_page_token|next_page_token}
   *   from a previous
   *   {@link protos.google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse|ListInstanceConfigOperationsResponse}
   *   to the same `parent` and with the same `filter`.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Object}
   *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
   *   When you iterate the returned iterable, each element will be an object representing
   *   {@link protos.google.longrunning.Operation|Operation}. The API will be called under the hood as needed, once per the page,
   *   so you can stop the iteration when you don't need more results.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
   *   for more details and examples.
   */
  listInstanceConfigOperationsAsync(
    request?: protos.google.spanner.admin.instance.v1.IListInstanceConfigOperationsRequest,
    options?: CallOptions,
  ): AsyncIterable<protos.google.longrunning.IOperation> {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        parent: request.parent ?? '',
      });
    const defaultCallSettings = this._defaults['listInstanceConfigOperations'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('listInstanceConfigOperations iterate %j', request);
    return this.descriptors.page.listInstanceConfigOperations.asyncIterate(
      this.innerApiCalls['listInstanceConfigOperations'] as GaxCall,
      request as {},
      callSettings,
    ) as AsyncIterable<protos.google.longrunning.IOperation>;
  }
  /**
   * Lists all instances in the given project.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The name of the project for which a list of instances is
   *   requested. Values are of the form `projects/<project>`.
   * @param {number} request.pageSize
   *   Number of instances to be returned in the response. If 0 or less, defaults
   *   to the server's maximum allowed page size.
   * @param {string} request.pageToken
   *   If non-empty, `page_token` should contain a
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancesResponse.next_page_token|next_page_token}
   *   from a previous
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancesResponse|ListInstancesResponse}.
   * @param {string} request.filter
   *   An expression for filtering the results of the request. Filter rules are
   *   case insensitive. The fields eligible for filtering are:
   *
   *     * `name`
   *     * `display_name`
   *     * `labels.key` where key is the name of a label
   *
   *   Some examples of using filters are:
   *
   *     * `name:*` --> The instance has a name.
   *     * `name:Howl` --> The instance's name contains the string "howl".
   *     * `name:HOWL` --> Equivalent to above.
   *     * `NAME:howl` --> Equivalent to above.
   *     * `labels.env:*` --> The instance has the label "env".
   *     * `labels.env:dev` --> The instance has the label "env" and the value of
   *                          the label contains the string "dev".
   *     * `name:howl labels.env:dev` --> The instance's name contains "howl" and
   *                                    it has the label "env" with its value
   *                                    containing "dev".
   * @param {google.protobuf.Timestamp} request.instanceDeadline
   *   Deadline used while retrieving metadata for instances.
   *   Instances whose metadata cannot be retrieved within this deadline will be
   *   added to
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancesResponse.unreachable|unreachable}
   *   in
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancesResponse|ListInstancesResponse}.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is Array of {@link protos.google.spanner.admin.instance.v1.Instance|Instance}.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed and will merge results from all the pages into this array.
   *   Note that it can affect your quota.
   *   We recommend using `listInstancesAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
   *   for more details and examples.
   */
  listInstances(
    request?: protos.google.spanner.admin.instance.v1.IListInstancesRequest,
    options?: CallOptions,
  ): Promise<
    [
      protos.google.spanner.admin.instance.v1.IInstance[],
      protos.google.spanner.admin.instance.v1.IListInstancesRequest | null,
      protos.google.spanner.admin.instance.v1.IListInstancesResponse,
    ]
  >;
  listInstances(
    request: protos.google.spanner.admin.instance.v1.IListInstancesRequest,
    options: CallOptions,
    callback: PaginationCallback<
      protos.google.spanner.admin.instance.v1.IListInstancesRequest,
      | protos.google.spanner.admin.instance.v1.IListInstancesResponse
      | null
      | undefined,
      protos.google.spanner.admin.instance.v1.IInstance
    >,
  ): void;
  listInstances(
    request: protos.google.spanner.admin.instance.v1.IListInstancesRequest,
    callback: PaginationCallback<
      protos.google.spanner.admin.instance.v1.IListInstancesRequest,
      | protos.google.spanner.admin.instance.v1.IListInstancesResponse
      | null
      | undefined,
      protos.google.spanner.admin.instance.v1.IInstance
    >,
  ): void;
  listInstances(
    request?: protos.google.spanner.admin.instance.v1.IListInstancesRequest,
    optionsOrCallback?:
      | CallOptions
      | PaginationCallback<
          protos.google.spanner.admin.instance.v1.IListInstancesRequest,
          | protos.google.spanner.admin.instance.v1.IListInstancesResponse
          | null
          | undefined,
          protos.google.spanner.admin.instance.v1.IInstance
        >,
    callback?: PaginationCallback<
      protos.google.spanner.admin.instance.v1.IListInstancesRequest,
      | protos.google.spanner.admin.instance.v1.IListInstancesResponse
      | null
      | undefined,
      protos.google.spanner.admin.instance.v1.IInstance
    >,
  ): Promise<
    [
      protos.google.spanner.admin.instance.v1.IInstance[],
      protos.google.spanner.admin.instance.v1.IListInstancesRequest | null,
      protos.google.spanner.admin.instance.v1.IListInstancesResponse,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        parent: request.parent ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    const wrappedCallback:
      | PaginationCallback<
          protos.google.spanner.admin.instance.v1.IListInstancesRequest,
          | protos.google.spanner.admin.instance.v1.IListInstancesResponse
          | null
          | undefined,
          protos.google.spanner.admin.instance.v1.IInstance
        >
      | undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listInstances values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listInstances request %j', request);
    return this.innerApiCalls
      .listInstances(request, options, wrappedCallback)
      ?.then(
        ([response, input, output]: [
          protos.google.spanner.admin.instance.v1.IInstance[],
          protos.google.spanner.admin.instance.v1.IListInstancesRequest | null,
          protos.google.spanner.admin.instance.v1.IListInstancesResponse,
        ]) => {
          this._log.info('listInstances values %j', response);
          return [response, input, output];
        },
      );
  }

  /**
   * Equivalent to `listInstances`, but returns a NodeJS Stream object.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The name of the project for which a list of instances is
   *   requested. Values are of the form `projects/<project>`.
   * @param {number} request.pageSize
   *   Number of instances to be returned in the response. If 0 or less, defaults
   *   to the server's maximum allowed page size.
   * @param {string} request.pageToken
   *   If non-empty, `page_token` should contain a
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancesResponse.next_page_token|next_page_token}
   *   from a previous
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancesResponse|ListInstancesResponse}.
   * @param {string} request.filter
   *   An expression for filtering the results of the request. Filter rules are
   *   case insensitive. The fields eligible for filtering are:
   *
   *     * `name`
   *     * `display_name`
   *     * `labels.key` where key is the name of a label
   *
   *   Some examples of using filters are:
   *
   *     * `name:*` --> The instance has a name.
   *     * `name:Howl` --> The instance's name contains the string "howl".
   *     * `name:HOWL` --> Equivalent to above.
   *     * `NAME:howl` --> Equivalent to above.
   *     * `labels.env:*` --> The instance has the label "env".
   *     * `labels.env:dev` --> The instance has the label "env" and the value of
   *                          the label contains the string "dev".
   *     * `name:howl labels.env:dev` --> The instance's name contains "howl" and
   *                                    it has the label "env" with its value
   *                                    containing "dev".
   * @param {google.protobuf.Timestamp} request.instanceDeadline
   *   Deadline used while retrieving metadata for instances.
   *   Instances whose metadata cannot be retrieved within this deadline will be
   *   added to
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancesResponse.unreachable|unreachable}
   *   in
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancesResponse|ListInstancesResponse}.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Stream}
   *   An object stream which emits an object representing {@link protos.google.spanner.admin.instance.v1.Instance|Instance} on 'data' event.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed. Note that it can affect your quota.
   *   We recommend using `listInstancesAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
   *   for more details and examples.
   */
  listInstancesStream(
    request?: protos.google.spanner.admin.instance.v1.IListInstancesRequest,
    options?: CallOptions,
  ): Transform {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        parent: request.parent ?? '',
      });
    const defaultCallSettings = this._defaults['listInstances'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('listInstances stream %j', request);
    return this.descriptors.page.listInstances.createStream(
      this.innerApiCalls.listInstances as GaxCall,
      request,
      callSettings,
    );
  }

  /**
   * Equivalent to `listInstances`, but returns an iterable object.
   *
   * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The name of the project for which a list of instances is
   *   requested. Values are of the form `projects/<project>`.
   * @param {number} request.pageSize
   *   Number of instances to be returned in the response. If 0 or less, defaults
   *   to the server's maximum allowed page size.
   * @param {string} request.pageToken
   *   If non-empty, `page_token` should contain a
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancesResponse.next_page_token|next_page_token}
   *   from a previous
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancesResponse|ListInstancesResponse}.
   * @param {string} request.filter
   *   An expression for filtering the results of the request. Filter rules are
   *   case insensitive. The fields eligible for filtering are:
   *
   *     * `name`
   *     * `display_name`
   *     * `labels.key` where key is the name of a label
   *
   *   Some examples of using filters are:
   *
   *     * `name:*` --> The instance has a name.
   *     * `name:Howl` --> The instance's name contains the string "howl".
   *     * `name:HOWL` --> Equivalent to above.
   *     * `NAME:howl` --> Equivalent to above.
   *     * `labels.env:*` --> The instance has the label "env".
   *     * `labels.env:dev` --> The instance has the label "env" and the value of
   *                          the label contains the string "dev".
   *     * `name:howl labels.env:dev` --> The instance's name contains "howl" and
   *                                    it has the label "env" with its value
   *                                    containing "dev".
   * @param {google.protobuf.Timestamp} request.instanceDeadline
   *   Deadline used while retrieving metadata for instances.
   *   Instances whose metadata cannot be retrieved within this deadline will be
   *   added to
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancesResponse.unreachable|unreachable}
   *   in
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancesResponse|ListInstancesResponse}.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Object}
   *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
   *   When you iterate the returned iterable, each element will be an object representing
   *   {@link protos.google.spanner.admin.instance.v1.Instance|Instance}. The API will be called under the hood as needed, once per the page,
   *   so you can stop the iteration when you don't need more results.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
   *   for more details and examples.
   */
  listInstancesAsync(
    request?: protos.google.spanner.admin.instance.v1.IListInstancesRequest,
    options?: CallOptions,
  ): AsyncIterable<protos.google.spanner.admin.instance.v1.IInstance> {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        parent: request.parent ?? '',
      });
    const defaultCallSettings = this._defaults['listInstances'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('listInstances iterate %j', request);
    return this.descriptors.page.listInstances.asyncIterate(
      this.innerApiCalls['listInstances'] as GaxCall,
      request as {},
      callSettings,
    ) as AsyncIterable<protos.google.spanner.admin.instance.v1.IInstance>;
  }
  /**
   * Lists all instance partitions for the given instance.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The instance whose instance partitions should be listed. Values
   *   are of the form `projects/<project>/instances/<instance>`. Use `{instance}
   *   = '-'` to list instance partitions for all Instances in a project, e.g.,
   *   `projects/myproject/instances/-`.
   * @param {number} request.pageSize
   *   Number of instance partitions to be returned in the response. If 0 or less,
   *   defaults to the server's maximum allowed page size.
   * @param {string} request.pageToken
   *   If non-empty, `page_token` should contain a
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionsResponse.next_page_token|next_page_token}
   *   from a previous
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionsResponse|ListInstancePartitionsResponse}.
   * @param {google.protobuf.Timestamp} [request.instancePartitionDeadline]
   *   Optional. Deadline used while retrieving metadata for instance partitions.
   *   Instance partitions whose metadata cannot be retrieved within this deadline
   *   will be added to
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionsResponse.unreachable|unreachable}
   *   in
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionsResponse|ListInstancePartitionsResponse}.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is Array of {@link protos.google.spanner.admin.instance.v1.InstancePartition|InstancePartition}.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed and will merge results from all the pages into this array.
   *   Note that it can affect your quota.
   *   We recommend using `listInstancePartitionsAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
   *   for more details and examples.
   */
  listInstancePartitions(
    request?: protos.google.spanner.admin.instance.v1.IListInstancePartitionsRequest,
    options?: CallOptions,
  ): Promise<
    [
      protos.google.spanner.admin.instance.v1.IInstancePartition[],
      protos.google.spanner.admin.instance.v1.IListInstancePartitionsRequest | null,
      protos.google.spanner.admin.instance.v1.IListInstancePartitionsResponse,
    ]
  >;
  listInstancePartitions(
    request: protos.google.spanner.admin.instance.v1.IListInstancePartitionsRequest,
    options: CallOptions,
    callback: PaginationCallback<
      protos.google.spanner.admin.instance.v1.IListInstancePartitionsRequest,
      | protos.google.spanner.admin.instance.v1.IListInstancePartitionsResponse
      | null
      | undefined,
      protos.google.spanner.admin.instance.v1.IInstancePartition
    >,
  ): void;
  listInstancePartitions(
    request: protos.google.spanner.admin.instance.v1.IListInstancePartitionsRequest,
    callback: PaginationCallback<
      protos.google.spanner.admin.instance.v1.IListInstancePartitionsRequest,
      | protos.google.spanner.admin.instance.v1.IListInstancePartitionsResponse
      | null
      | undefined,
      protos.google.spanner.admin.instance.v1.IInstancePartition
    >,
  ): void;
  listInstancePartitions(
    request?: protos.google.spanner.admin.instance.v1.IListInstancePartitionsRequest,
    optionsOrCallback?:
      | CallOptions
      | PaginationCallback<
          protos.google.spanner.admin.instance.v1.IListInstancePartitionsRequest,
          | protos.google.spanner.admin.instance.v1.IListInstancePartitionsResponse
          | null
          | undefined,
          protos.google.spanner.admin.instance.v1.IInstancePartition
        >,
    callback?: PaginationCallback<
      protos.google.spanner.admin.instance.v1.IListInstancePartitionsRequest,
      | protos.google.spanner.admin.instance.v1.IListInstancePartitionsResponse
      | null
      | undefined,
      protos.google.spanner.admin.instance.v1.IInstancePartition
    >,
  ): Promise<
    [
      protos.google.spanner.admin.instance.v1.IInstancePartition[],
      protos.google.spanner.admin.instance.v1.IListInstancePartitionsRequest | null,
      protos.google.spanner.admin.instance.v1.IListInstancePartitionsResponse,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        parent: request.parent ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    const wrappedCallback:
      | PaginationCallback<
          protos.google.spanner.admin.instance.v1.IListInstancePartitionsRequest,
          | protos.google.spanner.admin.instance.v1.IListInstancePartitionsResponse
          | null
          | undefined,
          protos.google.spanner.admin.instance.v1.IInstancePartition
        >
      | undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listInstancePartitions values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listInstancePartitions request %j', request);
    return this.innerApiCalls
      .listInstancePartitions(request, options, wrappedCallback)
      ?.then(
        ([response, input, output]: [
          protos.google.spanner.admin.instance.v1.IInstancePartition[],
          protos.google.spanner.admin.instance.v1.IListInstancePartitionsRequest | null,
          protos.google.spanner.admin.instance.v1.IListInstancePartitionsResponse,
        ]) => {
          this._log.info('listInstancePartitions values %j', response);
          return [response, input, output];
        },
      );
  }

  /**
   * Equivalent to `listInstancePartitions`, but returns a NodeJS Stream object.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The instance whose instance partitions should be listed. Values
   *   are of the form `projects/<project>/instances/<instance>`. Use `{instance}
   *   = '-'` to list instance partitions for all Instances in a project, e.g.,
   *   `projects/myproject/instances/-`.
   * @param {number} request.pageSize
   *   Number of instance partitions to be returned in the response. If 0 or less,
   *   defaults to the server's maximum allowed page size.
   * @param {string} request.pageToken
   *   If non-empty, `page_token` should contain a
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionsResponse.next_page_token|next_page_token}
   *   from a previous
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionsResponse|ListInstancePartitionsResponse}.
   * @param {google.protobuf.Timestamp} [request.instancePartitionDeadline]
   *   Optional. Deadline used while retrieving metadata for instance partitions.
   *   Instance partitions whose metadata cannot be retrieved within this deadline
   *   will be added to
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionsResponse.unreachable|unreachable}
   *   in
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionsResponse|ListInstancePartitionsResponse}.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Stream}
   *   An object stream which emits an object representing {@link protos.google.spanner.admin.instance.v1.InstancePartition|InstancePartition} on 'data' event.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed. Note that it can affect your quota.
   *   We recommend using `listInstancePartitionsAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
   *   for more details and examples.
   */
  listInstancePartitionsStream(
    request?: protos.google.spanner.admin.instance.v1.IListInstancePartitionsRequest,
    options?: CallOptions,
  ): Transform {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        parent: request.parent ?? '',
      });
    const defaultCallSettings = this._defaults['listInstancePartitions'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('listInstancePartitions stream %j', request);
    return this.descriptors.page.listInstancePartitions.createStream(
      this.innerApiCalls.listInstancePartitions as GaxCall,
      request,
      callSettings,
    );
  }

  /**
   * Equivalent to `listInstancePartitions`, but returns an iterable object.
   *
   * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The instance whose instance partitions should be listed. Values
   *   are of the form `projects/<project>/instances/<instance>`. Use `{instance}
   *   = '-'` to list instance partitions for all Instances in a project, e.g.,
   *   `projects/myproject/instances/-`.
   * @param {number} request.pageSize
   *   Number of instance partitions to be returned in the response. If 0 or less,
   *   defaults to the server's maximum allowed page size.
   * @param {string} request.pageToken
   *   If non-empty, `page_token` should contain a
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionsResponse.next_page_token|next_page_token}
   *   from a previous
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionsResponse|ListInstancePartitionsResponse}.
   * @param {google.protobuf.Timestamp} [request.instancePartitionDeadline]
   *   Optional. Deadline used while retrieving metadata for instance partitions.
   *   Instance partitions whose metadata cannot be retrieved within this deadline
   *   will be added to
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionsResponse.unreachable|unreachable}
   *   in
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionsResponse|ListInstancePartitionsResponse}.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Object}
   *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
   *   When you iterate the returned iterable, each element will be an object representing
   *   {@link protos.google.spanner.admin.instance.v1.InstancePartition|InstancePartition}. The API will be called under the hood as needed, once per the page,
   *   so you can stop the iteration when you don't need more results.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
   *   for more details and examples.
   */
  listInstancePartitionsAsync(
    request?: protos.google.spanner.admin.instance.v1.IListInstancePartitionsRequest,
    options?: CallOptions,
  ): AsyncIterable<protos.google.spanner.admin.instance.v1.IInstancePartition> {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        parent: request.parent ?? '',
      });
    const defaultCallSettings = this._defaults['listInstancePartitions'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('listInstancePartitions iterate %j', request);
    return this.descriptors.page.listInstancePartitions.asyncIterate(
      this.innerApiCalls['listInstancePartitions'] as GaxCall,
      request as {},
      callSettings,
    ) as AsyncIterable<protos.google.spanner.admin.instance.v1.IInstancePartition>;
  }
  /**
   * Lists instance partition long-running operations in the given instance.
   * An instance partition operation has a name of the form
   * `projects/<project>/instances/<instance>/instancePartitions/<instance_partition>/operations/<operation>`.
   * The long-running operation
   * metadata field type
   * `metadata.type_url` describes the type of the metadata. Operations returned
   * include those that have completed/failed/canceled within the last 7 days,
   * and pending operations. Operations returned are ordered by
   * `operation.metadata.value.start_time` in descending order starting from the
   * most recently started operation.
   *
   * Authorization requires `spanner.instancePartitionOperations.list`
   * permission on the resource
   * {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest.parent|parent}.
   *
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The parent instance of the instance partition operations.
   *   Values are of the form `projects/<project>/instances/<instance>`.
   * @param {string} [request.filter]
   *   Optional. An expression that filters the list of returned operations.
   *
   *   A filter expression consists of a field name, a
   *   comparison operator, and a value for filtering.
   *   The value must be a string, a number, or a boolean. The comparison operator
   *   must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
   *   Colon `:` is the contains operator. Filter rules are not case sensitive.
   *
   *   The following fields in the Operation are eligible for filtering:
   *
   *     * `name` - The name of the long-running operation
   *     * `done` - False if the operation is in progress, else true.
   *     * `metadata.@type` - the type of metadata. For example, the type string
   *        for
   *        {@link protos.google.spanner.admin.instance.v1.CreateInstancePartitionMetadata|CreateInstancePartitionMetadata}
   *        is
   *        `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata`.
   *     * `metadata.<field_name>` - any field in metadata.value.
   *        `metadata.@type` must be specified first, if filtering on metadata
   *        fields.
   *     * `error` - Error associated with the long-running operation.
   *     * `response.@type` - the type of response.
   *     * `response.<field_name>` - any field in response.value.
   *
   *   You can combine multiple expressions by enclosing each expression in
   *   parentheses. By default, expressions are combined with AND logic. However,
   *   you can specify AND, OR, and NOT logic explicitly.
   *
   *   Here are a few examples:
   *
   *     * `done:true` - The operation is complete.
   *     * `(metadata.@type=` \
   *       `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata)
   *       AND` \
   *       `(metadata.instance_partition.name:custom-instance-partition) AND` \
   *       `(metadata.start_time < \"2021-03-28T14:50:00Z\") AND` \
   *       `(error:*)` - Return operations where:
   *       * The operation's metadata type is
   *       {@link protos.google.spanner.admin.instance.v1.CreateInstancePartitionMetadata|CreateInstancePartitionMetadata}.
   *       * The instance partition name contains "custom-instance-partition".
   *       * The operation started before 2021-03-28T14:50:00Z.
   *       * The operation resulted in an error.
   * @param {number} [request.pageSize]
   *   Optional. Number of operations to be returned in the response. If 0 or
   *   less, defaults to the server's maximum allowed page size.
   * @param {string} [request.pageToken]
   *   Optional. If non-empty, `page_token` should contain a
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse.next_page_token|next_page_token}
   *   from a previous
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse|ListInstancePartitionOperationsResponse}
   *   to the same `parent` and with the same `filter`.
   * @param {google.protobuf.Timestamp} [request.instancePartitionDeadline]
   *   Optional. Deadline used while retrieving metadata for instance partition
   *   operations. Instance partitions whose operation metadata cannot be
   *   retrieved within this deadline will be added to
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse.unreachable_instance_partitions|unreachable_instance_partitions}
   *   in
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse|ListInstancePartitionOperationsResponse}.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Promise} - The promise which resolves to an array.
   *   The first element of the array is Array of {@link protos.google.longrunning.Operation|Operation}.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed and will merge results from all the pages into this array.
   *   Note that it can affect your quota.
   *   We recommend using `listInstancePartitionOperationsAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
   *   for more details and examples.
   */
  listInstancePartitionOperations(
    request?: protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsRequest,
    options?: CallOptions,
  ): Promise<
    [
      protos.google.longrunning.IOperation[],
      protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsRequest | null,
      protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsResponse,
    ]
  >;
  listInstancePartitionOperations(
    request: protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsRequest,
    options: CallOptions,
    callback: PaginationCallback<
      protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsRequest,
      | protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsResponse
      | null
      | undefined,
      protos.google.longrunning.IOperation
    >,
  ): void;
  listInstancePartitionOperations(
    request: protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsRequest,
    callback: PaginationCallback<
      protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsRequest,
      | protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsResponse
      | null
      | undefined,
      protos.google.longrunning.IOperation
    >,
  ): void;
  listInstancePartitionOperations(
    request?: protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsRequest,
    optionsOrCallback?:
      | CallOptions
      | PaginationCallback<
          protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsRequest,
          | protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsResponse
          | null
          | undefined,
          protos.google.longrunning.IOperation
        >,
    callback?: PaginationCallback<
      protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsRequest,
      | protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsResponse
      | null
      | undefined,
      protos.google.longrunning.IOperation
    >,
  ): Promise<
    [
      protos.google.longrunning.IOperation[],
      protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsRequest | null,
      protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsResponse,
    ]
  > | void {
    request = request || {};
    let options: CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        parent: request.parent ?? '',
      });
    this.initialize().catch(err => {
      throw err;
    });
    const wrappedCallback:
      | PaginationCallback<
          protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsRequest,
          | protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsResponse
          | null
          | undefined,
          protos.google.longrunning.IOperation
        >
      | undefined = callback
      ? (error, values, nextPageRequest, rawResponse) => {
          this._log.info('listInstancePartitionOperations values %j', values);
          callback!(error, values, nextPageRequest, rawResponse); // We verified callback above.
        }
      : undefined;
    this._log.info('listInstancePartitionOperations request %j', request);
    return this.innerApiCalls
      .listInstancePartitionOperations(request, options, wrappedCallback)
      ?.then(
        ([response, input, output]: [
          protos.google.longrunning.IOperation[],
          protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsRequest | null,
          protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsResponse,
        ]) => {
          this._log.info('listInstancePartitionOperations values %j', response);
          return [response, input, output];
        },
      );
  }

  /**
   * Equivalent to `listInstancePartitionOperations`, but returns a NodeJS Stream object.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The parent instance of the instance partition operations.
   *   Values are of the form `projects/<project>/instances/<instance>`.
   * @param {string} [request.filter]
   *   Optional. An expression that filters the list of returned operations.
   *
   *   A filter expression consists of a field name, a
   *   comparison operator, and a value for filtering.
   *   The value must be a string, a number, or a boolean. The comparison operator
   *   must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
   *   Colon `:` is the contains operator. Filter rules are not case sensitive.
   *
   *   The following fields in the Operation are eligible for filtering:
   *
   *     * `name` - The name of the long-running operation
   *     * `done` - False if the operation is in progress, else true.
   *     * `metadata.@type` - the type of metadata. For example, the type string
   *        for
   *        {@link protos.google.spanner.admin.instance.v1.CreateInstancePartitionMetadata|CreateInstancePartitionMetadata}
   *        is
   *        `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata`.
   *     * `metadata.<field_name>` - any field in metadata.value.
   *        `metadata.@type` must be specified first, if filtering on metadata
   *        fields.
   *     * `error` - Error associated with the long-running operation.
   *     * `response.@type` - the type of response.
   *     * `response.<field_name>` - any field in response.value.
   *
   *   You can combine multiple expressions by enclosing each expression in
   *   parentheses. By default, expressions are combined with AND logic. However,
   *   you can specify AND, OR, and NOT logic explicitly.
   *
   *   Here are a few examples:
   *
   *     * `done:true` - The operation is complete.
   *     * `(metadata.@type=` \
   *       `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata)
   *       AND` \
   *       `(metadata.instance_partition.name:custom-instance-partition) AND` \
   *       `(metadata.start_time < \"2021-03-28T14:50:00Z\") AND` \
   *       `(error:*)` - Return operations where:
   *       * The operation's metadata type is
   *       {@link protos.google.spanner.admin.instance.v1.CreateInstancePartitionMetadata|CreateInstancePartitionMetadata}.
   *       * The instance partition name contains "custom-instance-partition".
   *       * The operation started before 2021-03-28T14:50:00Z.
   *       * The operation resulted in an error.
   * @param {number} [request.pageSize]
   *   Optional. Number of operations to be returned in the response. If 0 or
   *   less, defaults to the server's maximum allowed page size.
   * @param {string} [request.pageToken]
   *   Optional. If non-empty, `page_token` should contain a
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse.next_page_token|next_page_token}
   *   from a previous
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse|ListInstancePartitionOperationsResponse}
   *   to the same `parent` and with the same `filter`.
   * @param {google.protobuf.Timestamp} [request.instancePartitionDeadline]
   *   Optional. Deadline used while retrieving metadata for instance partition
   *   operations. Instance partitions whose operation metadata cannot be
   *   retrieved within this deadline will be added to
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse.unreachable_instance_partitions|unreachable_instance_partitions}
   *   in
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse|ListInstancePartitionOperationsResponse}.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Stream}
   *   An object stream which emits an object representing {@link protos.google.longrunning.Operation|Operation} on 'data' event.
   *   The client library will perform auto-pagination by default: it will call the API as many
   *   times as needed. Note that it can affect your quota.
   *   We recommend using `listInstancePartitionOperationsAsync()`
   *   method described below for async iteration which you can stop as needed.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
   *   for more details and examples.
   */
  listInstancePartitionOperationsStream(
    request?: protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsRequest,
    options?: CallOptions,
  ): Transform {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        parent: request.parent ?? '',
      });
    const defaultCallSettings =
      this._defaults['listInstancePartitionOperations'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('listInstancePartitionOperations stream %j', request);
    return this.descriptors.page.listInstancePartitionOperations.createStream(
      this.innerApiCalls.listInstancePartitionOperations as GaxCall,
      request,
      callSettings,
    );
  }

  /**
   * Equivalent to `listInstancePartitionOperations`, but returns an iterable object.
   *
   * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
   * @param {Object} request
   *   The request object that will be sent.
   * @param {string} request.parent
   *   Required. The parent instance of the instance partition operations.
   *   Values are of the form `projects/<project>/instances/<instance>`.
   * @param {string} [request.filter]
   *   Optional. An expression that filters the list of returned operations.
   *
   *   A filter expression consists of a field name, a
   *   comparison operator, and a value for filtering.
   *   The value must be a string, a number, or a boolean. The comparison operator
   *   must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
   *   Colon `:` is the contains operator. Filter rules are not case sensitive.
   *
   *   The following fields in the Operation are eligible for filtering:
   *
   *     * `name` - The name of the long-running operation
   *     * `done` - False if the operation is in progress, else true.
   *     * `metadata.@type` - the type of metadata. For example, the type string
   *        for
   *        {@link protos.google.spanner.admin.instance.v1.CreateInstancePartitionMetadata|CreateInstancePartitionMetadata}
   *        is
   *        `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata`.
   *     * `metadata.<field_name>` - any field in metadata.value.
   *        `metadata.@type` must be specified first, if filtering on metadata
   *        fields.
   *     * `error` - Error associated with the long-running operation.
   *     * `response.@type` - the type of response.
   *     * `response.<field_name>` - any field in response.value.
   *
   *   You can combine multiple expressions by enclosing each expression in
   *   parentheses. By default, expressions are combined with AND logic. However,
   *   you can specify AND, OR, and NOT logic explicitly.
   *
   *   Here are a few examples:
   *
   *     * `done:true` - The operation is complete.
   *     * `(metadata.@type=` \
   *       `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata)
   *       AND` \
   *       `(metadata.instance_partition.name:custom-instance-partition) AND` \
   *       `(metadata.start_time < \"2021-03-28T14:50:00Z\") AND` \
   *       `(error:*)` - Return operations where:
   *       * The operation's metadata type is
   *       {@link protos.google.spanner.admin.instance.v1.CreateInstancePartitionMetadata|CreateInstancePartitionMetadata}.
   *       * The instance partition name contains "custom-instance-partition".
   *       * The operation started before 2021-03-28T14:50:00Z.
   *       * The operation resulted in an error.
   * @param {number} [request.pageSize]
   *   Optional. Number of operations to be returned in the response. If 0 or
   *   less, defaults to the server's maximum allowed page size.
   * @param {string} [request.pageToken]
   *   Optional. If non-empty, `page_token` should contain a
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse.next_page_token|next_page_token}
   *   from a previous
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse|ListInstancePartitionOperationsResponse}
   *   to the same `parent` and with the same `filter`.
   * @param {google.protobuf.Timestamp} [request.instancePartitionDeadline]
   *   Optional. Deadline used while retrieving metadata for instance partition
   *   operations. Instance partitions whose operation metadata cannot be
   *   retrieved within this deadline will be added to
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse.unreachable_instance_partitions|unreachable_instance_partitions}
   *   in
   *   {@link protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse|ListInstancePartitionOperationsResponse}.
   * @param {object} [options]
   *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
   * @returns {Object}
   *   An iterable Object that allows {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | async iteration }.
   *   When you iterate the returned iterable, each element will be an object representing
   *   {@link protos.google.longrunning.Operation|Operation}. The API will be called under the hood as needed, once per the page,
   *   so you can stop the iteration when you don't need more results.
   *   Please see the {@link https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination | documentation }
   *   for more details and examples.
   */
  listInstancePartitionOperationsAsync(
    request?: protos.google.spanner.admin.instance.v1.IListInstancePartitionOperationsRequest,
    options?: CallOptions,
  ): AsyncIterable<protos.google.longrunning.IOperation> {
    request = request || {};
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        parent: request.parent ?? '',
      });
    const defaultCallSettings =
      this._defaults['listInstancePartitionOperations'];
    const callSettings = defaultCallSettings.merge(options);
    this.initialize().catch(err => {
      throw err;
    });
    this._log.info('listInstancePartitionOperations iterate %j', request);
    return this.descriptors.page.listInstancePartitionOperations.asyncIterate(
      this.innerApiCalls['listInstancePartitionOperations'] as GaxCall,
      request as {},
      callSettings,
    ) as AsyncIterable<protos.google.longrunning.IOperation>;
  }
  /**
   * Gets the latest state of a long-running operation.  Clients can use this
   * method to poll the operation result at intervals as recommended by the API
   * service.
   *
   * @param {Object} request - The request object that will be sent.
   * @param {string} request.name - The name of the operation resource.
   * @param {Object=} options
   *   Optional parameters. You can override the default settings for this call,
   *   e.g, timeout, retries, paginations, etc. See {@link
   *   https://googleapis.github.io/gax-nodejs/global.html#CallOptions | gax.CallOptions}
   *   for the details.
   * @param {function(?Error, ?Object)=} callback
   *   The function which will be called with the result of the API call.
   *
   *   The second parameter to the callback is an object representing
   *   {@link google.longrunning.Operation | google.longrunning.Operation}.
   * @return {Promise} - The promise which resolves to an array.
   *   The first element of the array is an object representing
   * {@link google.longrunning.Operation | google.longrunning.Operation}.
   * The promise has a method named "cancel" which cancels the ongoing API call.
   *
   * @example
   * ```
   * const client = longrunning.operationsClient();
   * const name = '';
   * const [response] = await client.getOperation({name});
   * // doThingsWith(response)
   * ```
   */
  getOperation(
    request: protos.google.longrunning.GetOperationRequest,
    optionsOrCallback?:
      | gax.CallOptions
      | Callback<
          protos.google.longrunning.Operation,
          protos.google.longrunning.GetOperationRequest,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.longrunning.Operation,
      protos.google.longrunning.GetOperationRequest,
      {} | null | undefined
    >,
  ): Promise<[protos.google.longrunning.Operation]> {
    let options: gax.CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as gax.CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        name: request.name ?? '',
      });
    return this.operationsClient.getOperation(request, options, callback);
  }
  /**
   * Lists operations that match the specified filter in the request. If the
   * server doesn't support this method, it returns `UNIMPLEMENTED`. Returns an iterable object.
   *
   * For-await-of syntax is used with the iterable to recursively get response element on-demand.
   *
   * @param {Object} request - The request object that will be sent.
   * @param {string} request.name - The name of the operation collection.
   * @param {string} request.filter - The standard list filter.
   * @param {number=} request.pageSize -
   *   The maximum number of resources contained in the underlying API
   *   response. If page streaming is performed per-resource, this
   *   parameter does not affect the return value. If page streaming is
   *   performed per-page, this determines the maximum number of
   *   resources in a page.
   * @param {Object=} options
   *   Optional parameters. You can override the default settings for this call,
   *   e.g, timeout, retries, paginations, etc. See {@link
   *   https://googleapis.github.io/gax-nodejs/global.html#CallOptions | gax.CallOptions} for the
   *   details.
   * @returns {Object}
   *   An iterable Object that conforms to {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols | iteration protocols}.
   *
   * @example
   * ```
   * const client = longrunning.operationsClient();
   * for await (const response of client.listOperationsAsync(request));
   * // doThingsWith(response)
   * ```
   */
  listOperationsAsync(
    request: protos.google.longrunning.ListOperationsRequest,
    options?: gax.CallOptions,
  ): AsyncIterable<protos.google.longrunning.IOperation> {
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        name: request.name ?? '',
      });
    return this.operationsClient.listOperationsAsync(request, options);
  }
  /**
   * Starts asynchronous cancellation on a long-running operation.  The server
   * makes a best effort to cancel the operation, but success is not
   * guaranteed.  If the server doesn't support this method, it returns
   * `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
   * {@link Operations.GetOperation} or
   * other methods to check whether the cancellation succeeded or whether the
   * operation completed despite cancellation. On successful cancellation,
   * the operation is not deleted; instead, it becomes an operation with
   * an {@link Operation.error} value with a {@link google.rpc.Status.code} of
   * 1, corresponding to `Code.CANCELLED`.
   *
   * @param {Object} request - The request object that will be sent.
   * @param {string} request.name - The name of the operation resource to be cancelled.
   * @param {Object=} options
   *   Optional parameters. You can override the default settings for this call,
   * e.g, timeout, retries, paginations, etc. See {@link
   * https://googleapis.github.io/gax-nodejs/global.html#CallOptions | gax.CallOptions} for the
   * details.
   * @param {function(?Error)=} callback
   *   The function which will be called with the result of the API call.
   * @return {Promise} - The promise which resolves when API call finishes.
   *   The promise has a method named "cancel" which cancels the ongoing API
   * call.
   *
   * @example
   * ```
   * const client = longrunning.operationsClient();
   * await client.cancelOperation({name: ''});
   * ```
   */
  cancelOperation(
    request: protos.google.longrunning.CancelOperationRequest,
    optionsOrCallback?:
      | gax.CallOptions
      | Callback<
          protos.google.longrunning.CancelOperationRequest,
          protos.google.protobuf.Empty,
          {} | undefined | null
        >,
    callback?: Callback<
      protos.google.longrunning.CancelOperationRequest,
      protos.google.protobuf.Empty,
      {} | undefined | null
    >,
  ): Promise<protos.google.protobuf.Empty> {
    let options: gax.CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as gax.CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        name: request.name ?? '',
      });
    return this.operationsClient.cancelOperation(request, options, callback);
  }

  /**
   * Deletes a long-running operation. This method indicates that the client is
   * no longer interested in the operation result. It does not cancel the
   * operation. If the server doesn't support this method, it returns
   * `google.rpc.Code.UNIMPLEMENTED`.
   *
   * @param {Object} request - The request object that will be sent.
   * @param {string} request.name - The name of the operation resource to be deleted.
   * @param {Object=} options
   *   Optional parameters. You can override the default settings for this call,
   * e.g, timeout, retries, paginations, etc. See {@link
   * https://googleapis.github.io/gax-nodejs/global.html#CallOptions | gax.CallOptions}
   * for the details.
   * @param {function(?Error)=} callback
   *   The function which will be called with the result of the API call.
   * @return {Promise} - The promise which resolves when API call finishes.
   *   The promise has a method named "cancel" which cancels the ongoing API
   * call.
   *
   * @example
   * ```
   * const client = longrunning.operationsClient();
   * await client.deleteOperation({name: ''});
   * ```
   */
  deleteOperation(
    request: protos.google.longrunning.DeleteOperationRequest,
    optionsOrCallback?:
      | gax.CallOptions
      | Callback<
          protos.google.protobuf.Empty,
          protos.google.longrunning.DeleteOperationRequest,
          {} | null | undefined
        >,
    callback?: Callback<
      protos.google.protobuf.Empty,
      protos.google.longrunning.DeleteOperationRequest,
      {} | null | undefined
    >,
  ): Promise<protos.google.protobuf.Empty> {
    let options: gax.CallOptions;
    if (typeof optionsOrCallback === 'function' && callback === undefined) {
      callback = optionsOrCallback;
      options = {};
    } else {
      options = optionsOrCallback as gax.CallOptions;
    }
    options = options || {};
    options.otherArgs = options.otherArgs || {};
    options.otherArgs.headers = options.otherArgs.headers || {};
    options.otherArgs.headers['x-goog-request-params'] =
      this._gaxModule.routingHeader.fromParams({
        name: request.name ?? '',
      });
    return this.operationsClient.deleteOperation(request, options, callback);
  }

  // --------------------
  // -- Path templates --
  // --------------------

  /**
   * Return a fully-qualified instance resource name string.
   *
   * @param {string} project
   * @param {string} instance
   * @returns {string} Resource name string.
   */
  instancePath(project: string, instance: string) {
    return this.pathTemplates.instancePathTemplate.render({
      project: project,
      instance: instance,
    });
  }

  /**
   * Parse the project from Instance resource.
   *
   * @param {string} instanceName
   *   A fully-qualified path representing Instance resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromInstanceName(instanceName: string) {
    return this.pathTemplates.instancePathTemplate.match(instanceName).project;
  }

  /**
   * Parse the instance from Instance resource.
   *
   * @param {string} instanceName
   *   A fully-qualified path representing Instance resource.
   * @returns {string} A string representing the instance.
   */
  matchInstanceFromInstanceName(instanceName: string) {
    return this.pathTemplates.instancePathTemplate.match(instanceName).instance;
  }

  /**
   * Return a fully-qualified instanceConfig resource name string.
   *
   * @param {string} project
   * @param {string} instance_config
   * @returns {string} Resource name string.
   */
  instanceConfigPath(project: string, instanceConfig: string) {
    return this.pathTemplates.instanceConfigPathTemplate.render({
      project: project,
      instance_config: instanceConfig,
    });
  }

  /**
   * Parse the project from InstanceConfig resource.
   *
   * @param {string} instanceConfigName
   *   A fully-qualified path representing InstanceConfig resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromInstanceConfigName(instanceConfigName: string) {
    return this.pathTemplates.instanceConfigPathTemplate.match(
      instanceConfigName,
    ).project;
  }

  /**
   * Parse the instance_config from InstanceConfig resource.
   *
   * @param {string} instanceConfigName
   *   A fully-qualified path representing InstanceConfig resource.
   * @returns {string} A string representing the instance_config.
   */
  matchInstanceConfigFromInstanceConfigName(instanceConfigName: string) {
    return this.pathTemplates.instanceConfigPathTemplate.match(
      instanceConfigName,
    ).instance_config;
  }

  /**
   * Return a fully-qualified instancePartition resource name string.
   *
   * @param {string} project
   * @param {string} instance
   * @param {string} instance_partition
   * @returns {string} Resource name string.
   */
  instancePartitionPath(
    project: string,
    instance: string,
    instancePartition: string,
  ) {
    return this.pathTemplates.instancePartitionPathTemplate.render({
      project: project,
      instance: instance,
      instance_partition: instancePartition,
    });
  }

  /**
   * Parse the project from InstancePartition resource.
   *
   * @param {string} instancePartitionName
   *   A fully-qualified path representing InstancePartition resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromInstancePartitionName(instancePartitionName: string) {
    return this.pathTemplates.instancePartitionPathTemplate.match(
      instancePartitionName,
    ).project;
  }

  /**
   * Parse the instance from InstancePartition resource.
   *
   * @param {string} instancePartitionName
   *   A fully-qualified path representing InstancePartition resource.
   * @returns {string} A string representing the instance.
   */
  matchInstanceFromInstancePartitionName(instancePartitionName: string) {
    return this.pathTemplates.instancePartitionPathTemplate.match(
      instancePartitionName,
    ).instance;
  }

  /**
   * Parse the instance_partition from InstancePartition resource.
   *
   * @param {string} instancePartitionName
   *   A fully-qualified path representing InstancePartition resource.
   * @returns {string} A string representing the instance_partition.
   */
  matchInstancePartitionFromInstancePartitionName(
    instancePartitionName: string,
  ) {
    return this.pathTemplates.instancePartitionPathTemplate.match(
      instancePartitionName,
    ).instance_partition;
  }

  /**
   * Return a fully-qualified project resource name string.
   *
   * @param {string} project
   * @returns {string} Resource name string.
   */
  projectPath(project: string) {
    return this.pathTemplates.projectPathTemplate.render({
      project: project,
    });
  }

  /**
   * Parse the project from Project resource.
   *
   * @param {string} projectName
   *   A fully-qualified path representing Project resource.
   * @returns {string} A string representing the project.
   */
  matchProjectFromProjectName(projectName: string) {
    return this.pathTemplates.projectPathTemplate.match(projectName).project;
  }

  /**
   * Terminate the gRPC channel and close the client.
   *
   * The client will no longer be usable and all future behavior is undefined.
   * @returns {Promise} A promise that resolves when the client is closed.
   */
  close(): Promise<void> {
    if (this.instanceAdminStub && !this._terminated) {
      return this.instanceAdminStub.then(stub => {
        this._log.info('ending gRPC channel');
        this._terminated = true;
        stub.close();
        void this.operationsClient.close();
      });
    }
    return Promise.resolve();
  }
}
