// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **

import * as protos from '../protos/protos';
import * as assert from 'assert';
import * as sinon from 'sinon';
import {SinonStub} from 'sinon';
import {describe, it} from 'mocha';
import * as databaseadminModule from '../src';

import {PassThrough} from 'stream';

import {protobuf, LROperation, operationsProtos} from 'google-gax';

// Dynamically loaded proto JSON is needed to get the type information
// to fill in default values for request objects
const root = protobuf.Root.fromJSON(
  require('../protos/protos.json'),
).resolveAll();

// eslint-disable-next-line @typescript-eslint/no-unused-vars
function getTypeDefaultValue(typeName: string, fields: string[]) {
  let type = root.lookupType(typeName) as protobuf.Type;
  for (const field of fields.slice(0, -1)) {
    type = type.fields[field]?.resolvedType as protobuf.Type;
  }
  return type.fields[fields[fields.length - 1]]?.defaultValue;
}

function generateSampleMessage<T extends object>(instance: T) {
  const filledObject = (
    instance.constructor as typeof protobuf.Message
  ).toObject(instance as protobuf.Message<T>, {defaults: true});
  return (instance.constructor as typeof protobuf.Message).fromObject(
    filledObject,
  ) as T;
}

function stubSimpleCall<ResponseType>(response?: ResponseType, error?: Error) {
  return error
    ? sinon.stub().rejects(error)
    : sinon.stub().resolves([response]);
}

function stubSimpleCallWithCallback<ResponseType>(
  response?: ResponseType,
  error?: Error,
) {
  return error
    ? sinon.stub().callsArgWith(2, error)
    : sinon.stub().callsArgWith(2, null, response);
}

function stubLongRunningCall<ResponseType>(
  response?: ResponseType,
  callError?: Error,
  lroError?: Error,
) {
  const innerStub = lroError
    ? sinon.stub().rejects(lroError)
    : sinon.stub().resolves([response]);
  const mockOperation = {
    promise: innerStub,
  };
  return callError
    ? sinon.stub().rejects(callError)
    : sinon.stub().resolves([mockOperation]);
}

function stubLongRunningCallWithCallback<ResponseType>(
  response?: ResponseType,
  callError?: Error,
  lroError?: Error,
) {
  const innerStub = lroError
    ? sinon.stub().rejects(lroError)
    : sinon.stub().resolves([response]);
  const mockOperation = {
    promise: innerStub,
  };
  return callError
    ? sinon.stub().callsArgWith(2, callError)
    : sinon.stub().callsArgWith(2, null, mockOperation);
}

function stubPageStreamingCall<ResponseType>(
  responses?: ResponseType[],
  error?: Error,
) {
  const pagingStub = sinon.stub();
  if (responses) {
    for (let i = 0; i < responses.length; ++i) {
      pagingStub.onCall(i).callsArgWith(2, null, responses[i]);
    }
  }
  const transformStub = error
    ? sinon.stub().callsArgWith(2, error)
    : pagingStub;
  const mockStream = new PassThrough({
    objectMode: true,
    transform: transformStub,
  });
  // trigger as many responses as needed
  if (responses) {
    for (let i = 0; i < responses.length; ++i) {
      setImmediate(() => {
        mockStream.write({});
      });
    }
    setImmediate(() => {
      mockStream.end();
    });
  } else {
    setImmediate(() => {
      mockStream.write({});
    });
    setImmediate(() => {
      mockStream.end();
    });
  }
  return sinon.stub().returns(mockStream);
}

function stubAsyncIterationCall<ResponseType>(
  responses?: ResponseType[],
  error?: Error,
) {
  let counter = 0;
  const asyncIterable = {
    [Symbol.asyncIterator]() {
      return {
        async next() {
          if (error) {
            return Promise.reject(error);
          }
          if (counter >= responses!.length) {
            return Promise.resolve({done: true, value: undefined});
          }
          return Promise.resolve({done: false, value: responses![counter++]});
        },
      };
    },
  };
  return sinon.stub().returns(asyncIterable);
}

describe('v1.DatabaseAdminClient', () => {
  describe('Common methods', () => {
    it('has apiEndpoint', () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient();
      const apiEndpoint = client.apiEndpoint;
      assert.strictEqual(apiEndpoint, 'spanner.googleapis.com');
    });

    it('has universeDomain', () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient();
      const universeDomain = client.universeDomain;
      assert.strictEqual(universeDomain, 'googleapis.com');
    });

    if (
      typeof process === 'object' &&
      typeof process.emitWarning === 'function'
    ) {
      it('throws DeprecationWarning if static servicePath is used', () => {
        const stub = sinon.stub(process, 'emitWarning');
        const servicePath =
          databaseadminModule.v1.DatabaseAdminClient.servicePath;
        assert.strictEqual(servicePath, 'spanner.googleapis.com');
        assert(stub.called);
        stub.restore();
      });

      it('throws DeprecationWarning if static apiEndpoint is used', () => {
        const stub = sinon.stub(process, 'emitWarning');
        const apiEndpoint =
          databaseadminModule.v1.DatabaseAdminClient.apiEndpoint;
        assert.strictEqual(apiEndpoint, 'spanner.googleapis.com');
        assert(stub.called);
        stub.restore();
      });
    }
    it('sets apiEndpoint according to universe domain camelCase', () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        universeDomain: 'example.com',
      });
      const servicePath = client.apiEndpoint;
      assert.strictEqual(servicePath, 'spanner.example.com');
    });

    it('sets apiEndpoint according to universe domain snakeCase', () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        universe_domain: 'example.com',
      });
      const servicePath = client.apiEndpoint;
      assert.strictEqual(servicePath, 'spanner.example.com');
    });

    if (typeof process === 'object' && 'env' in process) {
      describe('GOOGLE_CLOUD_UNIVERSE_DOMAIN environment variable', () => {
        it('sets apiEndpoint from environment variable', () => {
          const saved = process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
          process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = 'example.com';
          const client = new databaseadminModule.v1.DatabaseAdminClient();
          const servicePath = client.apiEndpoint;
          assert.strictEqual(servicePath, 'spanner.example.com');
          if (saved) {
            process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = saved;
          } else {
            delete process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
          }
        });

        it('value configured in code has priority over environment variable', () => {
          const saved = process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
          process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = 'example.com';
          const client = new databaseadminModule.v1.DatabaseAdminClient({
            universeDomain: 'configured.example.com',
          });
          const servicePath = client.apiEndpoint;
          assert.strictEqual(servicePath, 'spanner.configured.example.com');
          if (saved) {
            process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = saved;
          } else {
            delete process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
          }
        });
      });
    }
    it('does not allow setting both universeDomain and universe_domain', () => {
      assert.throws(() => {
        new databaseadminModule.v1.DatabaseAdminClient({
          universe_domain: 'example.com',
          universeDomain: 'example.net',
        });
      });
    });

    it('has port', () => {
      const port = databaseadminModule.v1.DatabaseAdminClient.port;
      assert(port);
      assert(typeof port === 'number');
    });

    it('should create a client with no option', () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient();
      assert(client);
    });

    it('should create a client with gRPC fallback', () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        fallback: true,
      });
      assert(client);
    });

    it('has initialize method and supports deferred initialization', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      assert.strictEqual(client.databaseAdminStub, undefined);
      await client.initialize();
      assert(client.databaseAdminStub);
    });

    it('has close method for the initialized client', done => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      client.initialize().catch(err => {
        throw err;
      });
      assert(client.databaseAdminStub);
      client
        .close()
        .then(() => {
          done();
        })
        .catch(err => {
          throw err;
        });
    });

    it('has close method for the non-initialized client', done => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      assert.strictEqual(client.databaseAdminStub, undefined);
      client
        .close()
        .then(() => {
          done();
        })
        .catch(err => {
          throw err;
        });
    });

    it('has getProjectId method', async () => {
      const fakeProjectId = 'fake-project-id';
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      client.auth.getProjectId = sinon.stub().resolves(fakeProjectId);
      const result = await client.getProjectId();
      assert.strictEqual(result, fakeProjectId);
      assert((client.auth.getProjectId as SinonStub).calledWithExactly());
    });

    it('has getProjectId method with callback', async () => {
      const fakeProjectId = 'fake-project-id';
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      client.auth.getProjectId = sinon
        .stub()
        .callsArgWith(0, null, fakeProjectId);
      const promise = new Promise((resolve, reject) => {
        client.getProjectId((err?: Error | null, projectId?: string | null) => {
          if (err) {
            reject(err);
          } else {
            resolve(projectId);
          }
        });
      });
      const result = await promise;
      assert.strictEqual(result, fakeProjectId);
    });
  });

  describe('getDatabase', () => {
    it('invokes getDatabase without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.GetDatabaseRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.GetDatabaseRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.Database(),
      );
      client.innerApiCalls.getDatabase = stubSimpleCall(expectedResponse);
      const [response] = await client.getDatabase(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.getDatabase as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getDatabase as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getDatabase without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.GetDatabaseRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.GetDatabaseRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.Database(),
      );
      client.innerApiCalls.getDatabase =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.getDatabase(
          request,
          (
            err?: Error | null,
            result?: protos.google.spanner.admin.database.v1.IDatabase | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.getDatabase as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getDatabase as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getDatabase with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.GetDatabaseRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.GetDatabaseRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.getDatabase = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.getDatabase(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.getDatabase as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getDatabase as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getDatabase with closed client', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.GetDatabaseRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.GetDatabaseRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.getDatabase(request), expectedError);
    });
  });

  describe('dropDatabase', () => {
    it('invokes dropDatabase without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.DropDatabaseRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.DropDatabaseRequest',
        ['database'],
      );
      request.database = defaultValue1;
      const expectedHeaderRequestParams = `database=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.innerApiCalls.dropDatabase = stubSimpleCall(expectedResponse);
      const [response] = await client.dropDatabase(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.dropDatabase as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.dropDatabase as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes dropDatabase without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.DropDatabaseRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.DropDatabaseRequest',
        ['database'],
      );
      request.database = defaultValue1;
      const expectedHeaderRequestParams = `database=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.innerApiCalls.dropDatabase =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.dropDatabase(
          request,
          (
            err?: Error | null,
            result?: protos.google.protobuf.IEmpty | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.dropDatabase as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.dropDatabase as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes dropDatabase with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.DropDatabaseRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.DropDatabaseRequest',
        ['database'],
      );
      request.database = defaultValue1;
      const expectedHeaderRequestParams = `database=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.dropDatabase = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.dropDatabase(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.dropDatabase as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.dropDatabase as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes dropDatabase with closed client', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.DropDatabaseRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.DropDatabaseRequest',
        ['database'],
      );
      request.database = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.dropDatabase(request), expectedError);
    });
  });

  describe('getDatabaseDdl', () => {
    it('invokes getDatabaseDdl without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.GetDatabaseDdlRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.GetDatabaseDdlRequest',
        ['database'],
      );
      request.database = defaultValue1;
      const expectedHeaderRequestParams = `database=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.GetDatabaseDdlResponse(),
      );
      client.innerApiCalls.getDatabaseDdl = stubSimpleCall(expectedResponse);
      const [response] = await client.getDatabaseDdl(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.getDatabaseDdl as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getDatabaseDdl as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getDatabaseDdl without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.GetDatabaseDdlRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.GetDatabaseDdlRequest',
        ['database'],
      );
      request.database = defaultValue1;
      const expectedHeaderRequestParams = `database=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.GetDatabaseDdlResponse(),
      );
      client.innerApiCalls.getDatabaseDdl =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.getDatabaseDdl(
          request,
          (
            err?: Error | null,
            result?: protos.google.spanner.admin.database.v1.IGetDatabaseDdlResponse | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.getDatabaseDdl as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getDatabaseDdl as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getDatabaseDdl with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.GetDatabaseDdlRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.GetDatabaseDdlRequest',
        ['database'],
      );
      request.database = defaultValue1;
      const expectedHeaderRequestParams = `database=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.getDatabaseDdl = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.getDatabaseDdl(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.getDatabaseDdl as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getDatabaseDdl as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getDatabaseDdl with closed client', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.GetDatabaseDdlRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.GetDatabaseDdlRequest',
        ['database'],
      );
      request.database = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.getDatabaseDdl(request), expectedError);
    });
  });

  describe('setIamPolicy', () => {
    it('invokes setIamPolicy without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.SetIamPolicyRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.SetIamPolicyRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedHeaderRequestParams = `resource=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.iam.v1.Policy(),
      );
      client.innerApiCalls.setIamPolicy = stubSimpleCall(expectedResponse);
      const [response] = await client.setIamPolicy(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.setIamPolicy as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.setIamPolicy as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes setIamPolicy without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.SetIamPolicyRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.SetIamPolicyRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedHeaderRequestParams = `resource=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.iam.v1.Policy(),
      );
      client.innerApiCalls.setIamPolicy =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.setIamPolicy(
          request,
          (
            err?: Error | null,
            result?: protos.google.iam.v1.IPolicy | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.setIamPolicy as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.setIamPolicy as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes setIamPolicy with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.SetIamPolicyRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.SetIamPolicyRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedHeaderRequestParams = `resource=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.setIamPolicy = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.setIamPolicy(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.setIamPolicy as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.setIamPolicy as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes setIamPolicy with closed client', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.SetIamPolicyRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.SetIamPolicyRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.setIamPolicy(request), expectedError);
    });
  });

  describe('getIamPolicy', () => {
    it('invokes getIamPolicy without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.GetIamPolicyRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.GetIamPolicyRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedHeaderRequestParams = `resource=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.iam.v1.Policy(),
      );
      client.innerApiCalls.getIamPolicy = stubSimpleCall(expectedResponse);
      const [response] = await client.getIamPolicy(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.getIamPolicy as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getIamPolicy as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getIamPolicy without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.GetIamPolicyRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.GetIamPolicyRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedHeaderRequestParams = `resource=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.iam.v1.Policy(),
      );
      client.innerApiCalls.getIamPolicy =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.getIamPolicy(
          request,
          (
            err?: Error | null,
            result?: protos.google.iam.v1.IPolicy | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.getIamPolicy as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getIamPolicy as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getIamPolicy with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.GetIamPolicyRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.GetIamPolicyRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedHeaderRequestParams = `resource=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.getIamPolicy = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.getIamPolicy(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.getIamPolicy as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getIamPolicy as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getIamPolicy with closed client', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.GetIamPolicyRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.GetIamPolicyRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.getIamPolicy(request), expectedError);
    });
  });

  describe('testIamPermissions', () => {
    it('invokes testIamPermissions without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.TestIamPermissionsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.TestIamPermissionsRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedHeaderRequestParams = `resource=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.iam.v1.TestIamPermissionsResponse(),
      );
      client.innerApiCalls.testIamPermissions =
        stubSimpleCall(expectedResponse);
      const [response] = await client.testIamPermissions(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.testIamPermissions as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.testIamPermissions as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes testIamPermissions without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.TestIamPermissionsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.TestIamPermissionsRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedHeaderRequestParams = `resource=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.iam.v1.TestIamPermissionsResponse(),
      );
      client.innerApiCalls.testIamPermissions =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.testIamPermissions(
          request,
          (
            err?: Error | null,
            result?: protos.google.iam.v1.ITestIamPermissionsResponse | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.testIamPermissions as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.testIamPermissions as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes testIamPermissions with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.TestIamPermissionsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.TestIamPermissionsRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedHeaderRequestParams = `resource=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.testIamPermissions = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.testIamPermissions(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.testIamPermissions as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.testIamPermissions as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes testIamPermissions with closed client', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.TestIamPermissionsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.TestIamPermissionsRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.testIamPermissions(request), expectedError);
    });
  });

  describe('getBackup', () => {
    it('invokes getBackup without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.GetBackupRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.GetBackupRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.Backup(),
      );
      client.innerApiCalls.getBackup = stubSimpleCall(expectedResponse);
      const [response] = await client.getBackup(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.getBackup as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getBackup as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getBackup without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.GetBackupRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.GetBackupRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.Backup(),
      );
      client.innerApiCalls.getBackup =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.getBackup(
          request,
          (
            err?: Error | null,
            result?: protos.google.spanner.admin.database.v1.IBackup | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.getBackup as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getBackup as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getBackup with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.GetBackupRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.GetBackupRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.getBackup = stubSimpleCall(undefined, expectedError);
      await assert.rejects(client.getBackup(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.getBackup as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getBackup as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getBackup with closed client', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.GetBackupRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.GetBackupRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.getBackup(request), expectedError);
    });
  });

  describe('updateBackup', () => {
    it('invokes updateBackup without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.UpdateBackupRequest(),
      );
      request.backup ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.UpdateBackupRequest',
        ['backup', 'name'],
      );
      request.backup.name = defaultValue1;
      const expectedHeaderRequestParams = `backup.name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.Backup(),
      );
      client.innerApiCalls.updateBackup = stubSimpleCall(expectedResponse);
      const [response] = await client.updateBackup(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.updateBackup as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateBackup as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateBackup without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.UpdateBackupRequest(),
      );
      request.backup ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.UpdateBackupRequest',
        ['backup', 'name'],
      );
      request.backup.name = defaultValue1;
      const expectedHeaderRequestParams = `backup.name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.Backup(),
      );
      client.innerApiCalls.updateBackup =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.updateBackup(
          request,
          (
            err?: Error | null,
            result?: protos.google.spanner.admin.database.v1.IBackup | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.updateBackup as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateBackup as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateBackup with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.UpdateBackupRequest(),
      );
      request.backup ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.UpdateBackupRequest',
        ['backup', 'name'],
      );
      request.backup.name = defaultValue1;
      const expectedHeaderRequestParams = `backup.name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.updateBackup = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.updateBackup(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.updateBackup as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateBackup as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateBackup with closed client', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.UpdateBackupRequest(),
      );
      request.backup ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.UpdateBackupRequest',
        ['backup', 'name'],
      );
      request.backup.name = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.updateBackup(request), expectedError);
    });
  });

  describe('deleteBackup', () => {
    it('invokes deleteBackup without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.DeleteBackupRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.DeleteBackupRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.innerApiCalls.deleteBackup = stubSimpleCall(expectedResponse);
      const [response] = await client.deleteBackup(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.deleteBackup as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.deleteBackup as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes deleteBackup without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.DeleteBackupRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.DeleteBackupRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.innerApiCalls.deleteBackup =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.deleteBackup(
          request,
          (
            err?: Error | null,
            result?: protos.google.protobuf.IEmpty | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.deleteBackup as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.deleteBackup as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes deleteBackup with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.DeleteBackupRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.DeleteBackupRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.deleteBackup = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.deleteBackup(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.deleteBackup as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.deleteBackup as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes deleteBackup with closed client', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.DeleteBackupRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.DeleteBackupRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.deleteBackup(request), expectedError);
    });
  });

  describe('addSplitPoints', () => {
    it('invokes addSplitPoints without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.AddSplitPointsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.AddSplitPointsRequest',
        ['database'],
      );
      request.database = defaultValue1;
      const expectedHeaderRequestParams = `database=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.AddSplitPointsResponse(),
      );
      client.innerApiCalls.addSplitPoints = stubSimpleCall(expectedResponse);
      const [response] = await client.addSplitPoints(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.addSplitPoints as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.addSplitPoints as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes addSplitPoints without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.AddSplitPointsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.AddSplitPointsRequest',
        ['database'],
      );
      request.database = defaultValue1;
      const expectedHeaderRequestParams = `database=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.AddSplitPointsResponse(),
      );
      client.innerApiCalls.addSplitPoints =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.addSplitPoints(
          request,
          (
            err?: Error | null,
            result?: protos.google.spanner.admin.database.v1.IAddSplitPointsResponse | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.addSplitPoints as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.addSplitPoints as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes addSplitPoints with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.AddSplitPointsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.AddSplitPointsRequest',
        ['database'],
      );
      request.database = defaultValue1;
      const expectedHeaderRequestParams = `database=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.addSplitPoints = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.addSplitPoints(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.addSplitPoints as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.addSplitPoints as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes addSplitPoints with closed client', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.AddSplitPointsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.AddSplitPointsRequest',
        ['database'],
      );
      request.database = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.addSplitPoints(request), expectedError);
    });
  });

  describe('createBackupSchedule', () => {
    it('invokes createBackupSchedule without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.CreateBackupScheduleRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.CreateBackupScheduleRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.BackupSchedule(),
      );
      client.innerApiCalls.createBackupSchedule =
        stubSimpleCall(expectedResponse);
      const [response] = await client.createBackupSchedule(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.createBackupSchedule as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createBackupSchedule as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes createBackupSchedule without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.CreateBackupScheduleRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.CreateBackupScheduleRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.BackupSchedule(),
      );
      client.innerApiCalls.createBackupSchedule =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.createBackupSchedule(
          request,
          (
            err?: Error | null,
            result?: protos.google.spanner.admin.database.v1.IBackupSchedule | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.createBackupSchedule as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createBackupSchedule as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes createBackupSchedule with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.CreateBackupScheduleRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.CreateBackupScheduleRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.createBackupSchedule = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.createBackupSchedule(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.createBackupSchedule as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createBackupSchedule as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes createBackupSchedule with closed client', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.CreateBackupScheduleRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.CreateBackupScheduleRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.createBackupSchedule(request), expectedError);
    });
  });

  describe('getBackupSchedule', () => {
    it('invokes getBackupSchedule without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.GetBackupScheduleRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.GetBackupScheduleRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.BackupSchedule(),
      );
      client.innerApiCalls.getBackupSchedule = stubSimpleCall(expectedResponse);
      const [response] = await client.getBackupSchedule(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.getBackupSchedule as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getBackupSchedule as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getBackupSchedule without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.GetBackupScheduleRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.GetBackupScheduleRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.BackupSchedule(),
      );
      client.innerApiCalls.getBackupSchedule =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.getBackupSchedule(
          request,
          (
            err?: Error | null,
            result?: protos.google.spanner.admin.database.v1.IBackupSchedule | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.getBackupSchedule as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getBackupSchedule as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getBackupSchedule with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.GetBackupScheduleRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.GetBackupScheduleRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.getBackupSchedule = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.getBackupSchedule(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.getBackupSchedule as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getBackupSchedule as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getBackupSchedule with closed client', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.GetBackupScheduleRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.GetBackupScheduleRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.getBackupSchedule(request), expectedError);
    });
  });

  describe('updateBackupSchedule', () => {
    it('invokes updateBackupSchedule without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.UpdateBackupScheduleRequest(),
      );
      request.backupSchedule ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.UpdateBackupScheduleRequest',
        ['backupSchedule', 'name'],
      );
      request.backupSchedule.name = defaultValue1;
      const expectedHeaderRequestParams = `backup_schedule.name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.BackupSchedule(),
      );
      client.innerApiCalls.updateBackupSchedule =
        stubSimpleCall(expectedResponse);
      const [response] = await client.updateBackupSchedule(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.updateBackupSchedule as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateBackupSchedule as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateBackupSchedule without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.UpdateBackupScheduleRequest(),
      );
      request.backupSchedule ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.UpdateBackupScheduleRequest',
        ['backupSchedule', 'name'],
      );
      request.backupSchedule.name = defaultValue1;
      const expectedHeaderRequestParams = `backup_schedule.name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.BackupSchedule(),
      );
      client.innerApiCalls.updateBackupSchedule =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.updateBackupSchedule(
          request,
          (
            err?: Error | null,
            result?: protos.google.spanner.admin.database.v1.IBackupSchedule | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.updateBackupSchedule as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateBackupSchedule as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateBackupSchedule with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.UpdateBackupScheduleRequest(),
      );
      request.backupSchedule ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.UpdateBackupScheduleRequest',
        ['backupSchedule', 'name'],
      );
      request.backupSchedule.name = defaultValue1;
      const expectedHeaderRequestParams = `backup_schedule.name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.updateBackupSchedule = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.updateBackupSchedule(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.updateBackupSchedule as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateBackupSchedule as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateBackupSchedule with closed client', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.UpdateBackupScheduleRequest(),
      );
      request.backupSchedule ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.UpdateBackupScheduleRequest',
        ['backupSchedule', 'name'],
      );
      request.backupSchedule.name = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.updateBackupSchedule(request), expectedError);
    });
  });

  describe('deleteBackupSchedule', () => {
    it('invokes deleteBackupSchedule without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.DeleteBackupScheduleRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.DeleteBackupScheduleRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.innerApiCalls.deleteBackupSchedule =
        stubSimpleCall(expectedResponse);
      const [response] = await client.deleteBackupSchedule(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.deleteBackupSchedule as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.deleteBackupSchedule as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes deleteBackupSchedule without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.DeleteBackupScheduleRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.DeleteBackupScheduleRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.innerApiCalls.deleteBackupSchedule =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.deleteBackupSchedule(
          request,
          (
            err?: Error | null,
            result?: protos.google.protobuf.IEmpty | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.deleteBackupSchedule as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.deleteBackupSchedule as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes deleteBackupSchedule with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.DeleteBackupScheduleRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.DeleteBackupScheduleRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.deleteBackupSchedule = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.deleteBackupSchedule(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.deleteBackupSchedule as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.deleteBackupSchedule as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes deleteBackupSchedule with closed client', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.DeleteBackupScheduleRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.DeleteBackupScheduleRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.deleteBackupSchedule(request), expectedError);
    });
  });

  describe('internalUpdateGraphOperation', () => {
    it('invokes internalUpdateGraphOperation without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.InternalUpdateGraphOperationRequest(),
      );
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.InternalUpdateGraphOperationResponse(),
      );
      client.innerApiCalls.internalUpdateGraphOperation =
        stubSimpleCall(expectedResponse);
      const [response] = await client.internalUpdateGraphOperation(request);
      assert.deepStrictEqual(response, expectedResponse);
    });

    it('invokes internalUpdateGraphOperation without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.InternalUpdateGraphOperationRequest(),
      );
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.InternalUpdateGraphOperationResponse(),
      );
      client.innerApiCalls.internalUpdateGraphOperation =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.internalUpdateGraphOperation(
          request,
          (
            err?: Error | null,
            result?: protos.google.spanner.admin.database.v1.IInternalUpdateGraphOperationResponse | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
    });

    it('invokes internalUpdateGraphOperation with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.InternalUpdateGraphOperationRequest(),
      );
      const expectedError = new Error('expected');
      client.innerApiCalls.internalUpdateGraphOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(
        client.internalUpdateGraphOperation(request),
        expectedError,
      );
    });

    it('invokes internalUpdateGraphOperation with closed client', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.InternalUpdateGraphOperationRequest(),
      );
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(
        client.internalUpdateGraphOperation(request),
        expectedError,
      );
    });
  });

  describe('createDatabase', () => {
    it('invokes createDatabase without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.CreateDatabaseRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.CreateDatabaseRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.createDatabase =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.createDatabase(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.createDatabase as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createDatabase as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes createDatabase without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.CreateDatabaseRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.CreateDatabaseRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.createDatabase =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.createDatabase(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.spanner.admin.database.v1.IDatabase,
              protos.google.spanner.admin.database.v1.ICreateDatabaseMetadata
            > | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.spanner.admin.database.v1.IDatabase,
        protos.google.spanner.admin.database.v1.ICreateDatabaseMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.createDatabase as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createDatabase as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes createDatabase with call error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.CreateDatabaseRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.CreateDatabaseRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.createDatabase = stubLongRunningCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.createDatabase(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.createDatabase as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createDatabase as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes createDatabase with LRO error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.CreateDatabaseRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.CreateDatabaseRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.createDatabase = stubLongRunningCall(
        undefined,
        undefined,
        expectedError,
      );
      const [operation] = await client.createDatabase(request);
      await assert.rejects(operation.promise(), expectedError);
      const actualRequest = (
        client.innerApiCalls.createDatabase as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createDatabase as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes checkCreateDatabaseProgress without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation(),
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkCreateDatabaseProgress(
        expectedResponse.name,
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkCreateDatabaseProgress with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(
        client.checkCreateDatabaseProgress(''),
        expectedError,
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('updateDatabase', () => {
    it('invokes updateDatabase without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.UpdateDatabaseRequest(),
      );
      request.database ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.UpdateDatabaseRequest',
        ['database', 'name'],
      );
      request.database.name = defaultValue1;
      const expectedHeaderRequestParams = `database.name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.updateDatabase =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.updateDatabase(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.updateDatabase as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateDatabase as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateDatabase without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.UpdateDatabaseRequest(),
      );
      request.database ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.UpdateDatabaseRequest',
        ['database', 'name'],
      );
      request.database.name = defaultValue1;
      const expectedHeaderRequestParams = `database.name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.updateDatabase =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.updateDatabase(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.spanner.admin.database.v1.IDatabase,
              protos.google.spanner.admin.database.v1.IUpdateDatabaseMetadata
            > | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.spanner.admin.database.v1.IDatabase,
        protos.google.spanner.admin.database.v1.IUpdateDatabaseMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.updateDatabase as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateDatabase as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateDatabase with call error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.UpdateDatabaseRequest(),
      );
      request.database ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.UpdateDatabaseRequest',
        ['database', 'name'],
      );
      request.database.name = defaultValue1;
      const expectedHeaderRequestParams = `database.name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.updateDatabase = stubLongRunningCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.updateDatabase(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.updateDatabase as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateDatabase as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateDatabase with LRO error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.UpdateDatabaseRequest(),
      );
      request.database ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.UpdateDatabaseRequest',
        ['database', 'name'],
      );
      request.database.name = defaultValue1;
      const expectedHeaderRequestParams = `database.name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.updateDatabase = stubLongRunningCall(
        undefined,
        undefined,
        expectedError,
      );
      const [operation] = await client.updateDatabase(request);
      await assert.rejects(operation.promise(), expectedError);
      const actualRequest = (
        client.innerApiCalls.updateDatabase as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateDatabase as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes checkUpdateDatabaseProgress without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation(),
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkUpdateDatabaseProgress(
        expectedResponse.name,
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkUpdateDatabaseProgress with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(
        client.checkUpdateDatabaseProgress(''),
        expectedError,
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('updateDatabaseDdl', () => {
    it('invokes updateDatabaseDdl without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest',
        ['database'],
      );
      request.database = defaultValue1;
      const expectedHeaderRequestParams = `database=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.updateDatabaseDdl =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.updateDatabaseDdl(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.updateDatabaseDdl as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateDatabaseDdl as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateDatabaseDdl without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest',
        ['database'],
      );
      request.database = defaultValue1;
      const expectedHeaderRequestParams = `database=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.updateDatabaseDdl =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.updateDatabaseDdl(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.protobuf.IEmpty,
              protos.google.spanner.admin.database.v1.IUpdateDatabaseDdlMetadata
            > | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.protobuf.IEmpty,
        protos.google.spanner.admin.database.v1.IUpdateDatabaseDdlMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.updateDatabaseDdl as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateDatabaseDdl as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateDatabaseDdl with call error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest',
        ['database'],
      );
      request.database = defaultValue1;
      const expectedHeaderRequestParams = `database=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.updateDatabaseDdl = stubLongRunningCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.updateDatabaseDdl(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.updateDatabaseDdl as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateDatabaseDdl as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateDatabaseDdl with LRO error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest',
        ['database'],
      );
      request.database = defaultValue1;
      const expectedHeaderRequestParams = `database=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.updateDatabaseDdl = stubLongRunningCall(
        undefined,
        undefined,
        expectedError,
      );
      const [operation] = await client.updateDatabaseDdl(request);
      await assert.rejects(operation.promise(), expectedError);
      const actualRequest = (
        client.innerApiCalls.updateDatabaseDdl as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateDatabaseDdl as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes checkUpdateDatabaseDdlProgress without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation(),
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkUpdateDatabaseDdlProgress(
        expectedResponse.name,
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkUpdateDatabaseDdlProgress with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(
        client.checkUpdateDatabaseDdlProgress(''),
        expectedError,
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('createBackup', () => {
    it('invokes createBackup without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.CreateBackupRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.CreateBackupRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.createBackup = stubLongRunningCall(expectedResponse);
      const [operation] = await client.createBackup(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.createBackup as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createBackup as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes createBackup without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.CreateBackupRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.CreateBackupRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.createBackup =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.createBackup(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.spanner.admin.database.v1.IBackup,
              protos.google.spanner.admin.database.v1.ICreateBackupMetadata
            > | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.spanner.admin.database.v1.IBackup,
        protos.google.spanner.admin.database.v1.ICreateBackupMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.createBackup as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createBackup as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes createBackup with call error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.CreateBackupRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.CreateBackupRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.createBackup = stubLongRunningCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.createBackup(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.createBackup as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createBackup as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes createBackup with LRO error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.CreateBackupRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.CreateBackupRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.createBackup = stubLongRunningCall(
        undefined,
        undefined,
        expectedError,
      );
      const [operation] = await client.createBackup(request);
      await assert.rejects(operation.promise(), expectedError);
      const actualRequest = (
        client.innerApiCalls.createBackup as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createBackup as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes checkCreateBackupProgress without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation(),
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkCreateBackupProgress(
        expectedResponse.name,
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkCreateBackupProgress with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.checkCreateBackupProgress(''), expectedError);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('copyBackup', () => {
    it('invokes copyBackup without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.CopyBackupRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.CopyBackupRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.copyBackup = stubLongRunningCall(expectedResponse);
      const [operation] = await client.copyBackup(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.copyBackup as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.copyBackup as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes copyBackup without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.CopyBackupRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.CopyBackupRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.copyBackup =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.copyBackup(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.spanner.admin.database.v1.IBackup,
              protos.google.spanner.admin.database.v1.ICopyBackupMetadata
            > | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.spanner.admin.database.v1.IBackup,
        protos.google.spanner.admin.database.v1.ICopyBackupMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.copyBackup as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.copyBackup as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes copyBackup with call error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.CopyBackupRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.CopyBackupRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.copyBackup = stubLongRunningCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.copyBackup(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.copyBackup as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.copyBackup as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes copyBackup with LRO error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.CopyBackupRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.CopyBackupRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.copyBackup = stubLongRunningCall(
        undefined,
        undefined,
        expectedError,
      );
      const [operation] = await client.copyBackup(request);
      await assert.rejects(operation.promise(), expectedError);
      const actualRequest = (
        client.innerApiCalls.copyBackup as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.copyBackup as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes checkCopyBackupProgress without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation(),
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkCopyBackupProgress(
        expectedResponse.name,
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkCopyBackupProgress with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.checkCopyBackupProgress(''), expectedError);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('restoreDatabase', () => {
    it('invokes restoreDatabase without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.RestoreDatabaseRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.RestoreDatabaseRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.restoreDatabase =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.restoreDatabase(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.restoreDatabase as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.restoreDatabase as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes restoreDatabase without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.RestoreDatabaseRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.RestoreDatabaseRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.restoreDatabase =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.restoreDatabase(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.spanner.admin.database.v1.IDatabase,
              protos.google.spanner.admin.database.v1.IRestoreDatabaseMetadata
            > | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.spanner.admin.database.v1.IDatabase,
        protos.google.spanner.admin.database.v1.IRestoreDatabaseMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.restoreDatabase as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.restoreDatabase as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes restoreDatabase with call error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.RestoreDatabaseRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.RestoreDatabaseRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.restoreDatabase = stubLongRunningCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.restoreDatabase(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.restoreDatabase as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.restoreDatabase as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes restoreDatabase with LRO error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.RestoreDatabaseRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.RestoreDatabaseRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.restoreDatabase = stubLongRunningCall(
        undefined,
        undefined,
        expectedError,
      );
      const [operation] = await client.restoreDatabase(request);
      await assert.rejects(operation.promise(), expectedError);
      const actualRequest = (
        client.innerApiCalls.restoreDatabase as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.restoreDatabase as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes checkRestoreDatabaseProgress without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation(),
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkRestoreDatabaseProgress(
        expectedResponse.name,
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkRestoreDatabaseProgress with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(
        client.checkRestoreDatabaseProgress(''),
        expectedError,
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('listDatabases', () => {
    it('invokes listDatabases without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabasesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabasesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Database(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Database(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Database(),
        ),
      ];
      client.innerApiCalls.listDatabases = stubSimpleCall(expectedResponse);
      const [response] = await client.listDatabases(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listDatabases as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listDatabases as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listDatabases without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabasesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabasesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Database(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Database(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Database(),
        ),
      ];
      client.innerApiCalls.listDatabases =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.listDatabases(
          request,
          (
            err?: Error | null,
            result?: protos.google.spanner.admin.database.v1.IDatabase[] | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listDatabases as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listDatabases as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listDatabases with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabasesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabasesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.listDatabases = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.listDatabases(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.listDatabases as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listDatabases as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listDatabasesStream without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabasesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabasesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Database(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Database(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Database(),
        ),
      ];
      client.descriptors.page.listDatabases.createStream =
        stubPageStreamingCall(expectedResponse);
      const stream = client.listDatabasesStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.spanner.admin.database.v1.Database[] =
          [];
        stream.on(
          'data',
          (response: protos.google.spanner.admin.database.v1.Database) => {
            responses.push(response);
          },
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      const responses = await promise;
      assert.deepStrictEqual(responses, expectedResponse);
      assert(
        (client.descriptors.page.listDatabases.createStream as SinonStub)
          .getCall(0)
          .calledWith(client.innerApiCalls.listDatabases, request),
      );
      assert(
        (client.descriptors.page.listDatabases.createStream as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('invokes listDatabasesStream with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabasesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabasesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listDatabases.createStream =
        stubPageStreamingCall(undefined, expectedError);
      const stream = client.listDatabasesStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.spanner.admin.database.v1.Database[] =
          [];
        stream.on(
          'data',
          (response: protos.google.spanner.admin.database.v1.Database) => {
            responses.push(response);
          },
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      await assert.rejects(promise, expectedError);
      assert(
        (client.descriptors.page.listDatabases.createStream as SinonStub)
          .getCall(0)
          .calledWith(client.innerApiCalls.listDatabases, request),
      );
      assert(
        (client.descriptors.page.listDatabases.createStream as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('uses async iteration with listDatabases without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabasesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabasesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Database(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Database(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Database(),
        ),
      ];
      client.descriptors.page.listDatabases.asyncIterate =
        stubAsyncIterationCall(expectedResponse);
      const responses: protos.google.spanner.admin.database.v1.IDatabase[] = [];
      const iterable = client.listDatabasesAsync(request);
      for await (const resource of iterable) {
        responses.push(resource!);
      }
      assert.deepStrictEqual(responses, expectedResponse);
      assert.deepStrictEqual(
        (
          client.descriptors.page.listDatabases.asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (client.descriptors.page.listDatabases.asyncIterate as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('uses async iteration with listDatabases with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabasesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabasesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listDatabases.asyncIterate =
        stubAsyncIterationCall(undefined, expectedError);
      const iterable = client.listDatabasesAsync(request);
      await assert.rejects(async () => {
        const responses: protos.google.spanner.admin.database.v1.IDatabase[] =
          [];
        for await (const resource of iterable) {
          responses.push(resource!);
        }
      });
      assert.deepStrictEqual(
        (
          client.descriptors.page.listDatabases.asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (client.descriptors.page.listDatabases.asyncIterate as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });
  });

  describe('listBackups', () => {
    it('invokes listBackups without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Backup(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Backup(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Backup(),
        ),
      ];
      client.innerApiCalls.listBackups = stubSimpleCall(expectedResponse);
      const [response] = await client.listBackups(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listBackups as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listBackups as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listBackups without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Backup(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Backup(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Backup(),
        ),
      ];
      client.innerApiCalls.listBackups =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.listBackups(
          request,
          (
            err?: Error | null,
            result?: protos.google.spanner.admin.database.v1.IBackup[] | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listBackups as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listBackups as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listBackups with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.listBackups = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.listBackups(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.listBackups as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listBackups as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listBackupsStream without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Backup(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Backup(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Backup(),
        ),
      ];
      client.descriptors.page.listBackups.createStream =
        stubPageStreamingCall(expectedResponse);
      const stream = client.listBackupsStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.spanner.admin.database.v1.Backup[] = [];
        stream.on(
          'data',
          (response: protos.google.spanner.admin.database.v1.Backup) => {
            responses.push(response);
          },
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      const responses = await promise;
      assert.deepStrictEqual(responses, expectedResponse);
      assert(
        (client.descriptors.page.listBackups.createStream as SinonStub)
          .getCall(0)
          .calledWith(client.innerApiCalls.listBackups, request),
      );
      assert(
        (client.descriptors.page.listBackups.createStream as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('invokes listBackupsStream with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listBackups.createStream = stubPageStreamingCall(
        undefined,
        expectedError,
      );
      const stream = client.listBackupsStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.spanner.admin.database.v1.Backup[] = [];
        stream.on(
          'data',
          (response: protos.google.spanner.admin.database.v1.Backup) => {
            responses.push(response);
          },
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      await assert.rejects(promise, expectedError);
      assert(
        (client.descriptors.page.listBackups.createStream as SinonStub)
          .getCall(0)
          .calledWith(client.innerApiCalls.listBackups, request),
      );
      assert(
        (client.descriptors.page.listBackups.createStream as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('uses async iteration with listBackups without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Backup(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Backup(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.Backup(),
        ),
      ];
      client.descriptors.page.listBackups.asyncIterate =
        stubAsyncIterationCall(expectedResponse);
      const responses: protos.google.spanner.admin.database.v1.IBackup[] = [];
      const iterable = client.listBackupsAsync(request);
      for await (const resource of iterable) {
        responses.push(resource!);
      }
      assert.deepStrictEqual(responses, expectedResponse);
      assert.deepStrictEqual(
        (client.descriptors.page.listBackups.asyncIterate as SinonStub).getCall(
          0,
        ).args[1],
        request,
      );
      assert(
        (client.descriptors.page.listBackups.asyncIterate as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('uses async iteration with listBackups with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listBackups.asyncIterate = stubAsyncIterationCall(
        undefined,
        expectedError,
      );
      const iterable = client.listBackupsAsync(request);
      await assert.rejects(async () => {
        const responses: protos.google.spanner.admin.database.v1.IBackup[] = [];
        for await (const resource of iterable) {
          responses.push(resource!);
        }
      });
      assert.deepStrictEqual(
        (client.descriptors.page.listBackups.asyncIterate as SinonStub).getCall(
          0,
        ).args[1],
        request,
      );
      assert(
        (client.descriptors.page.listBackups.asyncIterate as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });
  });

  describe('listDatabaseOperations', () => {
    it('invokes listDatabaseOperations without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabaseOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabaseOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
      ];
      client.innerApiCalls.listDatabaseOperations =
        stubSimpleCall(expectedResponse);
      const [response] = await client.listDatabaseOperations(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listDatabaseOperations as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listDatabaseOperations as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listDatabaseOperations without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabaseOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabaseOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
      ];
      client.innerApiCalls.listDatabaseOperations =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.listDatabaseOperations(
          request,
          (
            err?: Error | null,
            result?: protos.google.longrunning.IOperation[] | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listDatabaseOperations as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listDatabaseOperations as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listDatabaseOperations with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabaseOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabaseOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.listDatabaseOperations = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(
        client.listDatabaseOperations(request),
        expectedError,
      );
      const actualRequest = (
        client.innerApiCalls.listDatabaseOperations as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listDatabaseOperations as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listDatabaseOperationsStream without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabaseOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabaseOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
      ];
      client.descriptors.page.listDatabaseOperations.createStream =
        stubPageStreamingCall(expectedResponse);
      const stream = client.listDatabaseOperationsStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.longrunning.Operation[] = [];
        stream.on('data', (response: protos.google.longrunning.Operation) => {
          responses.push(response);
        });
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      const responses = await promise;
      assert.deepStrictEqual(responses, expectedResponse);
      assert(
        (
          client.descriptors.page.listDatabaseOperations
            .createStream as SinonStub
        )
          .getCall(0)
          .calledWith(client.innerApiCalls.listDatabaseOperations, request),
      );
      assert(
        (
          client.descriptors.page.listDatabaseOperations
            .createStream as SinonStub
        )
          .getCall(0)
          .args[2].otherArgs.headers['x-goog-request-params'].includes(
            expectedHeaderRequestParams,
          ),
      );
    });

    it('invokes listDatabaseOperationsStream with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabaseOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabaseOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listDatabaseOperations.createStream =
        stubPageStreamingCall(undefined, expectedError);
      const stream = client.listDatabaseOperationsStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.longrunning.Operation[] = [];
        stream.on('data', (response: protos.google.longrunning.Operation) => {
          responses.push(response);
        });
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      await assert.rejects(promise, expectedError);
      assert(
        (
          client.descriptors.page.listDatabaseOperations
            .createStream as SinonStub
        )
          .getCall(0)
          .calledWith(client.innerApiCalls.listDatabaseOperations, request),
      );
      assert(
        (
          client.descriptors.page.listDatabaseOperations
            .createStream as SinonStub
        )
          .getCall(0)
          .args[2].otherArgs.headers['x-goog-request-params'].includes(
            expectedHeaderRequestParams,
          ),
      );
    });

    it('uses async iteration with listDatabaseOperations without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabaseOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabaseOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
      ];
      client.descriptors.page.listDatabaseOperations.asyncIterate =
        stubAsyncIterationCall(expectedResponse);
      const responses: protos.google.longrunning.IOperation[] = [];
      const iterable = client.listDatabaseOperationsAsync(request);
      for await (const resource of iterable) {
        responses.push(resource!);
      }
      assert.deepStrictEqual(responses, expectedResponse);
      assert.deepStrictEqual(
        (
          client.descriptors.page.listDatabaseOperations
            .asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (
          client.descriptors.page.listDatabaseOperations
            .asyncIterate as SinonStub
        )
          .getCall(0)
          .args[2].otherArgs.headers['x-goog-request-params'].includes(
            expectedHeaderRequestParams,
          ),
      );
    });

    it('uses async iteration with listDatabaseOperations with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabaseOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabaseOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listDatabaseOperations.asyncIterate =
        stubAsyncIterationCall(undefined, expectedError);
      const iterable = client.listDatabaseOperationsAsync(request);
      await assert.rejects(async () => {
        const responses: protos.google.longrunning.IOperation[] = [];
        for await (const resource of iterable) {
          responses.push(resource!);
        }
      });
      assert.deepStrictEqual(
        (
          client.descriptors.page.listDatabaseOperations
            .asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (
          client.descriptors.page.listDatabaseOperations
            .asyncIterate as SinonStub
        )
          .getCall(0)
          .args[2].otherArgs.headers['x-goog-request-params'].includes(
            expectedHeaderRequestParams,
          ),
      );
    });
  });

  describe('listBackupOperations', () => {
    it('invokes listBackupOperations without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
      ];
      client.innerApiCalls.listBackupOperations =
        stubSimpleCall(expectedResponse);
      const [response] = await client.listBackupOperations(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listBackupOperations as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listBackupOperations as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listBackupOperations without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
      ];
      client.innerApiCalls.listBackupOperations =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.listBackupOperations(
          request,
          (
            err?: Error | null,
            result?: protos.google.longrunning.IOperation[] | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listBackupOperations as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listBackupOperations as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listBackupOperations with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.listBackupOperations = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.listBackupOperations(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.listBackupOperations as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listBackupOperations as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listBackupOperationsStream without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
      ];
      client.descriptors.page.listBackupOperations.createStream =
        stubPageStreamingCall(expectedResponse);
      const stream = client.listBackupOperationsStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.longrunning.Operation[] = [];
        stream.on('data', (response: protos.google.longrunning.Operation) => {
          responses.push(response);
        });
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      const responses = await promise;
      assert.deepStrictEqual(responses, expectedResponse);
      assert(
        (client.descriptors.page.listBackupOperations.createStream as SinonStub)
          .getCall(0)
          .calledWith(client.innerApiCalls.listBackupOperations, request),
      );
      assert(
        (client.descriptors.page.listBackupOperations.createStream as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('invokes listBackupOperationsStream with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listBackupOperations.createStream =
        stubPageStreamingCall(undefined, expectedError);
      const stream = client.listBackupOperationsStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.longrunning.Operation[] = [];
        stream.on('data', (response: protos.google.longrunning.Operation) => {
          responses.push(response);
        });
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      await assert.rejects(promise, expectedError);
      assert(
        (client.descriptors.page.listBackupOperations.createStream as SinonStub)
          .getCall(0)
          .calledWith(client.innerApiCalls.listBackupOperations, request),
      );
      assert(
        (client.descriptors.page.listBackupOperations.createStream as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('uses async iteration with listBackupOperations without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
      ];
      client.descriptors.page.listBackupOperations.asyncIterate =
        stubAsyncIterationCall(expectedResponse);
      const responses: protos.google.longrunning.IOperation[] = [];
      const iterable = client.listBackupOperationsAsync(request);
      for await (const resource of iterable) {
        responses.push(resource!);
      }
      assert.deepStrictEqual(responses, expectedResponse);
      assert.deepStrictEqual(
        (
          client.descriptors.page.listBackupOperations.asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (client.descriptors.page.listBackupOperations.asyncIterate as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('uses async iteration with listBackupOperations with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listBackupOperations.asyncIterate =
        stubAsyncIterationCall(undefined, expectedError);
      const iterable = client.listBackupOperationsAsync(request);
      await assert.rejects(async () => {
        const responses: protos.google.longrunning.IOperation[] = [];
        for await (const resource of iterable) {
          responses.push(resource!);
        }
      });
      assert.deepStrictEqual(
        (
          client.descriptors.page.listBackupOperations.asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (client.descriptors.page.listBackupOperations.asyncIterate as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });
  });

  describe('listDatabaseRoles', () => {
    it('invokes listDatabaseRoles without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabaseRolesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabaseRolesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.DatabaseRole(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.DatabaseRole(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.DatabaseRole(),
        ),
      ];
      client.innerApiCalls.listDatabaseRoles = stubSimpleCall(expectedResponse);
      const [response] = await client.listDatabaseRoles(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listDatabaseRoles as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listDatabaseRoles as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listDatabaseRoles without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabaseRolesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabaseRolesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.DatabaseRole(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.DatabaseRole(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.DatabaseRole(),
        ),
      ];
      client.innerApiCalls.listDatabaseRoles =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.listDatabaseRoles(
          request,
          (
            err?: Error | null,
            result?:
              | protos.google.spanner.admin.database.v1.IDatabaseRole[]
              | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listDatabaseRoles as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listDatabaseRoles as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listDatabaseRoles with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabaseRolesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabaseRolesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.listDatabaseRoles = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.listDatabaseRoles(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.listDatabaseRoles as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listDatabaseRoles as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listDatabaseRolesStream without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabaseRolesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabaseRolesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.DatabaseRole(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.DatabaseRole(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.DatabaseRole(),
        ),
      ];
      client.descriptors.page.listDatabaseRoles.createStream =
        stubPageStreamingCall(expectedResponse);
      const stream = client.listDatabaseRolesStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.spanner.admin.database.v1.DatabaseRole[] =
          [];
        stream.on(
          'data',
          (response: protos.google.spanner.admin.database.v1.DatabaseRole) => {
            responses.push(response);
          },
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      const responses = await promise;
      assert.deepStrictEqual(responses, expectedResponse);
      assert(
        (client.descriptors.page.listDatabaseRoles.createStream as SinonStub)
          .getCall(0)
          .calledWith(client.innerApiCalls.listDatabaseRoles, request),
      );
      assert(
        (client.descriptors.page.listDatabaseRoles.createStream as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('invokes listDatabaseRolesStream with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabaseRolesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabaseRolesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listDatabaseRoles.createStream =
        stubPageStreamingCall(undefined, expectedError);
      const stream = client.listDatabaseRolesStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.spanner.admin.database.v1.DatabaseRole[] =
          [];
        stream.on(
          'data',
          (response: protos.google.spanner.admin.database.v1.DatabaseRole) => {
            responses.push(response);
          },
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      await assert.rejects(promise, expectedError);
      assert(
        (client.descriptors.page.listDatabaseRoles.createStream as SinonStub)
          .getCall(0)
          .calledWith(client.innerApiCalls.listDatabaseRoles, request),
      );
      assert(
        (client.descriptors.page.listDatabaseRoles.createStream as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('uses async iteration with listDatabaseRoles without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabaseRolesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabaseRolesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.DatabaseRole(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.DatabaseRole(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.DatabaseRole(),
        ),
      ];
      client.descriptors.page.listDatabaseRoles.asyncIterate =
        stubAsyncIterationCall(expectedResponse);
      const responses: protos.google.spanner.admin.database.v1.IDatabaseRole[] =
        [];
      const iterable = client.listDatabaseRolesAsync(request);
      for await (const resource of iterable) {
        responses.push(resource!);
      }
      assert.deepStrictEqual(responses, expectedResponse);
      assert.deepStrictEqual(
        (
          client.descriptors.page.listDatabaseRoles.asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (client.descriptors.page.listDatabaseRoles.asyncIterate as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('uses async iteration with listDatabaseRoles with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListDatabaseRolesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListDatabaseRolesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listDatabaseRoles.asyncIterate =
        stubAsyncIterationCall(undefined, expectedError);
      const iterable = client.listDatabaseRolesAsync(request);
      await assert.rejects(async () => {
        const responses: protos.google.spanner.admin.database.v1.IDatabaseRole[] =
          [];
        for await (const resource of iterable) {
          responses.push(resource!);
        }
      });
      assert.deepStrictEqual(
        (
          client.descriptors.page.listDatabaseRoles.asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (client.descriptors.page.listDatabaseRoles.asyncIterate as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });
  });

  describe('listBackupSchedules', () => {
    it('invokes listBackupSchedules without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupSchedulesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupSchedulesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.BackupSchedule(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.BackupSchedule(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.BackupSchedule(),
        ),
      ];
      client.innerApiCalls.listBackupSchedules =
        stubSimpleCall(expectedResponse);
      const [response] = await client.listBackupSchedules(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listBackupSchedules as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listBackupSchedules as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listBackupSchedules without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupSchedulesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupSchedulesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.BackupSchedule(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.BackupSchedule(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.BackupSchedule(),
        ),
      ];
      client.innerApiCalls.listBackupSchedules =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.listBackupSchedules(
          request,
          (
            err?: Error | null,
            result?:
              | protos.google.spanner.admin.database.v1.IBackupSchedule[]
              | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listBackupSchedules as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listBackupSchedules as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listBackupSchedules with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupSchedulesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupSchedulesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.listBackupSchedules = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.listBackupSchedules(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.listBackupSchedules as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listBackupSchedules as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listBackupSchedulesStream without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupSchedulesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupSchedulesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.BackupSchedule(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.BackupSchedule(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.BackupSchedule(),
        ),
      ];
      client.descriptors.page.listBackupSchedules.createStream =
        stubPageStreamingCall(expectedResponse);
      const stream = client.listBackupSchedulesStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.spanner.admin.database.v1.BackupSchedule[] =
          [];
        stream.on(
          'data',
          (
            response: protos.google.spanner.admin.database.v1.BackupSchedule,
          ) => {
            responses.push(response);
          },
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      const responses = await promise;
      assert.deepStrictEqual(responses, expectedResponse);
      assert(
        (client.descriptors.page.listBackupSchedules.createStream as SinonStub)
          .getCall(0)
          .calledWith(client.innerApiCalls.listBackupSchedules, request),
      );
      assert(
        (client.descriptors.page.listBackupSchedules.createStream as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('invokes listBackupSchedulesStream with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupSchedulesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupSchedulesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listBackupSchedules.createStream =
        stubPageStreamingCall(undefined, expectedError);
      const stream = client.listBackupSchedulesStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.spanner.admin.database.v1.BackupSchedule[] =
          [];
        stream.on(
          'data',
          (
            response: protos.google.spanner.admin.database.v1.BackupSchedule,
          ) => {
            responses.push(response);
          },
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      await assert.rejects(promise, expectedError);
      assert(
        (client.descriptors.page.listBackupSchedules.createStream as SinonStub)
          .getCall(0)
          .calledWith(client.innerApiCalls.listBackupSchedules, request),
      );
      assert(
        (client.descriptors.page.listBackupSchedules.createStream as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('uses async iteration with listBackupSchedules without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupSchedulesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupSchedulesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.BackupSchedule(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.BackupSchedule(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.database.v1.BackupSchedule(),
        ),
      ];
      client.descriptors.page.listBackupSchedules.asyncIterate =
        stubAsyncIterationCall(expectedResponse);
      const responses: protos.google.spanner.admin.database.v1.IBackupSchedule[] =
        [];
      const iterable = client.listBackupSchedulesAsync(request);
      for await (const resource of iterable) {
        responses.push(resource!);
      }
      assert.deepStrictEqual(responses, expectedResponse);
      assert.deepStrictEqual(
        (
          client.descriptors.page.listBackupSchedules.asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (client.descriptors.page.listBackupSchedules.asyncIterate as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('uses async iteration with listBackupSchedules with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.database.v1.ListBackupSchedulesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.database.v1.ListBackupSchedulesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listBackupSchedules.asyncIterate =
        stubAsyncIterationCall(undefined, expectedError);
      const iterable = client.listBackupSchedulesAsync(request);
      await assert.rejects(async () => {
        const responses: protos.google.spanner.admin.database.v1.IBackupSchedule[] =
          [];
        for await (const resource of iterable) {
          responses.push(resource!);
        }
      });
      assert.deepStrictEqual(
        (
          client.descriptors.page.listBackupSchedules.asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (client.descriptors.page.listBackupSchedules.asyncIterate as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });
  });
  describe('getOperation', () => {
    it('invokes getOperation without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.GetOperationRequest(),
      );
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation(),
      );
      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const response = await client.getOperation(request);
      assert.deepStrictEqual(response, [expectedResponse]);
      assert(
        (client.operationsClient.getOperation as SinonStub)
          .getCall(0)
          .calledWith(request),
      );
    });
    it('invokes getOperation without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.GetOperationRequest(),
      );
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation(),
      );
      client.operationsClient.getOperation = sinon
        .stub()
        .callsArgWith(2, null, expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.operationsClient
          .getOperation(
            request,
            undefined,
            (
              err?: Error | null,
              result?: operationsProtos.google.longrunning.Operation | null,
            ) => {
              if (err) {
                reject(err);
              } else {
                resolve(result);
              }
            },
          )
          .catch(err => {
            throw err;
          });
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
    it('invokes getOperation with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.GetOperationRequest(),
      );
      const expectedError = new Error('expected');
      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(async () => {
        await client.getOperation(request);
      }, expectedError);
      assert(
        (client.operationsClient.getOperation as SinonStub)
          .getCall(0)
          .calledWith(request),
      );
    });
  });
  describe('cancelOperation', () => {
    it('invokes cancelOperation without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.CancelOperationRequest(),
      );
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.operationsClient.cancelOperation =
        stubSimpleCall(expectedResponse);
      const response = await client.cancelOperation(request);
      assert.deepStrictEqual(response, [expectedResponse]);
      assert(
        (client.operationsClient.cancelOperation as SinonStub)
          .getCall(0)
          .calledWith(request),
      );
    });
    it('invokes cancelOperation without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.CancelOperationRequest(),
      );
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.operationsClient.cancelOperation = sinon
        .stub()
        .callsArgWith(2, null, expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.operationsClient
          .cancelOperation(
            request,
            undefined,
            (
              err?: Error | null,
              result?: protos.google.protobuf.Empty | null,
            ) => {
              if (err) {
                reject(err);
              } else {
                resolve(result);
              }
            },
          )
          .catch(err => {
            throw err;
          });
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      assert((client.operationsClient.cancelOperation as SinonStub).getCall(0));
    });
    it('invokes cancelOperation with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.CancelOperationRequest(),
      );
      const expectedError = new Error('expected');
      client.operationsClient.cancelOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(async () => {
        await client.cancelOperation(request);
      }, expectedError);
      assert(
        (client.operationsClient.cancelOperation as SinonStub)
          .getCall(0)
          .calledWith(request),
      );
    });
  });
  describe('deleteOperation', () => {
    it('invokes deleteOperation without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.DeleteOperationRequest(),
      );
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.operationsClient.deleteOperation =
        stubSimpleCall(expectedResponse);
      const response = await client.deleteOperation(request);
      assert.deepStrictEqual(response, [expectedResponse]);
      assert(
        (client.operationsClient.deleteOperation as SinonStub)
          .getCall(0)
          .calledWith(request),
      );
    });
    it('invokes deleteOperation without error using callback', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.DeleteOperationRequest(),
      );
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.operationsClient.deleteOperation = sinon
        .stub()
        .callsArgWith(2, null, expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.operationsClient
          .deleteOperation(
            request,
            undefined,
            (
              err?: Error | null,
              result?: protos.google.protobuf.Empty | null,
            ) => {
              if (err) {
                reject(err);
              } else {
                resolve(result);
              }
            },
          )
          .catch(err => {
            throw err;
          });
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      assert((client.operationsClient.deleteOperation as SinonStub).getCall(0));
    });
    it('invokes deleteOperation with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.DeleteOperationRequest(),
      );
      const expectedError = new Error('expected');
      client.operationsClient.deleteOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(async () => {
        await client.deleteOperation(request);
      }, expectedError);
      assert(
        (client.operationsClient.deleteOperation as SinonStub)
          .getCall(0)
          .calledWith(request),
      );
    });
  });
  describe('listOperationsAsync', () => {
    it('uses async iteration with listOperations without error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.ListOperationsRequest(),
      );
      const expectedResponse = [
        generateSampleMessage(
          new operationsProtos.google.longrunning.ListOperationsResponse(),
        ),
        generateSampleMessage(
          new operationsProtos.google.longrunning.ListOperationsResponse(),
        ),
        generateSampleMessage(
          new operationsProtos.google.longrunning.ListOperationsResponse(),
        ),
      ];
      client.operationsClient.descriptor.listOperations.asyncIterate =
        stubAsyncIterationCall(expectedResponse);
      const responses: operationsProtos.google.longrunning.IOperation[] = [];
      const iterable = client.operationsClient.listOperationsAsync(request);
      for await (const resource of iterable) {
        responses.push(resource!);
      }
      assert.deepStrictEqual(responses, expectedResponse);
      assert.deepStrictEqual(
        (
          client.operationsClient.descriptor.listOperations
            .asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
    });
    it('uses async iteration with listOperations with error', async () => {
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.ListOperationsRequest(),
      );
      const expectedError = new Error('expected');
      client.operationsClient.descriptor.listOperations.asyncIterate =
        stubAsyncIterationCall(undefined, expectedError);
      const iterable = client.operationsClient.listOperationsAsync(request);
      await assert.rejects(async () => {
        const responses: operationsProtos.google.longrunning.IOperation[] = [];
        for await (const resource of iterable) {
          responses.push(resource!);
        }
      });
      assert.deepStrictEqual(
        (
          client.operationsClient.descriptor.listOperations
            .asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
    });
  });

  describe('Path templates', () => {
    describe('backup', async () => {
      const fakePath = '/rendered/path/backup';
      const expectedParameters = {
        project: 'projectValue',
        instance: 'instanceValue',
        backup: 'backupValue',
      };
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      client.pathTemplates.backupPathTemplate.render = sinon
        .stub()
        .returns(fakePath);
      client.pathTemplates.backupPathTemplate.match = sinon
        .stub()
        .returns(expectedParameters);

      it('backupPath', () => {
        const result = client.backupPath(
          'projectValue',
          'instanceValue',
          'backupValue',
        );
        assert.strictEqual(result, fakePath);
        assert(
          (client.pathTemplates.backupPathTemplate.render as SinonStub)
            .getCall(-1)
            .calledWith(expectedParameters),
        );
      });

      it('matchProjectFromBackupName', () => {
        const result = client.matchProjectFromBackupName(fakePath);
        assert.strictEqual(result, 'projectValue');
        assert(
          (client.pathTemplates.backupPathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });

      it('matchInstanceFromBackupName', () => {
        const result = client.matchInstanceFromBackupName(fakePath);
        assert.strictEqual(result, 'instanceValue');
        assert(
          (client.pathTemplates.backupPathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });

      it('matchBackupFromBackupName', () => {
        const result = client.matchBackupFromBackupName(fakePath);
        assert.strictEqual(result, 'backupValue');
        assert(
          (client.pathTemplates.backupPathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });
    });

    describe('backupSchedule', async () => {
      const fakePath = '/rendered/path/backupSchedule';
      const expectedParameters = {
        project: 'projectValue',
        instance: 'instanceValue',
        database: 'databaseValue',
        schedule: 'scheduleValue',
      };
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      client.pathTemplates.backupSchedulePathTemplate.render = sinon
        .stub()
        .returns(fakePath);
      client.pathTemplates.backupSchedulePathTemplate.match = sinon
        .stub()
        .returns(expectedParameters);

      it('backupSchedulePath', () => {
        const result = client.backupSchedulePath(
          'projectValue',
          'instanceValue',
          'databaseValue',
          'scheduleValue',
        );
        assert.strictEqual(result, fakePath);
        assert(
          (client.pathTemplates.backupSchedulePathTemplate.render as SinonStub)
            .getCall(-1)
            .calledWith(expectedParameters),
        );
      });

      it('matchProjectFromBackupScheduleName', () => {
        const result = client.matchProjectFromBackupScheduleName(fakePath);
        assert.strictEqual(result, 'projectValue');
        assert(
          (client.pathTemplates.backupSchedulePathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });

      it('matchInstanceFromBackupScheduleName', () => {
        const result = client.matchInstanceFromBackupScheduleName(fakePath);
        assert.strictEqual(result, 'instanceValue');
        assert(
          (client.pathTemplates.backupSchedulePathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });

      it('matchDatabaseFromBackupScheduleName', () => {
        const result = client.matchDatabaseFromBackupScheduleName(fakePath);
        assert.strictEqual(result, 'databaseValue');
        assert(
          (client.pathTemplates.backupSchedulePathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });

      it('matchScheduleFromBackupScheduleName', () => {
        const result = client.matchScheduleFromBackupScheduleName(fakePath);
        assert.strictEqual(result, 'scheduleValue');
        assert(
          (client.pathTemplates.backupSchedulePathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });
    });

    describe('cryptoKey', async () => {
      const fakePath = '/rendered/path/cryptoKey';
      const expectedParameters = {
        project: 'projectValue',
        location: 'locationValue',
        key_ring: 'keyRingValue',
        crypto_key: 'cryptoKeyValue',
      };
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      client.pathTemplates.cryptoKeyPathTemplate.render = sinon
        .stub()
        .returns(fakePath);
      client.pathTemplates.cryptoKeyPathTemplate.match = sinon
        .stub()
        .returns(expectedParameters);

      it('cryptoKeyPath', () => {
        const result = client.cryptoKeyPath(
          'projectValue',
          'locationValue',
          'keyRingValue',
          'cryptoKeyValue',
        );
        assert.strictEqual(result, fakePath);
        assert(
          (client.pathTemplates.cryptoKeyPathTemplate.render as SinonStub)
            .getCall(-1)
            .calledWith(expectedParameters),
        );
      });

      it('matchProjectFromCryptoKeyName', () => {
        const result = client.matchProjectFromCryptoKeyName(fakePath);
        assert.strictEqual(result, 'projectValue');
        assert(
          (client.pathTemplates.cryptoKeyPathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });

      it('matchLocationFromCryptoKeyName', () => {
        const result = client.matchLocationFromCryptoKeyName(fakePath);
        assert.strictEqual(result, 'locationValue');
        assert(
          (client.pathTemplates.cryptoKeyPathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });

      it('matchKeyRingFromCryptoKeyName', () => {
        const result = client.matchKeyRingFromCryptoKeyName(fakePath);
        assert.strictEqual(result, 'keyRingValue');
        assert(
          (client.pathTemplates.cryptoKeyPathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });

      it('matchCryptoKeyFromCryptoKeyName', () => {
        const result = client.matchCryptoKeyFromCryptoKeyName(fakePath);
        assert.strictEqual(result, 'cryptoKeyValue');
        assert(
          (client.pathTemplates.cryptoKeyPathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });
    });

    describe('database', async () => {
      const fakePath = '/rendered/path/database';
      const expectedParameters = {
        project: 'projectValue',
        instance: 'instanceValue',
        database: 'databaseValue',
      };
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      client.pathTemplates.databasePathTemplate.render = sinon
        .stub()
        .returns(fakePath);
      client.pathTemplates.databasePathTemplate.match = sinon
        .stub()
        .returns(expectedParameters);

      it('databasePath', () => {
        const result = client.databasePath(
          'projectValue',
          'instanceValue',
          'databaseValue',
        );
        assert.strictEqual(result, fakePath);
        assert(
          (client.pathTemplates.databasePathTemplate.render as SinonStub)
            .getCall(-1)
            .calledWith(expectedParameters),
        );
      });

      it('matchProjectFromDatabaseName', () => {
        const result = client.matchProjectFromDatabaseName(fakePath);
        assert.strictEqual(result, 'projectValue');
        assert(
          (client.pathTemplates.databasePathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });

      it('matchInstanceFromDatabaseName', () => {
        const result = client.matchInstanceFromDatabaseName(fakePath);
        assert.strictEqual(result, 'instanceValue');
        assert(
          (client.pathTemplates.databasePathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });

      it('matchDatabaseFromDatabaseName', () => {
        const result = client.matchDatabaseFromDatabaseName(fakePath);
        assert.strictEqual(result, 'databaseValue');
        assert(
          (client.pathTemplates.databasePathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });
    });

    describe('databaseRole', async () => {
      const fakePath = '/rendered/path/databaseRole';
      const expectedParameters = {
        project: 'projectValue',
        instance: 'instanceValue',
        database: 'databaseValue',
        role: 'roleValue',
      };
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      client.pathTemplates.databaseRolePathTemplate.render = sinon
        .stub()
        .returns(fakePath);
      client.pathTemplates.databaseRolePathTemplate.match = sinon
        .stub()
        .returns(expectedParameters);

      it('databaseRolePath', () => {
        const result = client.databaseRolePath(
          'projectValue',
          'instanceValue',
          'databaseValue',
          'roleValue',
        );
        assert.strictEqual(result, fakePath);
        assert(
          (client.pathTemplates.databaseRolePathTemplate.render as SinonStub)
            .getCall(-1)
            .calledWith(expectedParameters),
        );
      });

      it('matchProjectFromDatabaseRoleName', () => {
        const result = client.matchProjectFromDatabaseRoleName(fakePath);
        assert.strictEqual(result, 'projectValue');
        assert(
          (client.pathTemplates.databaseRolePathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });

      it('matchInstanceFromDatabaseRoleName', () => {
        const result = client.matchInstanceFromDatabaseRoleName(fakePath);
        assert.strictEqual(result, 'instanceValue');
        assert(
          (client.pathTemplates.databaseRolePathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });

      it('matchDatabaseFromDatabaseRoleName', () => {
        const result = client.matchDatabaseFromDatabaseRoleName(fakePath);
        assert.strictEqual(result, 'databaseValue');
        assert(
          (client.pathTemplates.databaseRolePathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });

      it('matchRoleFromDatabaseRoleName', () => {
        const result = client.matchRoleFromDatabaseRoleName(fakePath);
        assert.strictEqual(result, 'roleValue');
        assert(
          (client.pathTemplates.databaseRolePathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });
    });

    describe('instance', async () => {
      const fakePath = '/rendered/path/instance';
      const expectedParameters = {
        project: 'projectValue',
        instance: 'instanceValue',
      };
      const client = new databaseadminModule.v1.DatabaseAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      client.pathTemplates.instancePathTemplate.render = sinon
        .stub()
        .returns(fakePath);
      client.pathTemplates.instancePathTemplate.match = sinon
        .stub()
        .returns(expectedParameters);

      it('instancePath', () => {
        const result = client.instancePath('projectValue', 'instanceValue');
        assert.strictEqual(result, fakePath);
        assert(
          (client.pathTemplates.instancePathTemplate.render as SinonStub)
            .getCall(-1)
            .calledWith(expectedParameters),
        );
      });

      it('matchProjectFromInstanceName', () => {
        const result = client.matchProjectFromInstanceName(fakePath);
        assert.strictEqual(result, 'projectValue');
        assert(
          (client.pathTemplates.instancePathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });

      it('matchInstanceFromInstanceName', () => {
        const result = client.matchInstanceFromInstanceName(fakePath);
        assert.strictEqual(result, 'instanceValue');
        assert(
          (client.pathTemplates.instancePathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });
    });
  });
});
