// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// ** This file is automatically generated by gapic-generator-typescript. **
// ** https://github.com/googleapis/gapic-generator-typescript **
// ** All changes to this file may be overwritten. **

import * as protos from '../protos/protos';
import * as assert from 'assert';
import * as sinon from 'sinon';
import {SinonStub} from 'sinon';
import {describe, it} from 'mocha';
import * as instanceadminModule from '../src';

import {PassThrough} from 'stream';

import {protobuf, LROperation, operationsProtos} from 'google-gax';

// Dynamically loaded proto JSON is needed to get the type information
// to fill in default values for request objects
const root = protobuf.Root.fromJSON(
  require('../protos/protos.json'),
).resolveAll();

// eslint-disable-next-line @typescript-eslint/no-unused-vars
function getTypeDefaultValue(typeName: string, fields: string[]) {
  let type = root.lookupType(typeName) as protobuf.Type;
  for (const field of fields.slice(0, -1)) {
    type = type.fields[field]?.resolvedType as protobuf.Type;
  }
  return type.fields[fields[fields.length - 1]]?.defaultValue;
}

function generateSampleMessage<T extends object>(instance: T) {
  const filledObject = (
    instance.constructor as typeof protobuf.Message
  ).toObject(instance as protobuf.Message<T>, {defaults: true});
  return (instance.constructor as typeof protobuf.Message).fromObject(
    filledObject,
  ) as T;
}

function stubSimpleCall<ResponseType>(response?: ResponseType, error?: Error) {
  return error
    ? sinon.stub().rejects(error)
    : sinon.stub().resolves([response]);
}

function stubSimpleCallWithCallback<ResponseType>(
  response?: ResponseType,
  error?: Error,
) {
  return error
    ? sinon.stub().callsArgWith(2, error)
    : sinon.stub().callsArgWith(2, null, response);
}

function stubLongRunningCall<ResponseType>(
  response?: ResponseType,
  callError?: Error,
  lroError?: Error,
) {
  const innerStub = lroError
    ? sinon.stub().rejects(lroError)
    : sinon.stub().resolves([response]);
  const mockOperation = {
    promise: innerStub,
  };
  return callError
    ? sinon.stub().rejects(callError)
    : sinon.stub().resolves([mockOperation]);
}

function stubLongRunningCallWithCallback<ResponseType>(
  response?: ResponseType,
  callError?: Error,
  lroError?: Error,
) {
  const innerStub = lroError
    ? sinon.stub().rejects(lroError)
    : sinon.stub().resolves([response]);
  const mockOperation = {
    promise: innerStub,
  };
  return callError
    ? sinon.stub().callsArgWith(2, callError)
    : sinon.stub().callsArgWith(2, null, mockOperation);
}

function stubPageStreamingCall<ResponseType>(
  responses?: ResponseType[],
  error?: Error,
) {
  const pagingStub = sinon.stub();
  if (responses) {
    for (let i = 0; i < responses.length; ++i) {
      pagingStub.onCall(i).callsArgWith(2, null, responses[i]);
    }
  }
  const transformStub = error
    ? sinon.stub().callsArgWith(2, error)
    : pagingStub;
  const mockStream = new PassThrough({
    objectMode: true,
    transform: transformStub,
  });
  // trigger as many responses as needed
  if (responses) {
    for (let i = 0; i < responses.length; ++i) {
      setImmediate(() => {
        mockStream.write({});
      });
    }
    setImmediate(() => {
      mockStream.end();
    });
  } else {
    setImmediate(() => {
      mockStream.write({});
    });
    setImmediate(() => {
      mockStream.end();
    });
  }
  return sinon.stub().returns(mockStream);
}

function stubAsyncIterationCall<ResponseType>(
  responses?: ResponseType[],
  error?: Error,
) {
  let counter = 0;
  const asyncIterable = {
    [Symbol.asyncIterator]() {
      return {
        async next() {
          if (error) {
            return Promise.reject(error);
          }
          if (counter >= responses!.length) {
            return Promise.resolve({done: true, value: undefined});
          }
          return Promise.resolve({done: false, value: responses![counter++]});
        },
      };
    },
  };
  return sinon.stub().returns(asyncIterable);
}

describe('v1.InstanceAdminClient', () => {
  describe('Common methods', () => {
    it('has apiEndpoint', () => {
      const client = new instanceadminModule.v1.InstanceAdminClient();
      const apiEndpoint = client.apiEndpoint;
      assert.strictEqual(apiEndpoint, 'spanner.googleapis.com');
    });

    it('has universeDomain', () => {
      const client = new instanceadminModule.v1.InstanceAdminClient();
      const universeDomain = client.universeDomain;
      assert.strictEqual(universeDomain, 'googleapis.com');
    });

    if (
      typeof process === 'object' &&
      typeof process.emitWarning === 'function'
    ) {
      it('throws DeprecationWarning if static servicePath is used', () => {
        const stub = sinon.stub(process, 'emitWarning');
        const servicePath =
          instanceadminModule.v1.InstanceAdminClient.servicePath;
        assert.strictEqual(servicePath, 'spanner.googleapis.com');
        assert(stub.called);
        stub.restore();
      });

      it('throws DeprecationWarning if static apiEndpoint is used', () => {
        const stub = sinon.stub(process, 'emitWarning');
        const apiEndpoint =
          instanceadminModule.v1.InstanceAdminClient.apiEndpoint;
        assert.strictEqual(apiEndpoint, 'spanner.googleapis.com');
        assert(stub.called);
        stub.restore();
      });
    }
    it('sets apiEndpoint according to universe domain camelCase', () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        universeDomain: 'example.com',
      });
      const servicePath = client.apiEndpoint;
      assert.strictEqual(servicePath, 'spanner.example.com');
    });

    it('sets apiEndpoint according to universe domain snakeCase', () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        universe_domain: 'example.com',
      });
      const servicePath = client.apiEndpoint;
      assert.strictEqual(servicePath, 'spanner.example.com');
    });

    if (typeof process === 'object' && 'env' in process) {
      describe('GOOGLE_CLOUD_UNIVERSE_DOMAIN environment variable', () => {
        it('sets apiEndpoint from environment variable', () => {
          const saved = process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
          process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = 'example.com';
          const client = new instanceadminModule.v1.InstanceAdminClient();
          const servicePath = client.apiEndpoint;
          assert.strictEqual(servicePath, 'spanner.example.com');
          if (saved) {
            process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = saved;
          } else {
            delete process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
          }
        });

        it('value configured in code has priority over environment variable', () => {
          const saved = process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
          process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = 'example.com';
          const client = new instanceadminModule.v1.InstanceAdminClient({
            universeDomain: 'configured.example.com',
          });
          const servicePath = client.apiEndpoint;
          assert.strictEqual(servicePath, 'spanner.configured.example.com');
          if (saved) {
            process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'] = saved;
          } else {
            delete process.env['GOOGLE_CLOUD_UNIVERSE_DOMAIN'];
          }
        });
      });
    }
    it('does not allow setting both universeDomain and universe_domain', () => {
      assert.throws(() => {
        new instanceadminModule.v1.InstanceAdminClient({
          universe_domain: 'example.com',
          universeDomain: 'example.net',
        });
      });
    });

    it('has port', () => {
      const port = instanceadminModule.v1.InstanceAdminClient.port;
      assert(port);
      assert(typeof port === 'number');
    });

    it('should create a client with no option', () => {
      const client = new instanceadminModule.v1.InstanceAdminClient();
      assert(client);
    });

    it('should create a client with gRPC fallback', () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        fallback: true,
      });
      assert(client);
    });

    it('has initialize method and supports deferred initialization', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      assert.strictEqual(client.instanceAdminStub, undefined);
      await client.initialize();
      assert(client.instanceAdminStub);
    });

    it('has close method for the initialized client', done => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      client.initialize().catch(err => {
        throw err;
      });
      assert(client.instanceAdminStub);
      client
        .close()
        .then(() => {
          done();
        })
        .catch(err => {
          throw err;
        });
    });

    it('has close method for the non-initialized client', done => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      assert.strictEqual(client.instanceAdminStub, undefined);
      client
        .close()
        .then(() => {
          done();
        })
        .catch(err => {
          throw err;
        });
    });

    it('has getProjectId method', async () => {
      const fakeProjectId = 'fake-project-id';
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      client.auth.getProjectId = sinon.stub().resolves(fakeProjectId);
      const result = await client.getProjectId();
      assert.strictEqual(result, fakeProjectId);
      assert((client.auth.getProjectId as SinonStub).calledWithExactly());
    });

    it('has getProjectId method with callback', async () => {
      const fakeProjectId = 'fake-project-id';
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      client.auth.getProjectId = sinon
        .stub()
        .callsArgWith(0, null, fakeProjectId);
      const promise = new Promise((resolve, reject) => {
        client.getProjectId((err?: Error | null, projectId?: string | null) => {
          if (err) {
            reject(err);
          } else {
            resolve(projectId);
          }
        });
      });
      const result = await promise;
      assert.strictEqual(result, fakeProjectId);
    });
  });

  describe('getInstanceConfig', () => {
    it('invokes getInstanceConfig without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.GetInstanceConfigRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.GetInstanceConfigRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.InstanceConfig(),
      );
      client.innerApiCalls.getInstanceConfig = stubSimpleCall(expectedResponse);
      const [response] = await client.getInstanceConfig(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.getInstanceConfig as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getInstanceConfig as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getInstanceConfig without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.GetInstanceConfigRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.GetInstanceConfigRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.InstanceConfig(),
      );
      client.innerApiCalls.getInstanceConfig =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.getInstanceConfig(
          request,
          (
            err?: Error | null,
            result?: protos.google.spanner.admin.instance.v1.IInstanceConfig | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.getInstanceConfig as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getInstanceConfig as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getInstanceConfig with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.GetInstanceConfigRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.GetInstanceConfigRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.getInstanceConfig = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.getInstanceConfig(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.getInstanceConfig as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getInstanceConfig as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getInstanceConfig with closed client', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.GetInstanceConfigRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.GetInstanceConfigRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.getInstanceConfig(request), expectedError);
    });
  });

  describe('deleteInstanceConfig', () => {
    it('invokes deleteInstanceConfig without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.DeleteInstanceConfigRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.DeleteInstanceConfigRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.innerApiCalls.deleteInstanceConfig =
        stubSimpleCall(expectedResponse);
      const [response] = await client.deleteInstanceConfig(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.deleteInstanceConfig as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.deleteInstanceConfig as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes deleteInstanceConfig without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.DeleteInstanceConfigRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.DeleteInstanceConfigRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.innerApiCalls.deleteInstanceConfig =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.deleteInstanceConfig(
          request,
          (
            err?: Error | null,
            result?: protos.google.protobuf.IEmpty | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.deleteInstanceConfig as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.deleteInstanceConfig as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes deleteInstanceConfig with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.DeleteInstanceConfigRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.DeleteInstanceConfigRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.deleteInstanceConfig = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.deleteInstanceConfig(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.deleteInstanceConfig as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.deleteInstanceConfig as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes deleteInstanceConfig with closed client', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.DeleteInstanceConfigRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.DeleteInstanceConfigRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.deleteInstanceConfig(request), expectedError);
    });
  });

  describe('getInstance', () => {
    it('invokes getInstance without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.GetInstanceRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.GetInstanceRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.Instance(),
      );
      client.innerApiCalls.getInstance = stubSimpleCall(expectedResponse);
      const [response] = await client.getInstance(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.getInstance as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getInstance as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getInstance without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.GetInstanceRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.GetInstanceRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.Instance(),
      );
      client.innerApiCalls.getInstance =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.getInstance(
          request,
          (
            err?: Error | null,
            result?: protos.google.spanner.admin.instance.v1.IInstance | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.getInstance as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getInstance as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getInstance with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.GetInstanceRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.GetInstanceRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.getInstance = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.getInstance(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.getInstance as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getInstance as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getInstance with closed client', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.GetInstanceRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.GetInstanceRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.getInstance(request), expectedError);
    });
  });

  describe('deleteInstance', () => {
    it('invokes deleteInstance without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.DeleteInstanceRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.DeleteInstanceRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.innerApiCalls.deleteInstance = stubSimpleCall(expectedResponse);
      const [response] = await client.deleteInstance(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.deleteInstance as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.deleteInstance as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes deleteInstance without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.DeleteInstanceRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.DeleteInstanceRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.innerApiCalls.deleteInstance =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.deleteInstance(
          request,
          (
            err?: Error | null,
            result?: protos.google.protobuf.IEmpty | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.deleteInstance as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.deleteInstance as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes deleteInstance with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.DeleteInstanceRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.DeleteInstanceRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.deleteInstance = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.deleteInstance(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.deleteInstance as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.deleteInstance as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes deleteInstance with closed client', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.DeleteInstanceRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.DeleteInstanceRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.deleteInstance(request), expectedError);
    });
  });

  describe('setIamPolicy', () => {
    it('invokes setIamPolicy without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.SetIamPolicyRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.SetIamPolicyRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedHeaderRequestParams = `resource=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.iam.v1.Policy(),
      );
      client.innerApiCalls.setIamPolicy = stubSimpleCall(expectedResponse);
      const [response] = await client.setIamPolicy(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.setIamPolicy as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.setIamPolicy as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes setIamPolicy without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.SetIamPolicyRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.SetIamPolicyRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedHeaderRequestParams = `resource=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.iam.v1.Policy(),
      );
      client.innerApiCalls.setIamPolicy =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.setIamPolicy(
          request,
          (
            err?: Error | null,
            result?: protos.google.iam.v1.IPolicy | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.setIamPolicy as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.setIamPolicy as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes setIamPolicy with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.SetIamPolicyRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.SetIamPolicyRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedHeaderRequestParams = `resource=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.setIamPolicy = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.setIamPolicy(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.setIamPolicy as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.setIamPolicy as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes setIamPolicy with closed client', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.SetIamPolicyRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.SetIamPolicyRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.setIamPolicy(request), expectedError);
    });
  });

  describe('getIamPolicy', () => {
    it('invokes getIamPolicy without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.GetIamPolicyRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.GetIamPolicyRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedHeaderRequestParams = `resource=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.iam.v1.Policy(),
      );
      client.innerApiCalls.getIamPolicy = stubSimpleCall(expectedResponse);
      const [response] = await client.getIamPolicy(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.getIamPolicy as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getIamPolicy as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getIamPolicy without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.GetIamPolicyRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.GetIamPolicyRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedHeaderRequestParams = `resource=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.iam.v1.Policy(),
      );
      client.innerApiCalls.getIamPolicy =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.getIamPolicy(
          request,
          (
            err?: Error | null,
            result?: protos.google.iam.v1.IPolicy | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.getIamPolicy as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getIamPolicy as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getIamPolicy with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.GetIamPolicyRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.GetIamPolicyRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedHeaderRequestParams = `resource=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.getIamPolicy = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.getIamPolicy(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.getIamPolicy as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getIamPolicy as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getIamPolicy with closed client', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.GetIamPolicyRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.GetIamPolicyRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.getIamPolicy(request), expectedError);
    });
  });

  describe('testIamPermissions', () => {
    it('invokes testIamPermissions without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.TestIamPermissionsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.TestIamPermissionsRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedHeaderRequestParams = `resource=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.iam.v1.TestIamPermissionsResponse(),
      );
      client.innerApiCalls.testIamPermissions =
        stubSimpleCall(expectedResponse);
      const [response] = await client.testIamPermissions(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.testIamPermissions as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.testIamPermissions as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes testIamPermissions without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.TestIamPermissionsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.TestIamPermissionsRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedHeaderRequestParams = `resource=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.iam.v1.TestIamPermissionsResponse(),
      );
      client.innerApiCalls.testIamPermissions =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.testIamPermissions(
          request,
          (
            err?: Error | null,
            result?: protos.google.iam.v1.ITestIamPermissionsResponse | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.testIamPermissions as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.testIamPermissions as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes testIamPermissions with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.TestIamPermissionsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.TestIamPermissionsRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedHeaderRequestParams = `resource=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.testIamPermissions = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.testIamPermissions(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.testIamPermissions as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.testIamPermissions as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes testIamPermissions with closed client', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.iam.v1.TestIamPermissionsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.iam.v1.TestIamPermissionsRequest',
        ['resource'],
      );
      request.resource = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.testIamPermissions(request), expectedError);
    });
  });

  describe('getInstancePartition', () => {
    it('invokes getInstancePartition without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.GetInstancePartitionRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.GetInstancePartitionRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.InstancePartition(),
      );
      client.innerApiCalls.getInstancePartition =
        stubSimpleCall(expectedResponse);
      const [response] = await client.getInstancePartition(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.getInstancePartition as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getInstancePartition as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getInstancePartition without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.GetInstancePartitionRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.GetInstancePartitionRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.InstancePartition(),
      );
      client.innerApiCalls.getInstancePartition =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.getInstancePartition(
          request,
          (
            err?: Error | null,
            result?: protos.google.spanner.admin.instance.v1.IInstancePartition | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.getInstancePartition as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getInstancePartition as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getInstancePartition with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.GetInstancePartitionRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.GetInstancePartitionRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.getInstancePartition = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.getInstancePartition(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.getInstancePartition as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.getInstancePartition as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes getInstancePartition with closed client', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.GetInstancePartitionRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.GetInstancePartitionRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(client.getInstancePartition(request), expectedError);
    });
  });

  describe('deleteInstancePartition', () => {
    it('invokes deleteInstancePartition without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.DeleteInstancePartitionRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.DeleteInstancePartitionRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.innerApiCalls.deleteInstancePartition =
        stubSimpleCall(expectedResponse);
      const [response] = await client.deleteInstancePartition(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.deleteInstancePartition as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.deleteInstancePartition as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes deleteInstancePartition without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.DeleteInstancePartitionRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.DeleteInstancePartitionRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.innerApiCalls.deleteInstancePartition =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.deleteInstancePartition(
          request,
          (
            err?: Error | null,
            result?: protos.google.protobuf.IEmpty | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.deleteInstancePartition as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.deleteInstancePartition as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes deleteInstancePartition with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.DeleteInstancePartitionRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.DeleteInstancePartitionRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.deleteInstancePartition = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(
        client.deleteInstancePartition(request),
        expectedError,
      );
      const actualRequest = (
        client.innerApiCalls.deleteInstancePartition as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.deleteInstancePartition as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes deleteInstancePartition with closed client', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.DeleteInstancePartitionRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.DeleteInstancePartitionRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedError = new Error('The client has already been closed.');
      client.close().catch(err => {
        throw err;
      });
      await assert.rejects(
        client.deleteInstancePartition(request),
        expectedError,
      );
    });
  });

  describe('createInstanceConfig', () => {
    it('invokes createInstanceConfig without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.CreateInstanceConfigRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.CreateInstanceConfigRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.createInstanceConfig =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.createInstanceConfig(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.createInstanceConfig as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createInstanceConfig as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes createInstanceConfig without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.CreateInstanceConfigRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.CreateInstanceConfigRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.createInstanceConfig =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.createInstanceConfig(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.spanner.admin.instance.v1.IInstanceConfig,
              protos.google.spanner.admin.instance.v1.ICreateInstanceConfigMetadata
            > | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.spanner.admin.instance.v1.IInstanceConfig,
        protos.google.spanner.admin.instance.v1.ICreateInstanceConfigMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.createInstanceConfig as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createInstanceConfig as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes createInstanceConfig with call error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.CreateInstanceConfigRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.CreateInstanceConfigRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.createInstanceConfig = stubLongRunningCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.createInstanceConfig(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.createInstanceConfig as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createInstanceConfig as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes createInstanceConfig with LRO error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.CreateInstanceConfigRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.CreateInstanceConfigRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.createInstanceConfig = stubLongRunningCall(
        undefined,
        undefined,
        expectedError,
      );
      const [operation] = await client.createInstanceConfig(request);
      await assert.rejects(operation.promise(), expectedError);
      const actualRequest = (
        client.innerApiCalls.createInstanceConfig as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createInstanceConfig as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes checkCreateInstanceConfigProgress without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation(),
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkCreateInstanceConfigProgress(
        expectedResponse.name,
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkCreateInstanceConfigProgress with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(
        client.checkCreateInstanceConfigProgress(''),
        expectedError,
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('updateInstanceConfig', () => {
    it('invokes updateInstanceConfig without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.UpdateInstanceConfigRequest(),
      );
      request.instanceConfig ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.UpdateInstanceConfigRequest',
        ['instanceConfig', 'name'],
      );
      request.instanceConfig.name = defaultValue1;
      const expectedHeaderRequestParams = `instance_config.name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.updateInstanceConfig =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.updateInstanceConfig(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.updateInstanceConfig as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateInstanceConfig as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateInstanceConfig without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.UpdateInstanceConfigRequest(),
      );
      request.instanceConfig ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.UpdateInstanceConfigRequest',
        ['instanceConfig', 'name'],
      );
      request.instanceConfig.name = defaultValue1;
      const expectedHeaderRequestParams = `instance_config.name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.updateInstanceConfig =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.updateInstanceConfig(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.spanner.admin.instance.v1.IInstanceConfig,
              protos.google.spanner.admin.instance.v1.IUpdateInstanceConfigMetadata
            > | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.spanner.admin.instance.v1.IInstanceConfig,
        protos.google.spanner.admin.instance.v1.IUpdateInstanceConfigMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.updateInstanceConfig as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateInstanceConfig as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateInstanceConfig with call error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.UpdateInstanceConfigRequest(),
      );
      request.instanceConfig ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.UpdateInstanceConfigRequest',
        ['instanceConfig', 'name'],
      );
      request.instanceConfig.name = defaultValue1;
      const expectedHeaderRequestParams = `instance_config.name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.updateInstanceConfig = stubLongRunningCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.updateInstanceConfig(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.updateInstanceConfig as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateInstanceConfig as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateInstanceConfig with LRO error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.UpdateInstanceConfigRequest(),
      );
      request.instanceConfig ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.UpdateInstanceConfigRequest',
        ['instanceConfig', 'name'],
      );
      request.instanceConfig.name = defaultValue1;
      const expectedHeaderRequestParams = `instance_config.name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.updateInstanceConfig = stubLongRunningCall(
        undefined,
        undefined,
        expectedError,
      );
      const [operation] = await client.updateInstanceConfig(request);
      await assert.rejects(operation.promise(), expectedError);
      const actualRequest = (
        client.innerApiCalls.updateInstanceConfig as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateInstanceConfig as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes checkUpdateInstanceConfigProgress without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation(),
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkUpdateInstanceConfigProgress(
        expectedResponse.name,
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkUpdateInstanceConfigProgress with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(
        client.checkUpdateInstanceConfigProgress(''),
        expectedError,
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('createInstance', () => {
    it('invokes createInstance without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.CreateInstanceRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.CreateInstanceRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.createInstance =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.createInstance(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.createInstance as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createInstance as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes createInstance without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.CreateInstanceRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.CreateInstanceRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.createInstance =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.createInstance(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.spanner.admin.instance.v1.IInstance,
              protos.google.spanner.admin.instance.v1.ICreateInstanceMetadata
            > | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.spanner.admin.instance.v1.IInstance,
        protos.google.spanner.admin.instance.v1.ICreateInstanceMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.createInstance as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createInstance as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes createInstance with call error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.CreateInstanceRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.CreateInstanceRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.createInstance = stubLongRunningCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.createInstance(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.createInstance as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createInstance as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes createInstance with LRO error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.CreateInstanceRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.CreateInstanceRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.createInstance = stubLongRunningCall(
        undefined,
        undefined,
        expectedError,
      );
      const [operation] = await client.createInstance(request);
      await assert.rejects(operation.promise(), expectedError);
      const actualRequest = (
        client.innerApiCalls.createInstance as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createInstance as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes checkCreateInstanceProgress without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation(),
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkCreateInstanceProgress(
        expectedResponse.name,
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkCreateInstanceProgress with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(
        client.checkCreateInstanceProgress(''),
        expectedError,
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('updateInstance', () => {
    it('invokes updateInstance without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.UpdateInstanceRequest(),
      );
      request.instance ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.UpdateInstanceRequest',
        ['instance', 'name'],
      );
      request.instance.name = defaultValue1;
      const expectedHeaderRequestParams = `instance.name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.updateInstance =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.updateInstance(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.updateInstance as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateInstance as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateInstance without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.UpdateInstanceRequest(),
      );
      request.instance ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.UpdateInstanceRequest',
        ['instance', 'name'],
      );
      request.instance.name = defaultValue1;
      const expectedHeaderRequestParams = `instance.name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.updateInstance =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.updateInstance(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.spanner.admin.instance.v1.IInstance,
              protos.google.spanner.admin.instance.v1.IUpdateInstanceMetadata
            > | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.spanner.admin.instance.v1.IInstance,
        protos.google.spanner.admin.instance.v1.IUpdateInstanceMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.updateInstance as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateInstance as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateInstance with call error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.UpdateInstanceRequest(),
      );
      request.instance ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.UpdateInstanceRequest',
        ['instance', 'name'],
      );
      request.instance.name = defaultValue1;
      const expectedHeaderRequestParams = `instance.name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.updateInstance = stubLongRunningCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.updateInstance(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.updateInstance as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateInstance as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateInstance with LRO error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.UpdateInstanceRequest(),
      );
      request.instance ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.UpdateInstanceRequest',
        ['instance', 'name'],
      );
      request.instance.name = defaultValue1;
      const expectedHeaderRequestParams = `instance.name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.updateInstance = stubLongRunningCall(
        undefined,
        undefined,
        expectedError,
      );
      const [operation] = await client.updateInstance(request);
      await assert.rejects(operation.promise(), expectedError);
      const actualRequest = (
        client.innerApiCalls.updateInstance as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateInstance as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes checkUpdateInstanceProgress without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation(),
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkUpdateInstanceProgress(
        expectedResponse.name,
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkUpdateInstanceProgress with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(
        client.checkUpdateInstanceProgress(''),
        expectedError,
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('createInstancePartition', () => {
    it('invokes createInstancePartition without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.CreateInstancePartitionRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.CreateInstancePartitionRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.createInstancePartition =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.createInstancePartition(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.createInstancePartition as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createInstancePartition as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes createInstancePartition without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.CreateInstancePartitionRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.CreateInstancePartitionRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.createInstancePartition =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.createInstancePartition(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.spanner.admin.instance.v1.IInstancePartition,
              protos.google.spanner.admin.instance.v1.ICreateInstancePartitionMetadata
            > | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.spanner.admin.instance.v1.IInstancePartition,
        protos.google.spanner.admin.instance.v1.ICreateInstancePartitionMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.createInstancePartition as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createInstancePartition as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes createInstancePartition with call error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.CreateInstancePartitionRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.CreateInstancePartitionRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.createInstancePartition = stubLongRunningCall(
        undefined,
        expectedError,
      );
      await assert.rejects(
        client.createInstancePartition(request),
        expectedError,
      );
      const actualRequest = (
        client.innerApiCalls.createInstancePartition as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createInstancePartition as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes createInstancePartition with LRO error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.CreateInstancePartitionRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.CreateInstancePartitionRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.createInstancePartition = stubLongRunningCall(
        undefined,
        undefined,
        expectedError,
      );
      const [operation] = await client.createInstancePartition(request);
      await assert.rejects(operation.promise(), expectedError);
      const actualRequest = (
        client.innerApiCalls.createInstancePartition as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.createInstancePartition as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes checkCreateInstancePartitionProgress without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation(),
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation =
        await client.checkCreateInstancePartitionProgress(
          expectedResponse.name,
        );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkCreateInstancePartitionProgress with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(
        client.checkCreateInstancePartitionProgress(''),
        expectedError,
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('updateInstancePartition', () => {
    it('invokes updateInstancePartition without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.UpdateInstancePartitionRequest(),
      );
      request.instancePartition ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.UpdateInstancePartitionRequest',
        ['instancePartition', 'name'],
      );
      request.instancePartition.name = defaultValue1;
      const expectedHeaderRequestParams = `instance_partition.name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.updateInstancePartition =
        stubLongRunningCall(expectedResponse);
      const [operation] = await client.updateInstancePartition(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.updateInstancePartition as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateInstancePartition as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateInstancePartition without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.UpdateInstancePartitionRequest(),
      );
      request.instancePartition ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.UpdateInstancePartitionRequest',
        ['instancePartition', 'name'],
      );
      request.instancePartition.name = defaultValue1;
      const expectedHeaderRequestParams = `instance_partition.name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.updateInstancePartition =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.updateInstancePartition(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.spanner.admin.instance.v1.IInstancePartition,
              protos.google.spanner.admin.instance.v1.IUpdateInstancePartitionMetadata
            > | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.spanner.admin.instance.v1.IInstancePartition,
        protos.google.spanner.admin.instance.v1.IUpdateInstancePartitionMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.updateInstancePartition as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateInstancePartition as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateInstancePartition with call error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.UpdateInstancePartitionRequest(),
      );
      request.instancePartition ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.UpdateInstancePartitionRequest',
        ['instancePartition', 'name'],
      );
      request.instancePartition.name = defaultValue1;
      const expectedHeaderRequestParams = `instance_partition.name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.updateInstancePartition = stubLongRunningCall(
        undefined,
        expectedError,
      );
      await assert.rejects(
        client.updateInstancePartition(request),
        expectedError,
      );
      const actualRequest = (
        client.innerApiCalls.updateInstancePartition as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateInstancePartition as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes updateInstancePartition with LRO error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.UpdateInstancePartitionRequest(),
      );
      request.instancePartition ??= {};
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.UpdateInstancePartitionRequest',
        ['instancePartition', 'name'],
      );
      request.instancePartition.name = defaultValue1;
      const expectedHeaderRequestParams = `instance_partition.name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.updateInstancePartition = stubLongRunningCall(
        undefined,
        undefined,
        expectedError,
      );
      const [operation] = await client.updateInstancePartition(request);
      await assert.rejects(operation.promise(), expectedError);
      const actualRequest = (
        client.innerApiCalls.updateInstancePartition as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.updateInstancePartition as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes checkUpdateInstancePartitionProgress without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation(),
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation =
        await client.checkUpdateInstancePartitionProgress(
          expectedResponse.name,
        );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkUpdateInstancePartitionProgress with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(
        client.checkUpdateInstancePartitionProgress(''),
        expectedError,
      );
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('moveInstance', () => {
    it('invokes moveInstance without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.MoveInstanceRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.MoveInstanceRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.moveInstance = stubLongRunningCall(expectedResponse);
      const [operation] = await client.moveInstance(request);
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.moveInstance as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.moveInstance as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes moveInstance without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.MoveInstanceRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.MoveInstanceRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedResponse = generateSampleMessage(
        new protos.google.longrunning.Operation(),
      );
      client.innerApiCalls.moveInstance =
        stubLongRunningCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.moveInstance(
          request,
          (
            err?: Error | null,
            result?: LROperation<
              protos.google.spanner.admin.instance.v1.IMoveInstanceResponse,
              protos.google.spanner.admin.instance.v1.IMoveInstanceMetadata
            > | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const operation = (await promise) as LROperation<
        protos.google.spanner.admin.instance.v1.IMoveInstanceResponse,
        protos.google.spanner.admin.instance.v1.IMoveInstanceMetadata
      >;
      const [response] = await operation.promise();
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.moveInstance as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.moveInstance as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes moveInstance with call error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.MoveInstanceRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.MoveInstanceRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.moveInstance = stubLongRunningCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.moveInstance(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.moveInstance as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.moveInstance as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes moveInstance with LRO error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.MoveInstanceRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.MoveInstanceRequest',
        ['name'],
      );
      request.name = defaultValue1;
      const expectedHeaderRequestParams = `name=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.moveInstance = stubLongRunningCall(
        undefined,
        undefined,
        expectedError,
      );
      const [operation] = await client.moveInstance(request);
      await assert.rejects(operation.promise(), expectedError);
      const actualRequest = (
        client.innerApiCalls.moveInstance as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.moveInstance as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes checkMoveInstanceProgress without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation(),
      );
      expectedResponse.name = 'test';
      expectedResponse.response = {type_url: 'url', value: Buffer.from('')};
      expectedResponse.metadata = {type_url: 'url', value: Buffer.from('')};

      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const decodedOperation = await client.checkMoveInstanceProgress(
        expectedResponse.name,
      );
      assert.deepStrictEqual(decodedOperation.name, expectedResponse.name);
      assert(decodedOperation.metadata);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });

    it('invokes checkMoveInstanceProgress with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const expectedError = new Error('expected');

      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.checkMoveInstanceProgress(''), expectedError);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
  });

  describe('listInstanceConfigs', () => {
    it('invokes listInstanceConfigs without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstanceConfigsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstanceConfigsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstanceConfig(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstanceConfig(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstanceConfig(),
        ),
      ];
      client.innerApiCalls.listInstanceConfigs =
        stubSimpleCall(expectedResponse);
      const [response] = await client.listInstanceConfigs(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listInstanceConfigs as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listInstanceConfigs as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listInstanceConfigs without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstanceConfigsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstanceConfigsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstanceConfig(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstanceConfig(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstanceConfig(),
        ),
      ];
      client.innerApiCalls.listInstanceConfigs =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.listInstanceConfigs(
          request,
          (
            err?: Error | null,
            result?:
              | protos.google.spanner.admin.instance.v1.IInstanceConfig[]
              | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listInstanceConfigs as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listInstanceConfigs as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listInstanceConfigs with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstanceConfigsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstanceConfigsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.listInstanceConfigs = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.listInstanceConfigs(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.listInstanceConfigs as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listInstanceConfigs as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listInstanceConfigsStream without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstanceConfigsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstanceConfigsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstanceConfig(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstanceConfig(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstanceConfig(),
        ),
      ];
      client.descriptors.page.listInstanceConfigs.createStream =
        stubPageStreamingCall(expectedResponse);
      const stream = client.listInstanceConfigsStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.spanner.admin.instance.v1.InstanceConfig[] =
          [];
        stream.on(
          'data',
          (
            response: protos.google.spanner.admin.instance.v1.InstanceConfig,
          ) => {
            responses.push(response);
          },
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      const responses = await promise;
      assert.deepStrictEqual(responses, expectedResponse);
      assert(
        (client.descriptors.page.listInstanceConfigs.createStream as SinonStub)
          .getCall(0)
          .calledWith(client.innerApiCalls.listInstanceConfigs, request),
      );
      assert(
        (client.descriptors.page.listInstanceConfigs.createStream as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('invokes listInstanceConfigsStream with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstanceConfigsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstanceConfigsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listInstanceConfigs.createStream =
        stubPageStreamingCall(undefined, expectedError);
      const stream = client.listInstanceConfigsStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.spanner.admin.instance.v1.InstanceConfig[] =
          [];
        stream.on(
          'data',
          (
            response: protos.google.spanner.admin.instance.v1.InstanceConfig,
          ) => {
            responses.push(response);
          },
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      await assert.rejects(promise, expectedError);
      assert(
        (client.descriptors.page.listInstanceConfigs.createStream as SinonStub)
          .getCall(0)
          .calledWith(client.innerApiCalls.listInstanceConfigs, request),
      );
      assert(
        (client.descriptors.page.listInstanceConfigs.createStream as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('uses async iteration with listInstanceConfigs without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstanceConfigsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstanceConfigsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstanceConfig(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstanceConfig(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstanceConfig(),
        ),
      ];
      client.descriptors.page.listInstanceConfigs.asyncIterate =
        stubAsyncIterationCall(expectedResponse);
      const responses: protos.google.spanner.admin.instance.v1.IInstanceConfig[] =
        [];
      const iterable = client.listInstanceConfigsAsync(request);
      for await (const resource of iterable) {
        responses.push(resource!);
      }
      assert.deepStrictEqual(responses, expectedResponse);
      assert.deepStrictEqual(
        (
          client.descriptors.page.listInstanceConfigs.asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (client.descriptors.page.listInstanceConfigs.asyncIterate as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('uses async iteration with listInstanceConfigs with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstanceConfigsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstanceConfigsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listInstanceConfigs.asyncIterate =
        stubAsyncIterationCall(undefined, expectedError);
      const iterable = client.listInstanceConfigsAsync(request);
      await assert.rejects(async () => {
        const responses: protos.google.spanner.admin.instance.v1.IInstanceConfig[] =
          [];
        for await (const resource of iterable) {
          responses.push(resource!);
        }
      });
      assert.deepStrictEqual(
        (
          client.descriptors.page.listInstanceConfigs.asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (client.descriptors.page.listInstanceConfigs.asyncIterate as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });
  });

  describe('listInstanceConfigOperations', () => {
    it('invokes listInstanceConfigOperations without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
      ];
      client.innerApiCalls.listInstanceConfigOperations =
        stubSimpleCall(expectedResponse);
      const [response] = await client.listInstanceConfigOperations(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listInstanceConfigOperations as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listInstanceConfigOperations as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listInstanceConfigOperations without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
      ];
      client.innerApiCalls.listInstanceConfigOperations =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.listInstanceConfigOperations(
          request,
          (
            err?: Error | null,
            result?: protos.google.longrunning.IOperation[] | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listInstanceConfigOperations as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listInstanceConfigOperations as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listInstanceConfigOperations with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.listInstanceConfigOperations = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(
        client.listInstanceConfigOperations(request),
        expectedError,
      );
      const actualRequest = (
        client.innerApiCalls.listInstanceConfigOperations as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listInstanceConfigOperations as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listInstanceConfigOperationsStream without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
      ];
      client.descriptors.page.listInstanceConfigOperations.createStream =
        stubPageStreamingCall(expectedResponse);
      const stream = client.listInstanceConfigOperationsStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.longrunning.Operation[] = [];
        stream.on('data', (response: protos.google.longrunning.Operation) => {
          responses.push(response);
        });
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      const responses = await promise;
      assert.deepStrictEqual(responses, expectedResponse);
      assert(
        (
          client.descriptors.page.listInstanceConfigOperations
            .createStream as SinonStub
        )
          .getCall(0)
          .calledWith(
            client.innerApiCalls.listInstanceConfigOperations,
            request,
          ),
      );
      assert(
        (
          client.descriptors.page.listInstanceConfigOperations
            .createStream as SinonStub
        )
          .getCall(0)
          .args[2].otherArgs.headers['x-goog-request-params'].includes(
            expectedHeaderRequestParams,
          ),
      );
    });

    it('invokes listInstanceConfigOperationsStream with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listInstanceConfigOperations.createStream =
        stubPageStreamingCall(undefined, expectedError);
      const stream = client.listInstanceConfigOperationsStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.longrunning.Operation[] = [];
        stream.on('data', (response: protos.google.longrunning.Operation) => {
          responses.push(response);
        });
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      await assert.rejects(promise, expectedError);
      assert(
        (
          client.descriptors.page.listInstanceConfigOperations
            .createStream as SinonStub
        )
          .getCall(0)
          .calledWith(
            client.innerApiCalls.listInstanceConfigOperations,
            request,
          ),
      );
      assert(
        (
          client.descriptors.page.listInstanceConfigOperations
            .createStream as SinonStub
        )
          .getCall(0)
          .args[2].otherArgs.headers['x-goog-request-params'].includes(
            expectedHeaderRequestParams,
          ),
      );
    });

    it('uses async iteration with listInstanceConfigOperations without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
      ];
      client.descriptors.page.listInstanceConfigOperations.asyncIterate =
        stubAsyncIterationCall(expectedResponse);
      const responses: protos.google.longrunning.IOperation[] = [];
      const iterable = client.listInstanceConfigOperationsAsync(request);
      for await (const resource of iterable) {
        responses.push(resource!);
      }
      assert.deepStrictEqual(responses, expectedResponse);
      assert.deepStrictEqual(
        (
          client.descriptors.page.listInstanceConfigOperations
            .asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (
          client.descriptors.page.listInstanceConfigOperations
            .asyncIterate as SinonStub
        )
          .getCall(0)
          .args[2].otherArgs.headers['x-goog-request-params'].includes(
            expectedHeaderRequestParams,
          ),
      );
    });

    it('uses async iteration with listInstanceConfigOperations with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listInstanceConfigOperations.asyncIterate =
        stubAsyncIterationCall(undefined, expectedError);
      const iterable = client.listInstanceConfigOperationsAsync(request);
      await assert.rejects(async () => {
        const responses: protos.google.longrunning.IOperation[] = [];
        for await (const resource of iterable) {
          responses.push(resource!);
        }
      });
      assert.deepStrictEqual(
        (
          client.descriptors.page.listInstanceConfigOperations
            .asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (
          client.descriptors.page.listInstanceConfigOperations
            .asyncIterate as SinonStub
        )
          .getCall(0)
          .args[2].otherArgs.headers['x-goog-request-params'].includes(
            expectedHeaderRequestParams,
          ),
      );
    });
  });

  describe('listInstances', () => {
    it('invokes listInstances without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.Instance(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.Instance(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.Instance(),
        ),
      ];
      client.innerApiCalls.listInstances = stubSimpleCall(expectedResponse);
      const [response] = await client.listInstances(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listInstances as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listInstances as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listInstances without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.Instance(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.Instance(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.Instance(),
        ),
      ];
      client.innerApiCalls.listInstances =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.listInstances(
          request,
          (
            err?: Error | null,
            result?: protos.google.spanner.admin.instance.v1.IInstance[] | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listInstances as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listInstances as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listInstances with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.listInstances = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(client.listInstances(request), expectedError);
      const actualRequest = (
        client.innerApiCalls.listInstances as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listInstances as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listInstancesStream without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.Instance(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.Instance(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.Instance(),
        ),
      ];
      client.descriptors.page.listInstances.createStream =
        stubPageStreamingCall(expectedResponse);
      const stream = client.listInstancesStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.spanner.admin.instance.v1.Instance[] =
          [];
        stream.on(
          'data',
          (response: protos.google.spanner.admin.instance.v1.Instance) => {
            responses.push(response);
          },
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      const responses = await promise;
      assert.deepStrictEqual(responses, expectedResponse);
      assert(
        (client.descriptors.page.listInstances.createStream as SinonStub)
          .getCall(0)
          .calledWith(client.innerApiCalls.listInstances, request),
      );
      assert(
        (client.descriptors.page.listInstances.createStream as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('invokes listInstancesStream with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listInstances.createStream =
        stubPageStreamingCall(undefined, expectedError);
      const stream = client.listInstancesStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.spanner.admin.instance.v1.Instance[] =
          [];
        stream.on(
          'data',
          (response: protos.google.spanner.admin.instance.v1.Instance) => {
            responses.push(response);
          },
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      await assert.rejects(promise, expectedError);
      assert(
        (client.descriptors.page.listInstances.createStream as SinonStub)
          .getCall(0)
          .calledWith(client.innerApiCalls.listInstances, request),
      );
      assert(
        (client.descriptors.page.listInstances.createStream as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('uses async iteration with listInstances without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.Instance(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.Instance(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.Instance(),
        ),
      ];
      client.descriptors.page.listInstances.asyncIterate =
        stubAsyncIterationCall(expectedResponse);
      const responses: protos.google.spanner.admin.instance.v1.IInstance[] = [];
      const iterable = client.listInstancesAsync(request);
      for await (const resource of iterable) {
        responses.push(resource!);
      }
      assert.deepStrictEqual(responses, expectedResponse);
      assert.deepStrictEqual(
        (
          client.descriptors.page.listInstances.asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (client.descriptors.page.listInstances.asyncIterate as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });

    it('uses async iteration with listInstances with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancesRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancesRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listInstances.asyncIterate =
        stubAsyncIterationCall(undefined, expectedError);
      const iterable = client.listInstancesAsync(request);
      await assert.rejects(async () => {
        const responses: protos.google.spanner.admin.instance.v1.IInstance[] =
          [];
        for await (const resource of iterable) {
          responses.push(resource!);
        }
      });
      assert.deepStrictEqual(
        (
          client.descriptors.page.listInstances.asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (client.descriptors.page.listInstances.asyncIterate as SinonStub)
          .getCall(0)
          .args[2].otherArgs.headers[
            'x-goog-request-params'
          ].includes(expectedHeaderRequestParams),
      );
    });
  });

  describe('listInstancePartitions', () => {
    it('invokes listInstancePartitions without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancePartitionsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancePartitionsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstancePartition(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstancePartition(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstancePartition(),
        ),
      ];
      client.innerApiCalls.listInstancePartitions =
        stubSimpleCall(expectedResponse);
      const [response] = await client.listInstancePartitions(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listInstancePartitions as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listInstancePartitions as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listInstancePartitions without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancePartitionsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancePartitionsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstancePartition(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstancePartition(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstancePartition(),
        ),
      ];
      client.innerApiCalls.listInstancePartitions =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.listInstancePartitions(
          request,
          (
            err?: Error | null,
            result?:
              | protos.google.spanner.admin.instance.v1.IInstancePartition[]
              | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listInstancePartitions as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listInstancePartitions as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listInstancePartitions with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancePartitionsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancePartitionsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.listInstancePartitions = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(
        client.listInstancePartitions(request),
        expectedError,
      );
      const actualRequest = (
        client.innerApiCalls.listInstancePartitions as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listInstancePartitions as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listInstancePartitionsStream without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancePartitionsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancePartitionsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstancePartition(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstancePartition(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstancePartition(),
        ),
      ];
      client.descriptors.page.listInstancePartitions.createStream =
        stubPageStreamingCall(expectedResponse);
      const stream = client.listInstancePartitionsStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.spanner.admin.instance.v1.InstancePartition[] =
          [];
        stream.on(
          'data',
          (
            response: protos.google.spanner.admin.instance.v1.InstancePartition,
          ) => {
            responses.push(response);
          },
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      const responses = await promise;
      assert.deepStrictEqual(responses, expectedResponse);
      assert(
        (
          client.descriptors.page.listInstancePartitions
            .createStream as SinonStub
        )
          .getCall(0)
          .calledWith(client.innerApiCalls.listInstancePartitions, request),
      );
      assert(
        (
          client.descriptors.page.listInstancePartitions
            .createStream as SinonStub
        )
          .getCall(0)
          .args[2].otherArgs.headers['x-goog-request-params'].includes(
            expectedHeaderRequestParams,
          ),
      );
    });

    it('invokes listInstancePartitionsStream with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancePartitionsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancePartitionsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listInstancePartitions.createStream =
        stubPageStreamingCall(undefined, expectedError);
      const stream = client.listInstancePartitionsStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.spanner.admin.instance.v1.InstancePartition[] =
          [];
        stream.on(
          'data',
          (
            response: protos.google.spanner.admin.instance.v1.InstancePartition,
          ) => {
            responses.push(response);
          },
        );
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      await assert.rejects(promise, expectedError);
      assert(
        (
          client.descriptors.page.listInstancePartitions
            .createStream as SinonStub
        )
          .getCall(0)
          .calledWith(client.innerApiCalls.listInstancePartitions, request),
      );
      assert(
        (
          client.descriptors.page.listInstancePartitions
            .createStream as SinonStub
        )
          .getCall(0)
          .args[2].otherArgs.headers['x-goog-request-params'].includes(
            expectedHeaderRequestParams,
          ),
      );
    });

    it('uses async iteration with listInstancePartitions without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancePartitionsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancePartitionsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstancePartition(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstancePartition(),
        ),
        generateSampleMessage(
          new protos.google.spanner.admin.instance.v1.InstancePartition(),
        ),
      ];
      client.descriptors.page.listInstancePartitions.asyncIterate =
        stubAsyncIterationCall(expectedResponse);
      const responses: protos.google.spanner.admin.instance.v1.IInstancePartition[] =
        [];
      const iterable = client.listInstancePartitionsAsync(request);
      for await (const resource of iterable) {
        responses.push(resource!);
      }
      assert.deepStrictEqual(responses, expectedResponse);
      assert.deepStrictEqual(
        (
          client.descriptors.page.listInstancePartitions
            .asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (
          client.descriptors.page.listInstancePartitions
            .asyncIterate as SinonStub
        )
          .getCall(0)
          .args[2].otherArgs.headers['x-goog-request-params'].includes(
            expectedHeaderRequestParams,
          ),
      );
    });

    it('uses async iteration with listInstancePartitions with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancePartitionsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancePartitionsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listInstancePartitions.asyncIterate =
        stubAsyncIterationCall(undefined, expectedError);
      const iterable = client.listInstancePartitionsAsync(request);
      await assert.rejects(async () => {
        const responses: protos.google.spanner.admin.instance.v1.IInstancePartition[] =
          [];
        for await (const resource of iterable) {
          responses.push(resource!);
        }
      });
      assert.deepStrictEqual(
        (
          client.descriptors.page.listInstancePartitions
            .asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (
          client.descriptors.page.listInstancePartitions
            .asyncIterate as SinonStub
        )
          .getCall(0)
          .args[2].otherArgs.headers['x-goog-request-params'].includes(
            expectedHeaderRequestParams,
          ),
      );
    });
  });

  describe('listInstancePartitionOperations', () => {
    it('invokes listInstancePartitionOperations without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
      ];
      client.innerApiCalls.listInstancePartitionOperations =
        stubSimpleCall(expectedResponse);
      const [response] = await client.listInstancePartitionOperations(request);
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listInstancePartitionOperations as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listInstancePartitionOperations as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listInstancePartitionOperations without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
      ];
      client.innerApiCalls.listInstancePartitionOperations =
        stubSimpleCallWithCallback(expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.listInstancePartitionOperations(
          request,
          (
            err?: Error | null,
            result?: protos.google.longrunning.IOperation[] | null,
          ) => {
            if (err) {
              reject(err);
            } else {
              resolve(result);
            }
          },
        );
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      const actualRequest = (
        client.innerApiCalls.listInstancePartitionOperations as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listInstancePartitionOperations as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listInstancePartitionOperations with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.innerApiCalls.listInstancePartitionOperations = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(
        client.listInstancePartitionOperations(request),
        expectedError,
      );
      const actualRequest = (
        client.innerApiCalls.listInstancePartitionOperations as SinonStub
      ).getCall(0).args[0];
      assert.deepStrictEqual(actualRequest, request);
      const actualHeaderRequestParams = (
        client.innerApiCalls.listInstancePartitionOperations as SinonStub
      ).getCall(0).args[1].otherArgs.headers['x-goog-request-params'];
      assert(actualHeaderRequestParams.includes(expectedHeaderRequestParams));
    });

    it('invokes listInstancePartitionOperationsStream without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
      ];
      client.descriptors.page.listInstancePartitionOperations.createStream =
        stubPageStreamingCall(expectedResponse);
      const stream = client.listInstancePartitionOperationsStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.longrunning.Operation[] = [];
        stream.on('data', (response: protos.google.longrunning.Operation) => {
          responses.push(response);
        });
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      const responses = await promise;
      assert.deepStrictEqual(responses, expectedResponse);
      assert(
        (
          client.descriptors.page.listInstancePartitionOperations
            .createStream as SinonStub
        )
          .getCall(0)
          .calledWith(
            client.innerApiCalls.listInstancePartitionOperations,
            request,
          ),
      );
      assert(
        (
          client.descriptors.page.listInstancePartitionOperations
            .createStream as SinonStub
        )
          .getCall(0)
          .args[2].otherArgs.headers['x-goog-request-params'].includes(
            expectedHeaderRequestParams,
          ),
      );
    });

    it('invokes listInstancePartitionOperationsStream with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listInstancePartitionOperations.createStream =
        stubPageStreamingCall(undefined, expectedError);
      const stream = client.listInstancePartitionOperationsStream(request);
      const promise = new Promise((resolve, reject) => {
        const responses: protos.google.longrunning.Operation[] = [];
        stream.on('data', (response: protos.google.longrunning.Operation) => {
          responses.push(response);
        });
        stream.on('end', () => {
          resolve(responses);
        });
        stream.on('error', (err: Error) => {
          reject(err);
        });
      });
      await assert.rejects(promise, expectedError);
      assert(
        (
          client.descriptors.page.listInstancePartitionOperations
            .createStream as SinonStub
        )
          .getCall(0)
          .calledWith(
            client.innerApiCalls.listInstancePartitionOperations,
            request,
          ),
      );
      assert(
        (
          client.descriptors.page.listInstancePartitionOperations
            .createStream as SinonStub
        )
          .getCall(0)
          .args[2].otherArgs.headers['x-goog-request-params'].includes(
            expectedHeaderRequestParams,
          ),
      );
    });

    it('uses async iteration with listInstancePartitionOperations without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedResponse = [
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
        generateSampleMessage(new protos.google.longrunning.Operation()),
      ];
      client.descriptors.page.listInstancePartitionOperations.asyncIterate =
        stubAsyncIterationCall(expectedResponse);
      const responses: protos.google.longrunning.IOperation[] = [];
      const iterable = client.listInstancePartitionOperationsAsync(request);
      for await (const resource of iterable) {
        responses.push(resource!);
      }
      assert.deepStrictEqual(responses, expectedResponse);
      assert.deepStrictEqual(
        (
          client.descriptors.page.listInstancePartitionOperations
            .asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (
          client.descriptors.page.listInstancePartitionOperations
            .asyncIterate as SinonStub
        )
          .getCall(0)
          .args[2].otherArgs.headers['x-goog-request-params'].includes(
            expectedHeaderRequestParams,
          ),
      );
    });

    it('uses async iteration with listInstancePartitionOperations with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new protos.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest(),
      );
      const defaultValue1 = getTypeDefaultValue(
        '.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest',
        ['parent'],
      );
      request.parent = defaultValue1;
      const expectedHeaderRequestParams = `parent=${defaultValue1 ?? ''}`;
      const expectedError = new Error('expected');
      client.descriptors.page.listInstancePartitionOperations.asyncIterate =
        stubAsyncIterationCall(undefined, expectedError);
      const iterable = client.listInstancePartitionOperationsAsync(request);
      await assert.rejects(async () => {
        const responses: protos.google.longrunning.IOperation[] = [];
        for await (const resource of iterable) {
          responses.push(resource!);
        }
      });
      assert.deepStrictEqual(
        (
          client.descriptors.page.listInstancePartitionOperations
            .asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
      assert(
        (
          client.descriptors.page.listInstancePartitionOperations
            .asyncIterate as SinonStub
        )
          .getCall(0)
          .args[2].otherArgs.headers['x-goog-request-params'].includes(
            expectedHeaderRequestParams,
          ),
      );
    });
  });
  describe('getOperation', () => {
    it('invokes getOperation without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.GetOperationRequest(),
      );
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation(),
      );
      client.operationsClient.getOperation = stubSimpleCall(expectedResponse);
      const response = await client.getOperation(request);
      assert.deepStrictEqual(response, [expectedResponse]);
      assert(
        (client.operationsClient.getOperation as SinonStub)
          .getCall(0)
          .calledWith(request),
      );
    });
    it('invokes getOperation without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.GetOperationRequest(),
      );
      const expectedResponse = generateSampleMessage(
        new operationsProtos.google.longrunning.Operation(),
      );
      client.operationsClient.getOperation = sinon
        .stub()
        .callsArgWith(2, null, expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.operationsClient
          .getOperation(
            request,
            undefined,
            (
              err?: Error | null,
              result?: operationsProtos.google.longrunning.Operation | null,
            ) => {
              if (err) {
                reject(err);
              } else {
                resolve(result);
              }
            },
          )
          .catch(err => {
            throw err;
          });
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      assert((client.operationsClient.getOperation as SinonStub).getCall(0));
    });
    it('invokes getOperation with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.GetOperationRequest(),
      );
      const expectedError = new Error('expected');
      client.operationsClient.getOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(async () => {
        await client.getOperation(request);
      }, expectedError);
      assert(
        (client.operationsClient.getOperation as SinonStub)
          .getCall(0)
          .calledWith(request),
      );
    });
  });
  describe('cancelOperation', () => {
    it('invokes cancelOperation without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.CancelOperationRequest(),
      );
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.operationsClient.cancelOperation =
        stubSimpleCall(expectedResponse);
      const response = await client.cancelOperation(request);
      assert.deepStrictEqual(response, [expectedResponse]);
      assert(
        (client.operationsClient.cancelOperation as SinonStub)
          .getCall(0)
          .calledWith(request),
      );
    });
    it('invokes cancelOperation without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.CancelOperationRequest(),
      );
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.operationsClient.cancelOperation = sinon
        .stub()
        .callsArgWith(2, null, expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.operationsClient
          .cancelOperation(
            request,
            undefined,
            (
              err?: Error | null,
              result?: protos.google.protobuf.Empty | null,
            ) => {
              if (err) {
                reject(err);
              } else {
                resolve(result);
              }
            },
          )
          .catch(err => {
            throw err;
          });
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      assert((client.operationsClient.cancelOperation as SinonStub).getCall(0));
    });
    it('invokes cancelOperation with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.CancelOperationRequest(),
      );
      const expectedError = new Error('expected');
      client.operationsClient.cancelOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(async () => {
        await client.cancelOperation(request);
      }, expectedError);
      assert(
        (client.operationsClient.cancelOperation as SinonStub)
          .getCall(0)
          .calledWith(request),
      );
    });
  });
  describe('deleteOperation', () => {
    it('invokes deleteOperation without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.DeleteOperationRequest(),
      );
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.operationsClient.deleteOperation =
        stubSimpleCall(expectedResponse);
      const response = await client.deleteOperation(request);
      assert.deepStrictEqual(response, [expectedResponse]);
      assert(
        (client.operationsClient.deleteOperation as SinonStub)
          .getCall(0)
          .calledWith(request),
      );
    });
    it('invokes deleteOperation without error using callback', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.DeleteOperationRequest(),
      );
      const expectedResponse = generateSampleMessage(
        new protos.google.protobuf.Empty(),
      );
      client.operationsClient.deleteOperation = sinon
        .stub()
        .callsArgWith(2, null, expectedResponse);
      const promise = new Promise((resolve, reject) => {
        client.operationsClient
          .deleteOperation(
            request,
            undefined,
            (
              err?: Error | null,
              result?: protos.google.protobuf.Empty | null,
            ) => {
              if (err) {
                reject(err);
              } else {
                resolve(result);
              }
            },
          )
          .catch(err => {
            throw err;
          });
      });
      const response = await promise;
      assert.deepStrictEqual(response, expectedResponse);
      assert((client.operationsClient.deleteOperation as SinonStub).getCall(0));
    });
    it('invokes deleteOperation with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.DeleteOperationRequest(),
      );
      const expectedError = new Error('expected');
      client.operationsClient.deleteOperation = stubSimpleCall(
        undefined,
        expectedError,
      );
      await assert.rejects(async () => {
        await client.deleteOperation(request);
      }, expectedError);
      assert(
        (client.operationsClient.deleteOperation as SinonStub)
          .getCall(0)
          .calledWith(request),
      );
    });
  });
  describe('listOperationsAsync', () => {
    it('uses async iteration with listOperations without error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.ListOperationsRequest(),
      );
      const expectedResponse = [
        generateSampleMessage(
          new operationsProtos.google.longrunning.ListOperationsResponse(),
        ),
        generateSampleMessage(
          new operationsProtos.google.longrunning.ListOperationsResponse(),
        ),
        generateSampleMessage(
          new operationsProtos.google.longrunning.ListOperationsResponse(),
        ),
      ];
      client.operationsClient.descriptor.listOperations.asyncIterate =
        stubAsyncIterationCall(expectedResponse);
      const responses: operationsProtos.google.longrunning.IOperation[] = [];
      const iterable = client.operationsClient.listOperationsAsync(request);
      for await (const resource of iterable) {
        responses.push(resource!);
      }
      assert.deepStrictEqual(responses, expectedResponse);
      assert.deepStrictEqual(
        (
          client.operationsClient.descriptor.listOperations
            .asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
    });
    it('uses async iteration with listOperations with error', async () => {
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      const request = generateSampleMessage(
        new operationsProtos.google.longrunning.ListOperationsRequest(),
      );
      const expectedError = new Error('expected');
      client.operationsClient.descriptor.listOperations.asyncIterate =
        stubAsyncIterationCall(undefined, expectedError);
      const iterable = client.operationsClient.listOperationsAsync(request);
      await assert.rejects(async () => {
        const responses: operationsProtos.google.longrunning.IOperation[] = [];
        for await (const resource of iterable) {
          responses.push(resource!);
        }
      });
      assert.deepStrictEqual(
        (
          client.operationsClient.descriptor.listOperations
            .asyncIterate as SinonStub
        ).getCall(0).args[1],
        request,
      );
    });
  });

  describe('Path templates', () => {
    describe('instance', async () => {
      const fakePath = '/rendered/path/instance';
      const expectedParameters = {
        project: 'projectValue',
        instance: 'instanceValue',
      };
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      client.pathTemplates.instancePathTemplate.render = sinon
        .stub()
        .returns(fakePath);
      client.pathTemplates.instancePathTemplate.match = sinon
        .stub()
        .returns(expectedParameters);

      it('instancePath', () => {
        const result = client.instancePath('projectValue', 'instanceValue');
        assert.strictEqual(result, fakePath);
        assert(
          (client.pathTemplates.instancePathTemplate.render as SinonStub)
            .getCall(-1)
            .calledWith(expectedParameters),
        );
      });

      it('matchProjectFromInstanceName', () => {
        const result = client.matchProjectFromInstanceName(fakePath);
        assert.strictEqual(result, 'projectValue');
        assert(
          (client.pathTemplates.instancePathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });

      it('matchInstanceFromInstanceName', () => {
        const result = client.matchInstanceFromInstanceName(fakePath);
        assert.strictEqual(result, 'instanceValue');
        assert(
          (client.pathTemplates.instancePathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });
    });

    describe('instanceConfig', async () => {
      const fakePath = '/rendered/path/instanceConfig';
      const expectedParameters = {
        project: 'projectValue',
        instance_config: 'instanceConfigValue',
      };
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      client.pathTemplates.instanceConfigPathTemplate.render = sinon
        .stub()
        .returns(fakePath);
      client.pathTemplates.instanceConfigPathTemplate.match = sinon
        .stub()
        .returns(expectedParameters);

      it('instanceConfigPath', () => {
        const result = client.instanceConfigPath(
          'projectValue',
          'instanceConfigValue',
        );
        assert.strictEqual(result, fakePath);
        assert(
          (client.pathTemplates.instanceConfigPathTemplate.render as SinonStub)
            .getCall(-1)
            .calledWith(expectedParameters),
        );
      });

      it('matchProjectFromInstanceConfigName', () => {
        const result = client.matchProjectFromInstanceConfigName(fakePath);
        assert.strictEqual(result, 'projectValue');
        assert(
          (client.pathTemplates.instanceConfigPathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });

      it('matchInstanceConfigFromInstanceConfigName', () => {
        const result =
          client.matchInstanceConfigFromInstanceConfigName(fakePath);
        assert.strictEqual(result, 'instanceConfigValue');
        assert(
          (client.pathTemplates.instanceConfigPathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });
    });

    describe('instancePartition', async () => {
      const fakePath = '/rendered/path/instancePartition';
      const expectedParameters = {
        project: 'projectValue',
        instance: 'instanceValue',
        instance_partition: 'instancePartitionValue',
      };
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      client.pathTemplates.instancePartitionPathTemplate.render = sinon
        .stub()
        .returns(fakePath);
      client.pathTemplates.instancePartitionPathTemplate.match = sinon
        .stub()
        .returns(expectedParameters);

      it('instancePartitionPath', () => {
        const result = client.instancePartitionPath(
          'projectValue',
          'instanceValue',
          'instancePartitionValue',
        );
        assert.strictEqual(result, fakePath);
        assert(
          (
            client.pathTemplates.instancePartitionPathTemplate
              .render as SinonStub
          )
            .getCall(-1)
            .calledWith(expectedParameters),
        );
      });

      it('matchProjectFromInstancePartitionName', () => {
        const result = client.matchProjectFromInstancePartitionName(fakePath);
        assert.strictEqual(result, 'projectValue');
        assert(
          (
            client.pathTemplates.instancePartitionPathTemplate
              .match as SinonStub
          )
            .getCall(-1)
            .calledWith(fakePath),
        );
      });

      it('matchInstanceFromInstancePartitionName', () => {
        const result = client.matchInstanceFromInstancePartitionName(fakePath);
        assert.strictEqual(result, 'instanceValue');
        assert(
          (
            client.pathTemplates.instancePartitionPathTemplate
              .match as SinonStub
          )
            .getCall(-1)
            .calledWith(fakePath),
        );
      });

      it('matchInstancePartitionFromInstancePartitionName', () => {
        const result =
          client.matchInstancePartitionFromInstancePartitionName(fakePath);
        assert.strictEqual(result, 'instancePartitionValue');
        assert(
          (
            client.pathTemplates.instancePartitionPathTemplate
              .match as SinonStub
          )
            .getCall(-1)
            .calledWith(fakePath),
        );
      });
    });

    describe('project', async () => {
      const fakePath = '/rendered/path/project';
      const expectedParameters = {
        project: 'projectValue',
      };
      const client = new instanceadminModule.v1.InstanceAdminClient({
        credentials: {client_email: 'bogus', private_key: 'bogus'},
        projectId: 'bogus',
      });
      await client.initialize();
      client.pathTemplates.projectPathTemplate.render = sinon
        .stub()
        .returns(fakePath);
      client.pathTemplates.projectPathTemplate.match = sinon
        .stub()
        .returns(expectedParameters);

      it('projectPath', () => {
        const result = client.projectPath('projectValue');
        assert.strictEqual(result, fakePath);
        assert(
          (client.pathTemplates.projectPathTemplate.render as SinonStub)
            .getCall(-1)
            .calledWith(expectedParameters),
        );
      });

      it('matchProjectFromProjectName', () => {
        const result = client.matchProjectFromProjectName(fakePath);
        assert.strictEqual(result, 'projectValue');
        assert(
          (client.pathTemplates.projectPathTemplate.match as SinonStub)
            .getCall(-1)
            .calledWith(fakePath),
        );
      });
    });
  });
});
